/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.onlineconfig;

import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1OnlineConfigAgent {
    private static final String TAG = "[Yodo1OnlineConfigAgent] ";
    private static String VideoAdControl = "Platform_VideoAdControl";
    private static String VideoAdConfig = "Platform_VideoAdConfig";
    private static String VideoAdMasterSwitch = "Platform_VideoAdMasterSwitch";
    private static String InterstitialAdMasterSwitch = "Platform_InterstitialAdMasterSwitch";
    private static String InterstitialAdControl = "Platform_InterstitialAdControl";
    private static String InterstitialAdConfig = "Platform_InterstitialAdConfig";
    private static String InterstitialAdInterval = "Platform_InterstitialAdInterval";
    private static String BannerAdMasterSwitch = "Platform_BannerAdMasterSwitch";
    private static String BannerAdControl = "Platform_BannerAdControl";
    private static String BannerAdConfig = "Platform_BannerAdConfig";
    private static String BannerAdSwitchingCycle = "Platform_BannerAdSwitchingCycle";
    private static String NatoveAdMasterSwitch = "Platform_NativeAdMasterSwitch";
    private static String NativeAdControl = "Platform_NativeAdControl";
    private static String NativeAdConfig = "Platform_NativeAdConfig";
    private static String SplashAdMasterSwitch = "Platform_SplashAdMasterSwitch";
    private static String SplashAdControl = "Platform_SplashAdControl";
    private static String SplashAdConfig = "Platform_SplashAdConfig";
    private static String maxShowTimes = "maxShowTimes";
    private static String ratio = "ratio";
    private static String InterstitialAdTest = "interstitialAdConfig";
    private static String VideoAdTest = "videoAdConfig";
    private static String BannerAdTest = "bannerAdConfig";
    private static String NativeAdTest = "nativeAdConfig";
    private static String SplashAdTest = "splashAdConfig";

    public static String getIntervalConfigParam(AdvertType advertType) {
        String result = "0";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_InterstitialAd && obj != null && !obj.isNull(InterstitialAdInterval)) {
                result = obj.optString(InterstitialAdInterval);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  \u65f6\u95f4\u95f4\u9694: " + result);
        return result;
    }

    public static String getSwitchingCycleConfigParam(AdvertType advertType) {
        String result = "30";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_BannerAd && obj != null && !obj.isNull(BannerAdSwitchingCycle)) {
                result = obj.optString(BannerAdSwitchingCycle);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  \u5faa\u73af\u65f6\u95f4: " + result);
        return result;
    }

    public static String getActiveConfigParam(AdvertType advertType) {
        String result = "off";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_InterstitialAd) {
                if (obj != null && !obj.isNull(InterstitialAdMasterSwitch)) {
                    result = obj.optString(InterstitialAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_BannerAd) {
                if (obj != null && !obj.isNull(BannerAdMasterSwitch)) {
                    result = obj.optString(BannerAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_VideoAd) {
                if (obj != null && !obj.isNull(VideoAdMasterSwitch)) {
                    result = obj.optString(VideoAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_SplashAd) {
                if (obj != null && !obj.isNull(SplashAdMasterSwitch)) {
                    result = obj.optString(SplashAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_NativeAd && obj != null && !obj.isNull(NatoveAdMasterSwitch)) {
                result = obj.optString(NatoveAdMasterSwitch);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  \u5f00\u5173: " + result);
        return result;
    }

    public static String getKeyConfigParam(AdvertType advertType, String advertCode, String key) {
        String result = "";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            JSONObject adconfig = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(InterstitialAdConfig)) {
                        adconfig = new JSONObject(obj.optString(InterstitialAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(BannerAdConfig)) {
                        adconfig = new JSONObject(obj.optString(BannerAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(VideoAdConfig)) {
                        adconfig = new JSONObject(obj.optString(VideoAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(SplashAdConfig)) {
                        adconfig = new JSONObject(obj.optString(SplashAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd && !obj.isNull(NativeAdConfig)) {
                    adconfig = new JSONObject(obj.optString(NativeAdConfig));
                }
                if (adconfig != null) {
                    JSONObject adcode = null;
                    if (!adconfig.isNull(advertCode)) {
                        adcode = adconfig.optJSONObject(advertCode);
                    } else if (!adconfig.isNull(advertCode.toLowerCase())) {
                        adcode = adconfig.optJSONObject(advertCode.toLowerCase());
                    }
                    if (adcode != null && !adcode.isNull(key)) {
                        result = adcode.optString(key);
                    }
                }
            }
            YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  key: " + key + ", value: " + result);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<AdsConfigEntity> getAdsControl(AdvertType advertType) {
        ArrayList<AdsConfigEntity> adsConfigEntities = new ArrayList<AdsConfigEntity>();
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            JSONArray adControl = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(InterstitialAdControl)) {
                        adControl = new JSONArray(obj.optString(InterstitialAdControl));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(BannerAdControl)) {
                        adControl = new JSONArray(obj.optString(BannerAdControl));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(VideoAdControl)) {
                        adControl = new JSONArray(obj.optString(VideoAdControl));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(SplashAdControl)) {
                        adControl = new JSONArray(obj.optString(SplashAdControl));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd && !obj.isNull(NativeAdControl)) {
                    adControl = new JSONArray(obj.optString(NativeAdControl));
                }
                if (adControl != null) {
                    YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  adControl = " + adControl.toString());
                }
                if (adControl != null) {
                    for (int i = 0; i < adControl.length(); ++i) {
                        JSONObject obj_adControl = new JSONObject(adControl.get(i).toString());
                        Iterator advertCodes = obj_adControl.keys();
                        while (advertCodes.hasNext()) {
                            AdsConfigEntity adsConfigEntity = new AdsConfigEntity();
                            String advertCode = ((String)advertCodes.next()).toString();
                            JSONObject obj_advertCode = new JSONObject(obj_adControl.optString(advertCode));
                            if (!obj_advertCode.isNull(ratio)) {
                                String adRatio = obj_advertCode.optString(ratio);
                                adsConfigEntity.setRatio(adRatio);
                            }
                            if (!obj_advertCode.isNull(maxShowTimes)) {
                                String adMaxShowTimes = obj_advertCode.optString(maxShowTimes);
                                adsConfigEntity.setMaxShowTimes(adMaxShowTimes);
                            }
                            adsConfigEntity.setAdvertCode(advertCode.toLowerCase());
                            adsConfigEntities.add(adsConfigEntity);
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (adsConfigEntities != null) {
            YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  Control: " + ((Object)adsConfigEntities).toString());
        }
        return adsConfigEntities;
    }

    public static JSONObject getYodo1AdTestInfo(AdvertType advertType) {
        JSONObject adControl = null;
        try {
            JSONObject adObj;
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonTestData();
            if (obj != null && (adObj = obj.optJSONObject("ad_list")) != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!adObj.isNull(InterstitialAdTest)) {
                        adControl = new JSONObject(adObj.optString(InterstitialAdTest));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!adObj.isNull(BannerAdTest)) {
                        adControl = new JSONObject(adObj.optString(BannerAdTest));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!adObj.isNull(VideoAdTest)) {
                        adControl = new JSONObject(adObj.optString(VideoAdTest));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!adObj.isNull(SplashAdTest)) {
                        adControl = new JSONObject(adObj.optString(SplashAdTest));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd && !adObj.isNull(NativeAdTest)) {
                    adControl = new JSONObject(adObj.optString(NativeAdTest));
                }
                if (adControl != null) {
                    YLog.d("[Yodo1OnlineConfigAgent] [" + advertType.name() + "]  \u6d4b\u8bd5\u5e7f\u544a\u4fe1\u606f: " + adControl.toString());
                }
                return adControl;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum AdvertType {
        Platform_InterstitialAd,
        Platform_VideoAd,
        Platform_BannerAd,
        Platform_NativeAd,
        Platform_SplashAd;

    }
}

