/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.helper;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1ErrorUpdataHelper {
    private static final String TAG = "[Yodo1ErrorUpdataHelper] ";
    private static final String URL_ERROR_REPORT = "https://hades.yodo1api.com/hades/feedback";
    private static JSONArray array = new JSONArray();
    private final String ErrorMsg = "Yodo1ErrorUpdataMsg";
    private final String ErrorRecentMsg = "Yodo1ErrorRecentMsg";
    private List<String> list = new ArrayList<String>();

    private Yodo1ErrorUpdataHelper() {
    }

    public static Yodo1ErrorUpdataHelper getInstance() {
        return Yodo1ErrorUpdataHelperInstance.INSTANCE;
    }

    public void ErrorCollection(Context context, String advertCode, int errorCode, int adErrorCode, String adErrorMsg, AdvertType advertType) {
        YLog.d("[Yodo1ErrorUpdataHelper] AdvertCode:" + advertCode + ", adErrorCode: " + adErrorCode + ", adErrorMessage: " + adErrorMsg);
        String tag = advertCode + "&" + advertType.name();
        if (this.list.contains(tag)) {
            YLog.d("[Yodo1ErrorUpdataHelper] \u5f53\u524d\u4e0a\u62a5\u4fe1\u606f\u4e2d\u5df2\u7ecf\u5305\u542b\u6b64\u5f02\u5e38\u4fe1\u606f\uff0c\u91cd\u590d\u4fe1\u606f\u5c06\u4e0d\u518d\u4fdd\u5b58");
            return;
        }
        this.list.add(tag);
        JSONObject object = new JSONObject();
        try {
            object.put("target", (Object)advertCode);
            object.put("time", System.currentTimeMillis());
            if (advertType == AdvertType.Interstitial) {
                object.put("step_id", (Object)"requestInterstitialAD");
                object.put("step_des", (Object)"\u8bf7\u6c42\u63d2\u5c4f\u5e7f\u544a");
            } else if (advertType == AdvertType.Video) {
                object.put("step_id", (Object)"requestVideoAD");
                object.put("step_des", (Object)"\u8bf7\u6c42\u89c6\u9891\u5e7f\u544a");
            } else if (advertType == AdvertType.Banner) {
                object.put("step_id", (Object)"requestBannerAD");
                object.put("step_des", (Object)"\u5c55\u793aBanner\u5e7f\u544a");
            } else if (advertType == AdvertType.Splash) {
                object.put("step_id", (Object)"requestSplashAD");
                object.put("step_des", (Object)"\u5c55\u793a\u5f00\u5c4f\u5e7f\u544a");
            } else if (advertType == AdvertType.Native) {
                object.put("step_id", (Object)"requestNativeAD");
                object.put("step_des", (Object)"\u8bf7\u6c42\u539f\u751f\u5e7f\u544a");
            }
            if (errorCode == 6) {
                if (adErrorCode == 0 & !TextUtils.isEmpty((CharSequence)adErrorMsg)) {
                    object.put("type_id", (Object)"1003");
                    object.put("type_des", (Object)adErrorMsg);
                } else if (adErrorCode != 0 & TextUtils.isEmpty((CharSequence)adErrorMsg)) {
                    object.put("type_id", adErrorCode);
                    object.put("type_des", (Object)"\u5e7f\u544a\u8bf7\u6c42\u5931\u8d25");
                } else {
                    object.put("type_id", adErrorCode);
                    object.put("type_des", (Object)adErrorMsg);
                }
                object.put("advice_solver", (Object)"it");
            } else if (errorCode == 5) {
                object.put("type_id", (Object)"1000");
                object.put("type_des", (Object)"\u7f3a\u5c11\u53c2\u6570");
                object.put("advice_solver", (Object)"ops");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        array.put((Object)object);
        Yodo1SharedPreferences.put(context, "Yodo1ErrorUpdataMsg", array.toString());
        Yodo1SharedPreferences.put(context, "Yodo1ErrorRecentMsg", object.toString());
    }

    public void updata(final Context context, String appKey) {
        boolean prcy1 = Yodo1Advert.getPrivacy().isHasUserConsent();
        boolean prcy2 = Yodo1Advert.getPrivacy().isAgeRestrictedUser();
        if (prcy2 || !prcy1) {
            YLog.d("[Yodo1ErrorUpdataHelper] \u5f53\u524d\u9690\u79c1\u672a\u540c\u610f\u6216\u8005\u4e3a\u513f\u7ae5, \u9519\u8bef\u4fe1\u606f\u6536\u96c6\u5f00\u5173\u5173\u95ed\uff0c\u6682\u505c\u4e0a\u62a5");
            return;
        }
        boolean adSwitch = YOnlineConfigUtils.isTrunOnErrorUpdataSwitch();
        if (!adSwitch) {
            YLog.d("[Yodo1ErrorUpdataHelper] \u9519\u8bef\u4fe1\u606f\u6536\u96c6\u5f00\u5173\u5173\u95ed\uff0c\u6682\u505c\u4e0a\u62a5");
            return;
        }
        String errorMsg = Yodo1SharedPreferences.getString(context, "Yodo1ErrorUpdataMsg");
        if (TextUtils.isEmpty((CharSequence)errorMsg)) {
            YLog.d("[Yodo1ErrorUpdataHelper] \u672c\u5730\u65e0\u7f13\u5b58\u4fe1\u606f\uff0c\u6682\u505c\u4e0a\u62a5");
            return;
        }
        int net = Yodo1NetWorkUtils.getAPNType(context);
        String net_type = "";
        net_type = net == 1 ? "wifi" : (net == 2 ? "4g" : (net == 3 ? "2g" : "net_error"));
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        JSONObject submitJson = new JSONObject();
        JSONObject dataJson = new JSONObject();
        try {
            JSONArray errJson = new JSONArray(errorMsg);
            dataJson.put("game_appkey", (Object)appKey);
            dataJson.put("game_version", (Object)SysUtils.getVersionName(context));
            dataJson.put("channel", (Object)Yodo1OnlineConfig.ChannelCode);
            dataJson.put("sdk_type", (Object)Yodo1OnlineConfig.SDKTyoe);
            dataJson.put("sdk_version", (Object)Yodo1OnlineConfig.SDKVersion);
            dataJson.put("os", (Object)"android");
            dataJson.put("os_version", (Object)Build.VERSION.RELEASE);
            dataJson.put("device_id", (Object)Yodo1DeviceUtils.getDeviceId(context));
            dataJson.put("device_name", (Object)Build.MODEL);
            dataJson.put("device_country_code", (Object)locale.getCountry());
            dataJson.put("device_language_code", (Object)locale.getLanguage());
            dataJson.put("network", (Object)net_type);
            dataJson.put("error", (Object)errJson);
            long timestamp = System.currentTimeMillis();
            submitJson.put("record", (Object)"client_ad");
            submitJson.put("sign", (Object)MD5EncodeUtil.MD5Encode("client_ad" + timestamp + "yodo1"));
            submitJson.put("timestamp", timestamp);
            submitJson.put("data", (Object)dataJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String submitStr = submitJson.toString();
        YLog.d("[Yodo1ErrorUpdataHelper] Request body: " + submitStr);
        Request<String> request = NoHttp.createStringRequest(URL_ERROR_REPORT, RequestMethod.POST);
        request.setDefineRequestBody(submitStr, "text/plain;charset=UTF-8");
        YLog.d("[Yodo1ErrorUpdataHelper] Sending POST request to " + request.url());
        Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>(){

            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d("[Yodo1ErrorUpdataHelper] Connect onSucceed, the response: " + response.get());
                Yodo1SharedPreferences.put(context, "Yodo1ErrorUpdataMsg", "");
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d("[Yodo1ErrorUpdataHelper] Connect onFailed");
            }
        }, false);
    }

    private static class Yodo1ErrorUpdataHelperInstance {
        private static final Yodo1ErrorUpdataHelper INSTANCE = new Yodo1ErrorUpdataHelper();

        private Yodo1ErrorUpdataHelperInstance() {
        }
    }
}

