/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.helper.Yodo1ErrorUpdataHelper;
import com.yodo1.advert.helper.Yodo1TestHelper;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.utils.AppsflyerUtils;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1Privacy;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Yodo1AdvertHelper {
    private static final String TAG = "[Yodo1AdvertHelper] ";
    private ArrayList<String> playlist_intersital = new ArrayList();
    private ArrayList<AdvertBean> adverts_intersital = new ArrayList();
    private int playtimes_interstitial = 0;
    private long showtimes_interstitial = 0L;
    private ArrayList<String> playlist_video = new ArrayList();
    private ArrayList<AdvertBean> adverts_video = new ArrayList();
    private int playtimes_video = 0;
    private ArrayList<String> playlist_banner = new ArrayList();
    private ArrayList<AdvertBean> adverts_banner = new ArrayList();
    private int playtimes_banner = 0;
    private ArrayList<String> playlist_native = new ArrayList();
    private ArrayList<AdvertBean> adverts_native = new ArrayList();
    private int playtimes_native = 0;
    private long showtimes_native = 0L;
    private ArrayList<String> playlist_splash = new ArrayList();
    private int showAllTimes_splash = 0;
    private boolean initPlayList = false;
    private boolean isInit = false;
    private Yodo1Privacy privacy;
    private boolean isDismissBanner = false;

    private Yodo1AdvertHelper() {
    }

    public static Yodo1AdvertHelper getInstance() {
        return SingletonHolder.singleTon;
    }

    public void setPrivacy(Yodo1Privacy privacy) {
        this.privacy = privacy;
    }

    public void onCreateApplication(Context context) {
        this.initSplashAds(context);
    }

    public void init(final Activity activity, final String appKey) {
        if (this.isInit) {
            YLog.d("[Yodo1AdvertHelper] Yodo1 Ad core has been initialized");
            return;
        }
        if (activity == null || TextUtils.isEmpty((CharSequence)appKey)) {
            YLog.e("[Yodo1AdvertHelper] Yodo1 Ad initialization failed, activity is null or appKey is null, please check your code.");
            return;
        }
        this.isInit = true;
        String activityName = activity.getClass().getName();
        Yodo1SharedPreferences.put((Context)activity, "YODO1_MAIN_CLASS", activityName);
        Yodo1OnlineConfig.getInstance().init((Context)activity, appKey);
        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener(){

            @Override
            public void getDataFinish(int code, String onlineConfig) {
                if (TextUtils.isEmpty((CharSequence)onlineConfig)) {
                    YLog.d("[Yodo1AdvertHelper] \u5728\u7ebf\u53c2\u6570\u6ca1\u62ff\u5230");
                    return;
                }
                Yodo1AdvertHelper.this.loadAdvertPlayList((Context)activity);
                Yodo1AdvertHelper.this.onCreatAdverts(activity, appKey);
            }
        });
    }

    private void loadAdvertPlayList(Context context) {
        if (this.initPlayList) {
            YLog.d("[Yodo1AdvertHelper] Yodo1 Ad list have been loaded");
            return;
        }
        this.initPlayList = true;
        if (YOnlineConfigUtils.isTrunOnAdForChina(context)) {
            YLog.v("[Yodo1AdvertHelper] Yodo1 ads have been configured for simplified Chinese users only.");
            return;
        }
        YLog.d("[Yodo1AdvertHelper] Initialize the Yodo1 Ads list...");
        Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(context);
        this.playtimes_interstitial = 0;
        this.playtimes_video = 0;
        this.playtimes_banner = 0;
        this.playtimes_native = 0;
        this.initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        this.initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        this.initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        this.initAdvertList(context, Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
    }

    private void onCreatAdverts(Activity activity, String gameAppkey) {
        try {
            if (YOnlineConfigUtils.isNeedRequestPermisson()) {
                YLog.v("[Yodo1AdvertHelper] Yodo1 Ad SDK will request the necessary permissions");
                Yodo1PermissonUtils.requestPermisson(activity);
            }
            if (YOnlineConfigUtils.isTestModule((Context)activity) && YOnlineConfigUtils.testDeviceSource((Context)activity).equals("PA")) {
                Yodo1TestHelper.showTestWindow(activity);
            }
            boolean prcy1 = Yodo1Advert.getPrivacy().isHasUserConsent();
            boolean prcy2 = Yodo1Advert.getPrivacy().isAgeRestrictedUser();
            if (!prcy2 && prcy1) {
                Yodo1Analytics.initSDK(activity, gameAppkey);
            }
            Yodo1ErrorUpdataHelper.getInstance().updata((Context)activity, gameAppkey);
            Yodo1Analytics.onEvent("InterstitialAdInit", "", "");
            Yodo1Analytics.onEvent("VideoAdInit", "", "");
            Yodo1Analytics.onEvent("BannerAdInit", "", "");
            Yodo1Analytics.onEvent("NativeAdInit", "", "");
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() == null) continue;
                if (this.privacy != null) {
                    adapter.getValue().setPrivacy(this.privacy, activity);
                }
                adapter.getValue().onCreate(activity);
                String advertCode = adapter.getValue().getAdvertCode();
                String sdkversion = adapter.getValue().getSDKVesion();
                YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] SDK version: " + (TextUtils.isEmpty((CharSequence)sdkversion) ? "Not fetched" : sdkversion));
                Yodo1Analytics.onEvent("BannerAdInitChannel", adapter.getKey(), "");
                Yodo1Analytics.onEvent("NativeAdInitChannel", adapter.getKey(), "");
                Yodo1Analytics.onEvent("VideoAdInitChannel", adapter.getKey(), "");
                Yodo1Analytics.onEvent("InterstitialAdInitChannel", adapter.getKey(), "");
                if (this.playlist_intersital.contains(adapter.getKey())) {
                    adapter.getValue().initInterstitialAd(activity);
                    this.reloadInterstitialAdvert(adapter.getValue(), activity, adapter.getKey());
                }
                if (this.playlist_video.contains(adapter.getKey())) {
                    adapter.getValue().initVideoAd(activity);
                    this.reloadVideoAdvert(adapter.getValue(), activity, adapter.getKey());
                }
                if (this.playlist_native.contains(adapter.getKey())) {
                    adapter.getValue().initNativeAd(activity);
                    this.reloadNativeAdvert(adapter.getValue(), activity, adapter.getKey());
                }
                if (!this.playlist_banner.contains(adapter.getKey())) continue;
                adapter.getValue().initBannerAd(activity);
            }
        }
        catch (Error error) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean showInterstitialAd(final Activity activity, final InterstitialCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showInterstitialAd call ...");
        Yodo1Analytics.onEvent("InterstitialAdShow", "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Show interstitial ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent("InterstitialAdShow", "", "fail");
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }
        if (this.playlist_intersital.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] Show interstitial ad failed, ad list is empty");
            Yodo1Analytics.onEvent("InterstitialAdShow", "", "fail");
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }
        long interval = YOnlineConfigUtils.getIntervalAdvertInterstitial();
        if (System.currentTimeMillis() - this.showtimes_interstitial < interval) {
            YLog.v("[Yodo1AdvertHelper] Show interstitial ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent("InterstitialAdShow", "", "fail");
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }
        String firstCode = this.playlist_intersital.get(0);
        YLog.d("[Yodo1AdvertHelper] The interstitial ads list: " + this.playlist_intersital.toString() + ", first ad code: " + firstCode);
        this.showInterstitialAdByChannel(activity, firstCode, new Yodo1AdCallback(){
            private int index = 0;
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("[Yodo1AdvertHelper] showInterstitialAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);
                switch (eventCode) {
                    case 2: {
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Click", advertCode);
                        callback.onInterstitialClicked();
                        break;
                    }
                    case 0: {
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Close", advertCode);
                        callback.onInterstitialClosed();
                        Yodo1Analytics.onEvent("InterstitialAdShow", "", "close");
                        AppsflyerUtils.AF_Event((Context)activity, "Ad_Monetized", advertCode, "close", "interstitial");
                        break;
                    }
                    case 4: {
                        YLog.d("[Yodo1AdvertHelper] Display [" + advertCode + "] interstitial ad successfully");
                        Yodo1AdvertHelper.this.showtimes_interstitial = System.currentTimeMillis();
                        callback.onInterstitialShowSucceeded();
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "DisPlay", advertCode);
                        break;
                    }
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1AdvertHelper.this.sendMsg((Context)activity, "ShowFailed", advertCode);
                if (this.index < Yodo1AdvertHelper.this.playlist_intersital.size() - 1) {
                    ++this.index;
                    String nextCode = (String)Yodo1AdvertHelper.this.playlist_intersital.get(this.index);
                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] interstitial ad failed, error code:" + errorCode + ", error message: " + errorMsg + ", will try to play [" + nextCode + "] interstitial ad.");
                    Yodo1AdvertHelper.this.showInterstitialAdByChannel(activity, nextCode, this);
                } else {
                    YLog.i("[Yodo1AdvertHelper] No cached interstitial ads successfully");
                    Yodo1Analytics.onEvent("InterstitialAdShow", "", "fail");
                    if (callback != null) {
                        callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    private void showInterstitialAdByChannel(final Activity activity, String advertCode, final Yodo1AdCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showInterstitialAdByChannel call ... advertCode:" + advertCode);
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.v("[Yodo1AdvertHelper] Try to show [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
            callback.onAdError(11, "the network adapter is not exist", advertCode);
            return;
        }
        try {
            Yodo1Analytics.onEvent("InterstitialAdShowChannel", advertCode, "");
            adapter.showIntersititalAdvert(activity, new Yodo1AdCallback(){

                @Override
                public void onEvent(int eventCode, String advertCode) {
                    YLog.d("[Yodo1AdvertHelper] showInterstitialAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                    callback.onEvent(eventCode, advertCode);
                    if (eventCode == 0) {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] interstitial ad successfully, will preloading it again");
                        Yodo1Analytics.onEvent("InterstitialAdShowResultChannel", advertCode, "close");
                        Yodo1AdvertHelper.this.showEnd(AdvertType.Interstitial, advertCode);
                        Yodo1AdvertHelper.this.reloadInterstitialAdvert(adapter, activity, advertCode);
                    } else if (eventCode == 2) {
                        Yodo1Analytics.onEvent("InterstitialAdShowResultChannel", advertCode, "click");
                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    YLog.d("[Yodo1AdvertHelper] showInterstitialAdByChannel onAdError, [" + advertCode + "] interstitial ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                    callback.onAdError(errorCode, errorMsg, advertCode);
                    Yodo1Analytics.onEvent("InterstitialAdShowResultChannel", advertCode, "fail");
                    Yodo1AdvertHelper.this.reloadInterstitialAdvert(adapter, activity, advertCode);
                }
            });
        }
        catch (Exception exception) {
            callback.onAdError(11, "try catch", advertCode);
        }
    }

    public void reloadInterstitialAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Load interstitial ad failed, the network is unavailable.");
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!adapterBase.interstitialAdvertIsLoaded(activity)) {
                    YLog.d("[Yodo1AdvertHelper] loading [" + advertCode + "] interstitial ad");
                    Yodo1Analytics.onEvent("InterstitialAdReloadChannel", advertCode, "");
                    adapterBase.reloadInterstitialAdvert(activity, new Yodo1ReloadCallback(){

                        @Override
                        public void onReloadSuccess(String advertCode) {
                            Yodo1Analytics.onEvent("InterstitialAdReloadResultChannel", advertCode, "success");
                            YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] interstitial ad successfully");
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] interstitial ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);
                            Yodo1Analytics.onEvent("InterstitialAdReloadResultChannel", advertCode, "fail");
                            Yodo1ErrorUpdataHelper.getInstance().ErrorCollection((Context)activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                        }
                    });
                } else {
                    YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] interstitial ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    public boolean interstitialAdIsLoaded(Activity activity) {
        if (this.playlist_intersital.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] No cached interstitial ads, ad list is empty.");
            return false;
        }
        boolean isLoaded = false;
        for (int i = 0; i < this.playlist_intersital.size(); ++i) {
            String advertCode = this.playlist_intersital.get(i);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("[Yodo1AdvertHelper] Try to load [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
                continue;
            }
            if (adapter.interstitialAdvertIsLoaded(activity)) {
                YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] interstitial ad has been loaded");
                isLoaded = true;
                continue;
            }
            YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] interstitial ad preloading failed, will reload it again.");
            this.reloadInterstitialAdvert(adapter, activity, advertCode);
        }
        return isLoaded;
    }

    public boolean showVideoAd(final Activity activity, final VideoCallback callback) {
        Yodo1Analytics.onEvent("VideoAdShow", "", "");
        YLog.d("[Yodo1AdvertHelper] showVideoAd call ...");
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Show rewarded video ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent("VideoAdShow", "", "fail");
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }
        if (this.playlist_video.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] Show rewarded video ad failed, ads list is empty.");
            Yodo1Analytics.onEvent("VideoAdShow", "", "fail");
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }
        String firstCode = this.playlist_video.get(0);
        YLog.d("[Yodo1AdvertHelper] The rewarded video ads list: " + this.playlist_video.toString() + ", first ad code: " + firstCode);
        this.showVideoAdByChannel(activity, firstCode, new Yodo1AdCallback(){
            private int index = 0;
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, final String advertCode) {
                YLog.d("[Yodo1AdvertHelper] showVideoAd onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                switch (eventCode) {
                    case 2: {
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Click", advertCode);
                        callback.onVideoClicked();
                        break;
                    }
                    case 5: {
                        this.isFinish = true;
                        break;
                    }
                    case 0: {
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (isFinish) {
                                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] rewarded video ad completely");
                                    callback.onVideoClosed(true);
                                    Yodo1AdvertHelper.this.sendMsg((Context)activity, "Finish", advertCode);
                                    Yodo1Analytics.onEvent("VideoAdShow", "", "finish");
                                    AppsflyerUtils.AF_Event((Context)activity, "Ad_Monetized", advertCode, "finish", "video");
                                } else {
                                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] rewarded video ad incompletely, the ad is skiped");
                                    callback.onVideoClosed(false);
                                    Yodo1AdvertHelper.this.sendMsg((Context)activity, "Close", advertCode);
                                    Yodo1Analytics.onEvent("VideoAdShow", "", "close");
                                    AppsflyerUtils.AF_Event((Context)activity, "Ad_Monetized", advertCode, "close", "video");
                                }
                            }
                        }, 500L);
                        break;
                    }
                    case 4: {
                        YLog.d("[Yodo1AdvertHelper] Display [" + advertCode + "] rewarded video ad successfully");
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "DisPlay", advertCode);
                        callback.onVideoShow();
                    }
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1AdvertHelper.this.sendMsg((Context)activity, "ShowFailed", advertCode);
                if (this.index < Yodo1AdvertHelper.this.playlist_video.size() - 1) {
                    ++this.index;
                    String nextCode = (String)Yodo1AdvertHelper.this.playlist_video.get(this.index);
                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] rewarded video ad failed, will try to play [" + nextCode + "] rewarded video ad.");
                    Yodo1AdvertHelper.this.showVideoAdByChannel(activity, nextCode, this);
                } else {
                    YLog.i("[Yodo1AdvertHelper] No cached rewarded video ads successfully");
                    Yodo1Analytics.onEvent("VideoAdShow", "", "fail");
                    if (callback != null) {
                        callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    private void showVideoAdByChannel(final Activity activity, final String advertCode, final Yodo1AdCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showVideoAdByChannel call ...");
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("[Yodo1AdvertHelper] Try to show [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
            callback.onAdError(11, "the network adapter is not exist", advertCode);
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Analytics.onEvent("VideoAdShowChannel", advertCode, "");
                adapter.showVideoAdvert(activity, new Yodo1AdCallback(){

                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] showVideoAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);
                        if (eventCode == 5) {
                            Yodo1Analytics.onEvent("VideoAdShowResultChannel", advertCode, "finish");
                            Yodo1AdvertHelper.this.showEnd(AdvertType.Video, advertCode);
                        } else if (eventCode == 0) {
                            Yodo1Analytics.onEvent("VideoAdShowResultChannel", advertCode, "close");
                            YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] rewarded video ad has been shown, will preloading it again.");
                            Yodo1AdvertHelper.this.reloadVideoAdvert(adapter, activity, advertCode);
                        } else if (eventCode == 2) {
                            Yodo1Analytics.onEvent("VideoAdShowResultChannel", advertCode, "click");
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] rewarded video ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);
                        Yodo1Analytics.onEvent("VideoAdShowResultChannel", advertCode, "fail");
                        Yodo1AdvertHelper.this.reloadVideoAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    public void reloadVideoAdvert(final AdapterAdvertBase adapterBase, final Activity activity, final String advertCode) {
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Load rewarded video ad failed, the network is unavailable.");
            return;
        }
        if (!Yodo1Advert.loadAdForTypeMobile && Yodo1NetWorkUtils.getConnectedType((Context)activity) != 1) {
            YLog.v("[Yodo1AdvertHelper] Load rewarded video ad failed, ads are no longer requested in non-wifi state.");
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!adapterBase.videoAdvertIsLoaded(activity)) {
                    Yodo1Analytics.onEvent("VideoAdReloadChannel", advertCode, "");
                    adapterBase.reloadVideoAdvert(activity, new Yodo1ReloadCallback(){

                        @Override
                        public void onReloadSuccess(String advertCode) {
                            YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] rewarded video ad successfully");
                            Yodo1Analytics.onEvent("VideoAdReloadResultChannel", advertCode, "success");
                        }

                        @Override
                        public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                            YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] rewarded video ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);
                            Yodo1Analytics.onEvent("VideoAdReloadResultChannel", advertCode, "fail");
                            Yodo1ErrorUpdataHelper.getInstance().ErrorCollection((Context)activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Interstitial);
                        }
                    });
                } else {
                    YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] rewarded video ad has been loaded, don't need to reload it again.");
                }
            }
        });
    }

    public boolean videoAdIsLoaded(Activity activity) {
        YLog.d("[Yodo1AdvertHelper] videoAdIsLoaded call ...");
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] No cached rewarded video ads, the network is unavailable.");
            return false;
        }
        if (this.playlist_video.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] No cached rewarded video ads, ad list is empty.");
            return false;
        }
        boolean isLoaded = false;
        for (int i = 0; i < this.playlist_video.size(); ++i) {
            String advertCode = this.playlist_video.get(i);
            YLog.d("[Yodo1AdvertHelper] adverts_video advertCode :  " + advertCode);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("[Yodo1AdvertHelper] Try to load [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
                continue;
            }
            if (adapter.videoAdvertIsLoaded(activity)) {
                YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] rewarded video ad has been loaded");
                isLoaded = true;
                continue;
            }
            YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] rewarded video ad preloading failed, will reload it again.");
            this.reloadVideoAdvert(adapter, activity, advertCode);
        }
        return isLoaded;
    }

    private void preloadVideoAd(Activity activity, String advertCode) {
        YLog.d("[Yodo1AdvertHelper] preloadVideoAd call ...");
        if (TextUtils.isEmpty((CharSequence)advertCode)) {
            YLog.v("[Yodo1AdvertHelper] Preload rewarded video ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Preload rewarded video ad failed, the network is unavailable.");
            return;
        }
        AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            this.reloadVideoAdvert(adapter, activity, advertCode);
        } else {
            YLog.d("[Yodo1AdvertHelper] Try to preload [" + advertCode + "] rewarded video ad failed, the network adapter is not exist.");
        }
    }

    private void preloadInterstitialAd(Activity activity, String advertCode) {
        YLog.d("[Yodo1AdvertHelper] preloadInterstitialAd call ...");
        if (TextUtils.isEmpty((CharSequence)advertCode)) {
            YLog.v("[Yodo1AdvertHelper] Preload interstitial ad failed, the ad code cannot be empty.");
            return;
        }
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Preload interstitial ad failed, the network is unavailable.");
            return;
        }
        AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter != null) {
            this.reloadInterstitialAdvert(adapter, activity, advertCode);
        } else {
            YLog.d("[Yodo1AdvertHelper] Try to preload [" + advertCode + "] interstitial ad failed, the network adapter is not exist.");
        }
    }

    public void SetBannerAlign(final Activity activity, final int align) {
        YLog.d("[Yodo1AdvertHelper] Yodo1AdvertHelper, SetBannerAlign call ...");
        for (int i = 0; i < this.playlist_banner.size(); ++i) {
            String advertCode = this.playlist_banner.get(i);
            final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) {
                YLog.d("[Yodo1AdvertHelper] Try to set [" + advertCode + "] banner ad align failed, the network adapter is not exist.");
                continue;
            }
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    adapter.setBannerAlign(activity, align);
                }
            });
        }
    }

    public void ShowBanner(final Activity activity, final BannerCallback callback) {
        YLog.d("[Yodo1AdvertHelper] Yodo1AdvertHelper, showBannerAd call ...");
        this.HideBanner(activity);
        Yodo1Analytics.onEvent("BannerAdShow", "", "");
        this.isDismissBanner = false;
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Show banner ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent("BannerAdShow", "", "fail");
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return;
        }
        if (this.playlist_banner.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] Show banner ad failed, ad list is empty.");
            Yodo1Analytics.onEvent("BannerAdShow", "", "fail");
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return;
        }
        final long interval = YOnlineConfigUtils.getSwitchingCycle();
        String advertCode = this.playlist_banner.get(0);
        YLog.d("[Yodo1AdvertHelper] The banner ads list: " + this.playlist_banner.toString() + ", first ad code: " + advertCode);
        this.showBannerAdByChannel(activity, advertCode, interval, new Yodo1AdCallback(){
            private int index = 0;
            private long time = 0L;
            private boolean disPlaySuccessful = false;

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("[Yodo1AdvertHelper] ShowBanne onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                switch (eventCode) {
                    case 2: {
                        callback.onBannerClicked();
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Click", advertCode);
                        break;
                    }
                    case 0: {
                        callback.onBannerClosed();
                        Yodo1AdvertHelper.this.HideBanner(activity);
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Close", advertCode);
                        break;
                    }
                    case 6: {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] banner ad successfully");
                        Yodo1Analytics.onEvent("BannerAdShow", "", "success");
                        this.time = System.currentTimeMillis();
                        YLog.d("[Yodo1AdvertHelper] Time1 == " + this.time + "   " + advertCode);
                        callback.onBannerShow();
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "DisPlay", advertCode);
                        break;
                    }
                    case 4: {
                        if (Yodo1AdvertHelper.this.isDismissBanner) {
                            YLog.d("[Yodo1AdvertHelper] Banner\u5e7f\u544a\u9690\u85cf\u6216\u8005\u5173\u95ed  \u4e2d\u6b62\u5faa\u73af");
                            return;
                        }
                        if (Yodo1AdvertHelper.this.playlist_banner.size() == 1) {
                            YLog.d("[Yodo1AdvertHelper] Banner\u5217\u8868\u552f\u4e00  \u4e2d\u6b62\u5faa\u73af");
                            return;
                        }
                        this.disPlaySuccessful = true;
                        YLog.d("[Yodo1AdvertHelper] Time2 == " + System.currentTimeMillis() + "   " + advertCode);
                        YLog.d("[Yodo1AdvertHelper] Time3 == " + (System.currentTimeMillis() - this.time) + "   " + advertCode);
                        YLog.d("[Yodo1AdvertHelper] Banner\u6b63\u5e38\u64ad\u653e  advertCode == " + advertCode);
                        String nextCode = "";
                        if (this.index < Yodo1AdvertHelper.this.playlist_banner.size() - 1) {
                            ++this.index;
                            nextCode = (String)Yodo1AdvertHelper.this.playlist_banner.get(this.index);
                            YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] banner ad has been shown, will try to play [" + nextCode + "] banner ad.");
                        } else {
                            this.index = 0;
                            nextCode = (String)Yodo1AdvertHelper.this.playlist_banner.get(this.index);
                            YLog.d("[Yodo1AdvertHelper] All banner ads are played finish, in one loop, the ad code: " + nextCode);
                        }
                        Yodo1AdvertHelper.this.HideBanner(activity);
                        Yodo1AdvertHelper.this.showBannerAdByChannel(activity, nextCode, interval, this);
                    }
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1AdvertHelper.this.sendMsg((Context)activity, "ShowFailed", advertCode);
                Yodo1ErrorUpdataHelper.getInstance().ErrorCollection((Context)activity, advertCode, errorCode, 0, errorMsg, AdvertType.Banner);
                if (this.index < Yodo1AdvertHelper.this.playlist_banner.size() - 1) {
                    ++this.index;
                    String nextCode = (String)Yodo1AdvertHelper.this.playlist_banner.get(this.index);
                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] banner ad failed, will try to play [" + nextCode + "] banner ad.");
                    Yodo1AdvertHelper.this.showBannerAdByChannel(activity, nextCode, interval, this);
                } else {
                    YLog.d("[Yodo1AdvertHelper] Show all banner ads failed...");
                    if (this.disPlaySuccessful) {
                        this.disPlaySuccessful = false;
                        this.index = 0;
                        String nextCode = (String)Yodo1AdvertHelper.this.playlist_banner.get(this.index);
                        Yodo1AdvertHelper.this.HideBanner(activity);
                        YLog.d("[Yodo1AdvertHelper] Will try to play [" + nextCode + "] banner ad.");
                        Yodo1AdvertHelper.this.showBannerAdByChannel(activity, nextCode, interval, this);
                    } else {
                        Yodo1Analytics.onEvent("BannerAdShow", "", "fail");
                        callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
    }

    private void showBannerAdByChannel(final Activity activity, String advertCode, final long interval, final Yodo1AdCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showBannerAdByChannel call ..." + advertCode);
        Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "");
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("[Yodo1AdvertHelper] Try to show [" + advertCode + "] banner ad failed, the network adapter is not exist.");
            Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "fail");
            callback.onAdError(0, "the network adapter is not exist", advertCode);
            return;
        }
        if (!this.bannerIsIsLoaded(advertCode)) {
            YLog.d("[Yodo1AdvertHelper] Try to show [" + advertCode + "] banner ad failed, no cached ads.");
            Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "fail");
            callback.onAdError(0, "no cached banner ads", advertCode);
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                adapter.showBanner(activity, new Yodo1AdCallback(){

                    @Override
                    public void onEvent(int eventCode, final String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        switch (eventCode) {
                            case 2: {
                                Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "click");
                                callback.onEvent(2, advertCode);
                                break;
                            }
                            case 0: {
                                callback.onEvent(0, advertCode);
                                break;
                            }
                            case 4: {
                                Yodo1AdvertHelper.this.showEnd(AdvertType.Banner, advertCode);
                                Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "success");
                                callback.onEvent(6, advertCode);
                                YLog.d("[Yodo1AdvertHelper] showBannerAdByChannel \u5207\u6362\u65f6\u95f4 = " + interval);
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        callback.onEvent(4, advertCode);
                                    }
                                }, interval);
                            }
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] banner ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent("BannerAdShowChannel", advertCode, "fail");
                        callback.onAdError(0, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    public boolean bannerIsIsLoaded(String advertCode) {
        AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        return adapter != null && adapter.hasLoadBanner();
    }

    public void RemoveBanner1(Activity activity) {
        this.isDismissBanner = true;
        this.RemoveBanner(activity);
    }

    public void HideBanner1(Activity activity) {
        this.isDismissBanner = true;
        this.HideBanner(activity);
    }

    public void RemoveBanner(Activity activity) {
        YLog.d("[Yodo1AdvertHelper] removeBannerAd call ...");
        for (int i = 0; i < this.playlist_banner.size(); ++i) {
            String advertCode = this.playlist_banner.get(i);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) continue;
            adapter.removeBanner(activity);
        }
    }

    public void HideBanner(Activity activity) {
        YLog.d("[Yodo1AdvertHelper] HideBanner call ...");
        for (int i = 0; i < this.playlist_banner.size(); ++i) {
            String advertCode = this.playlist_banner.get(i);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) continue;
            adapter.hideBanner(activity);
        }
    }

    public boolean showNativeAd(final Activity activity, final float px, final float py, final float pw, final float ph, final NativeCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showNative call ...");
        Yodo1Analytics.onEvent("NativeAdShow", "", "");
        if (!Yodo1NetWorkUtils.isNetworkConnected((Context)activity)) {
            YLog.v("[Yodo1AdvertHelper] Show native ad failed, the network is unavailable.");
            Yodo1Analytics.onEvent("NativeAdShow", "", "fail");
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }
        if (this.playlist_native.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] Show native ad failed, native ad list is null.");
            Yodo1Analytics.onEvent("NativeAdShow", "", "fail");
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }
        long interval = YOnlineConfigUtils.getNativeAdvertInterstitial();
        if (System.currentTimeMillis() - this.showtimes_native < interval) {
            YLog.v("Show native ad failed, ad interval not completed.");
            Yodo1Analytics.onEvent("NativeAdShow", "", "fail");
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }
        String firstCode = this.playlist_native.get(0);
        YLog.d("[Yodo1AdvertHelper] The native ads list: " + this.playlist_native.toString() + ", first ad code: " + firstCode);
        this.showNativeByChannel(activity, firstCode, px, py, pw, ph, new Yodo1AdCallback(){
            private int index = 0;
            private boolean isFinish = false;

            @Override
            public void onEvent(int eventCode, String advertCode) {
                YLog.d("showNativeAd onEvent, event code: " + eventCode + ", advert code: " + advertCode);
                switch (eventCode) {
                    case 2: {
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Click", advertCode);
                        callback.onNativeClicked();
                        Yodo1Analytics.onEvent("NativeAdShow", "", "click");
                        break;
                    }
                    case 0: {
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "Close", advertCode);
                        callback.onNativeClosed();
                        Yodo1Analytics.onEvent("NativeAdShow", "", "close");
                        break;
                    }
                    case 4: {
                        Yodo1AdvertHelper.this.showtimes_native = System.currentTimeMillis();
                        callback.onNativeShow();
                        YLog.d("[Yodo1AdvertHelper] Display [" + advertCode + "] native(\u539f\u751f\u5e7f\u544a) ad successfully");
                        Yodo1AdvertHelper.this.sendMsg((Context)activity, "DisPlay", advertCode);
                        break;
                    }
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1AdvertHelper.this.sendMsg((Context)activity, "ShowFailed", advertCode);
                if (this.index < Yodo1AdvertHelper.this.playlist_native.size() - 1) {
                    ++this.index;
                    String nextCode = (String)Yodo1AdvertHelper.this.playlist_native.get(this.index);
                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] native(\u539f\u751f\u5e7f\u544a) ad failed, will try to play [" + nextCode + "] native ad.");
                    Yodo1AdvertHelper.this.showNativeByChannel(activity, nextCode, px, py, pw, ph, this);
                } else {
                    YLog.i("[Yodo1AdvertHelper] No cached native ads successfully");
                    Yodo1Analytics.onEvent("NativeAdShowChannel", "", "fail");
                    if (callback != null) {
                        callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            }
        });
        return true;
    }

    private void showNativeByChannel(final Activity activity, final String advertCode, final float px, final float py, final float pw, final float ph, final Yodo1AdCallback callback) {
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("[Yodo1AdvertHelper] Try to show [" + advertCode + "] native ad failed, the network adapter is not exist.");
            callback.onAdError(2, "the network adapter is not exist", advertCode);
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Analytics.onEvent("NativeAdShowChannel", advertCode, "");
                adapter.showNativeAdvert(activity, px, py, pw, ph, new Yodo1AdCallback(){

                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] showNativeByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        switch (eventCode) {
                            case 2: {
                                Yodo1Analytics.onEvent("NativeAdShowResultChannel", advertCode, "click");
                                callback.onEvent(2, advertCode);
                                break;
                            }
                            case 0: {
                                Yodo1Analytics.onEvent("NativeAdShowResultChannel", advertCode, "close");
                                callback.onEvent(0, advertCode);
                                Yodo1AdvertHelper.this.showEnd(AdvertType.Native, advertCode);
                                Yodo1AdvertHelper.this.reloadNativeAdvert(adapter, activity, advertCode);
                                break;
                            }
                            case 4: {
                                callback.onEvent(4, advertCode);
                            }
                        }
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] native(\u539f\u751f\u5e7f\u544a) ad failed, ErrorCode: " + errorCode + ", ErrorMessage: " + errorMsg);
                        Yodo1Analytics.onEvent("NativeAdShowResultChannel", advertCode, "fail");
                        callback.onAdError(2, errorMsg, advertCode);
                        Yodo1AdvertHelper.this.reloadNativeAdvert(adapter, activity, advertCode);
                    }
                });
            }
        });
    }

    public boolean nativeAdIsLoaded(Activity activity) {
        if (this.playlist_native.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] No cached native ads, ad list is empty.");
            return false;
        }
        boolean isLoaded = false;
        for (int i = 0; i < this.playlist_native.size(); ++i) {
            String advertCode = this.playlist_native.get(i);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) continue;
            if (adapter.nativeAdvertIsLoaded(activity)) {
                YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] native(\u539f\u751f\u5e7f\u544a) ad has been loaded, don't need to reload it again.");
                isLoaded = true;
                continue;
            }
            YLog.d("[Yodo1AdvertHelper] [" + advertCode + "] native(\u539f\u751f\u5e7f\u544a) ad preloading failed, will reload it again.");
            this.reloadNativeAdvert(adapter, activity, advertCode);
        }
        return isLoaded;
    }

    public void reloadNativeAdvert(final AdapterAdvertBase adapterBase, final Activity activity, String advertCode) {
        Yodo1Analytics.onEvent("NativeAdReloadResultChannel", advertCode, "");
        YLog.d("[Yodo1AdvertHelper] reloadNativeAdvert: " + advertCode);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                adapterBase.reloadNativeAdvert(activity, new Yodo1ReloadCallback(){

                    @Override
                    public void onReloadSuccess(String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] native ad successfully");
                        Yodo1Analytics.onEvent("NativeAdReloadResultChannel", advertCode, "success");
                    }

                    @Override
                    public void onReloadFailed(int errorCode, int adErrorCode, String adErrorMsg, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Load [" + advertCode + "] native ad failed, ErrorCode: " + adErrorCode + ", ErrorMessage: " + adErrorMsg);
                        Yodo1Analytics.onEvent("NativeAdReloadResultChannel", advertCode, "fail");
                        Yodo1ErrorUpdataHelper.getInstance().ErrorCollection((Context)activity, advertCode, errorCode, adErrorCode, adErrorMsg, AdvertType.Native);
                    }
                });
            }
        });
    }

    public void removeNativeAd(Activity activity) {
        for (int i = 0; i < this.playlist_native.size(); ++i) {
            String advertCode = this.playlist_native.get(i);
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter == null) continue;
            adapter.removeNativeAdvert(activity);
        }
    }

    private void initSplashAds(Context activity) {
        int i;
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd)) {
            YLog.d("[Yodo1AdvertHelper] Init splash ad failed, the switch is trun off.");
            return;
        }
        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        for (int i2 = adList.size() - 1; i2 >= 0; --i2) {
            String advertCode = adList.get(i2).getAdvertCode();
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) continue;
            adList.remove(i2);
        }
        if (adList.size() == 0) {
            YLog.d("[Yodo1AdvertHelper] Init splash ad failed, SplashAdControl is empty.");
            return;
        }
        int save_time = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowFirstTimes") + 1;
        String showFirstTime = Yodo1OnlineConfig.getInstance().getConfigParam("Platform_SplashAdShowFirstTimes", "1");
        int time = Integer.valueOf(showFirstTime);
        Yodo1SharedPreferences.put(activity, "Platform_SplashAdShowFirstTimes", save_time);
        if (time > save_time) {
            YLog.d("[Yodo1AdvertHelper] \u7b2c" + time + "\u6b21\u542f\u52a8\u5f00\u59cb\u5c55\u793a\u5f00\u5c4f\u5e7f\u544a");
            return;
        }
        ArrayList<String> priorityList = new ArrayList<String>();
        ArrayList<String> behindList = new ArrayList<String>();
        this.showAllTimes_splash = Yodo1SharedPreferences.getInt(activity, "Platform_SplashAdShowAllTimes");
        int splash_total = 0;
        for (i = 0; i < adList.size(); ++i) {
            int showTimes = Integer.valueOf(adList.get(i).getRatio());
            splash_total += showTimes;
        }
        for (i = 0; i < adList.size(); ++i) {
            int showTimes_online;
            float ratio_online;
            if (this.showAllTimes_splash == 0) {
                priorityList.add(adList.get(i).getAdvertCode());
                continue;
            }
            String adCode = adList.get(i).getAdvertCode();
            int showTimes_local = Yodo1SharedPreferences.getInt(activity, adList.get(i).getAdvertCode().toLowerCase());
            float ratio_local = (float)showTimes_local / (float)this.showAllTimes_splash;
            if (ratio_local < (ratio_online = (float)(showTimes_online = Integer.valueOf(adList.get(i).getRatio()).intValue()) / (float)splash_total)) {
                priorityList.add(adCode);
                continue;
            }
            behindList.add(adCode);
        }
        this.playlist_splash.addAll(priorityList);
        this.playlist_splash.addAll(behindList);
        YLog.d("[Yodo1AdvertHelper] The Splash ads list: " + this.playlist_splash.toString());
    }

    public boolean showSplashAd(final Activity activity, final SplashCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showSplashAd call ...");
        if (this.playlist_splash.size() == 0) {
            YLog.v("[Yodo1AdvertHelper] Show splash ads is failed, ad list is empty.");
            callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
            return false;
        }
        String advertCode = this.playlist_splash.get(0);
        YLog.d("[Yodo1AdvertHelper] showSplashAdByChannel: " + advertCode);
        this.showSplashAdByChannel(activity, advertCode, new Yodo1AdCallback(){
            private int index = 0;

            @Override
            public void onEvent(int eventCode, String advertCode) {
                switch (eventCode) {
                    case 2: {
                        callback.onSplashClicked();
                        break;
                    }
                    case 0: {
                        callback.onSplashClosed();
                        break;
                    }
                    case 4: {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] Splash ad successfully");
                        callback.onSplashShow();
                        int showTimes_local = Yodo1SharedPreferences.getInt((Context)activity, advertCode.toLowerCase());
                        Yodo1SharedPreferences.put((Context)activity, advertCode.toLowerCase(), showTimes_local + 1);
                        Yodo1SharedPreferences.put((Context)activity, "Platform_SplashAdShowAllTimes", Yodo1AdvertHelper.this.showAllTimes_splash + 1);
                    }
                }
            }

            @Override
            public void onAdError(int errorCode, String errorMsg, String advertCode) {
                Yodo1ErrorUpdataHelper.getInstance().ErrorCollection((Context)activity, advertCode, errorCode, 0, errorMsg, AdvertType.Splash);
                if (this.index < Yodo1AdvertHelper.this.playlist_splash.size() - 1) {
                    ++this.index;
                    String nextCode = (String)Yodo1AdvertHelper.this.playlist_splash.get(this.index);
                    YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] Splash ad failed, will try to play [" + nextCode + "] interstitial ad.");
                    Yodo1AdvertHelper.this.showSplashAdByChannel(activity, nextCode, this);
                } else {
                    YLog.d("[Yodo1AdvertHelper] Show all Splash ads failed...");
                    callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                }
            }
        });
        return true;
    }

    private void showSplashAdByChannel(final Activity activity, String advertCode, final Yodo1AdCallback callback) {
        YLog.d("[Yodo1AdvertHelper] showInterstitialAdByChannel call ...");
        final AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
        if (adapter == null) {
            YLog.d("[Yodo1AdvertHelper] Try to show [" + advertCode + "] splash ad failed, the network adapter is not exist.");
            callback.onAdError(11, "the network adapter is not exist", advertCode);
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                adapter.showSplashAdvert(activity, new Yodo1AdCallback(){

                    @Override
                    public void onEvent(int eventCode, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] showSplashAdByChannel onEvent, event code: " + eventCode + ", ad code: " + advertCode);
                        callback.onEvent(eventCode, advertCode);
                    }

                    @Override
                    public void onAdError(int errorCode, String errorMsg, String advertCode) {
                        YLog.d("[Yodo1AdvertHelper] Show [" + advertCode + "] splash ad failed, ErrorCode " + errorCode + ", ErrorMessage: " + errorMsg);
                        callback.onAdError(errorCode, errorMsg, advertCode);
                    }
                });
            }
        });
    }

    private void showEnd(AdvertType advertType, String adCode) {
        YLog.d("[Yodo1AdvertHelper] showEnd call ...");
        String advertCode = adCode.toLowerCase();
        if (advertType == AdvertType.Interstitial) {
            ++this.playtimes_interstitial;
            YLog.d("[Yodo1AdvertHelper] Interstitial\u603b\u5171\u64ad\u653e\u4e86" + this.playtimes_interstitial + "\u6b21");
            for (int i = 0; i < this.adverts_intersital.size(); ++i) {
                if (TextUtils.isEmpty((CharSequence)this.adverts_intersital.get((int)i).advertCode) || !this.adverts_intersital.get((int)i).advertCode.equals(advertCode)) continue;
                ++this.adverts_intersital.get((int)i).played;
                YLog.d("[Yodo1AdvertHelper] \u5f53\u524d[" + advertCode + "]\u64ad\u653e\u4e86" + this.adverts_intersital.get((int)i).played + "\u6b21");
            }
            this.sortAdvert(this.adverts_intersital, this.playlist_intersital, this.playtimes_interstitial);
        } else if (advertType == AdvertType.Video) {
            ++this.playtimes_video;
            YLog.d("[Yodo1AdvertHelper] Video\u603b\u5171\u64ad\u653e\u4e86" + this.playtimes_video + "\u6b21");
            for (int i = 0; i < this.adverts_video.size(); ++i) {
                if (TextUtils.isEmpty((CharSequence)this.adverts_video.get((int)i).advertCode) || !this.adverts_video.get((int)i).advertCode.equals(advertCode)) continue;
                ++this.adverts_video.get((int)i).played;
                YLog.d("[Yodo1AdvertHelper] \u5f53\u524d[" + advertCode + "]\u64ad\u653e\u4e86" + this.adverts_video.get((int)i).played + "\u6b21");
            }
            this.sortAdvert(this.adverts_video, this.playlist_video, this.playtimes_video);
        } else if (advertType == AdvertType.Banner) {
            ++this.playtimes_banner;
            YLog.d("[Yodo1AdvertHelper] Banner\u603b\u5171\u64ad\u653e\u4e86" + this.playtimes_banner + "\u6b21");
            for (int i = 0; i < this.adverts_banner.size(); ++i) {
                if (!this.adverts_banner.get((int)i).advertCode.equals(advertCode)) continue;
                ++this.adverts_banner.get((int)i).played;
                YLog.d("[Yodo1AdvertHelper] \u5f53\u524d[" + advertCode + "]\u64ad\u653e\u4e86" + this.adverts_banner.get((int)i).played + "\u6b21");
            }
            this.sortAdvert(this.adverts_banner, this.playlist_banner, this.playtimes_banner);
        } else if (advertType == AdvertType.Native) {
            ++this.playtimes_native;
            YLog.d("[Yodo1AdvertHelper] Native\u603b\u5171\u64ad\u653e\u4e86" + this.playtimes_native + "\u6b21");
            for (int i = 0; i < this.adverts_native.size(); ++i) {
                if (!this.adverts_native.get((int)i).advertCode.equals(advertCode)) continue;
                ++this.adverts_native.get((int)i).played;
                YLog.d("[Yodo1AdvertHelper] \u5f53\u524d[" + advertCode + "]\u64ad\u653e\u4e86" + this.adverts_native.get((int)i).played + "\u6b21");
            }
            this.sortAdvert(this.adverts_native, this.playlist_native, this.playtimes_native);
        }
    }

    private void sortAdvert(ArrayList<AdvertBean> advertsLst, ArrayList<String> playList, int playtimes) {
        AdvertBean bean;
        int i;
        YLog.d("[Yodo1AdvertHelper] sortAdvert call ...");
        if (playList != null) {
            playList.clear();
        } else {
            playList = new ArrayList();
        }
        ArrayList<String> overAdvert = new ArrayList<String>();
        ArrayList<String> overMaxAdvert = new ArrayList<String>();
        ArrayList<AdvertBean> fixAdvert = new ArrayList<AdvertBean>();
        for (i = 0; i < advertsLst.size(); ++i) {
            bean = advertsLst.get(i);
            YLog.d(TAG + bean.advertCode + "   \u64ad\u653e\u6b21\u6570\u4e3a : " + bean.played);
            YLog.d(TAG + bean.advertCode + "   \u6700\u5927\u64ad\u653e\u6b21\u6570\u4e3a : " + bean.maxPlayeTimes);
            if (bean.maxPlayeTimes != -1 && bean.played >= bean.maxPlayeTimes) {
                overMaxAdvert.add(bean.advertCode);
                YLog.d(TAG + bean.advertCode + " \u5df2\u64ad\u653e\u81f3\u6700\u5927\u64ad\u653e\u6b21\u6570  \u64ad\u653e\u6b21\u6570\u4e3a : " + bean.maxPlayeTimes);
                continue;
            }
            if (bean.percentage == 0.0f) {
                playList.add(bean.advertCode);
                YLog.d(TAG + bean.advertCode + " \u653e\u5165\u5bf9\u9996 ");
                continue;
            }
            YLog.d(TAG + bean.advertCode + " \u9700\u8fdb\u5165\u6392\u5e8f\u961f\u5217 ");
            fixAdvert.add(bean);
        }
        for (i = 0; i < fixAdvert.size(); ++i) {
            bean = (AdvertBean)fixAdvert.get(i);
            float percentage_played = (float)bean.played / (float)playtimes;
            YLog.d(TAG + bean.advertCode + " percentage_played : " + percentage_played);
            YLog.d(TAG + bean.advertCode + " bean.percentage : " + bean.percentage);
            if (percentage_played < bean.percentage) {
                playList.add(bean.advertCode);
                continue;
            }
            overAdvert.add(bean.advertCode);
        }
        if (overAdvert.size() > 0) {
            playList.addAll(overAdvert);
        }
        if (overMaxAdvert.size() > 0) {
            YLog.d("[Yodo1AdvertHelper] \u8d85\u8fc7\u6700\u5927\u64ad\u653e\u6b21\u6570\u7684\u5e7f\u544a\u5217\u8868 : " + ((Object)overMaxAdvert).toString());
        }
        YLog.d("[Yodo1AdvertHelper] \u6392\u5e8f\u540e playList : " + playList.toString());
    }

    private void initAdvertList(Context context, Yodo1OnlineConfigAgent.AdvertType advertType) {
        int i;
        YLog.d("[Yodo1AdvertHelper] initAdvertList call ...");
        if (!YOnlineConfigUtils.isTrunOnYodo1Ads(advertType)) {
            YLog.v("[Yodo1AdvertHelper] Initialize " + ((Object)((Object)advertType) + "").replace("Platform_", "") + " failed, the switch is turn off.");
            return;
        }
        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(advertType);
        for (int i2 = adList.size() - 1; i2 >= 0; --i2) {
            String advertCode = adList.get(i2).getAdvertCode();
            AdapterAdvertBase adapter = Yodo1AdvertAdapterFactory.getInstance().getAdapters().get(advertCode);
            if (adapter != null) continue;
            adList.remove(i2);
        }
        ArrayList<AdvertBean> advertsLst = null;
        ArrayList<String> playList = null;
        switch (advertType) {
            case Platform_InterstitialAd: {
                advertsLst = this.adverts_intersital;
                playList = this.playlist_intersital;
                break;
            }
            case Platform_VideoAd: {
                advertsLst = this.adverts_video;
                playList = this.playlist_video;
                break;
            }
            case Platform_BannerAd: {
                advertsLst = this.adverts_banner;
                playList = this.playlist_banner;
                break;
            }
            case Platform_NativeAd: {
                advertsLst = this.adverts_native;
                playList = this.playlist_native;
                break;
            }
            default: {
                YLog.v("[Yodo1AdvertHelper] \u521d\u59cb\u5316\u64ad\u653e\u5217\u8868\u5f02\u5e38\uff0c \u4f20\u5165\u7684AdvertType\u4e0d\u6b63\u786e, advertType: " + (Object)((Object)advertType));
                return;
            }
        }
        if (YOnlineConfigUtils.isTestModule(context) && YOnlineConfigUtils.isEmptyTestAdList()) {
            AdvertBean bean = new AdvertBean();
            bean.advertCode = "yodo1";
            bean.weight = 1;
            bean.maxPlayeTimes = -1;
            playList.add(bean.advertCode);
            YLog.d("[Yodo1AdvertHelper] \u521d\u59cb\u5316 Test Mode [" + (Object)((Object)advertType) + "]\u64ad\u653e\u5217\u8868\uff1a" + playList.toString());
            advertsLst.add(bean);
            return;
        }
        float total = 0.0f;
        for (i = 0; i < adList.size(); ++i) {
            String ratio = adList.get(i).getRatio();
            if (TextUtils.isEmpty((CharSequence)ratio) || ratio.equals("-1")) continue;
            total += Float.valueOf(ratio).floatValue();
        }
        for (i = 0; i < adList.size(); ++i) {
            AdvertBean bean = new AdvertBean();
            bean.advertCode = adList.get(i).getAdvertCode();
            bean.weight = i + 1;
            bean.maxPlayeTimes = Integer.valueOf(adList.get(i).getMaxShowTimes());
            float ratio = Float.valueOf(adList.get(i).getRatio()).floatValue();
            if (ratio != -1.0f) {
                bean.percentage = ratio / total;
                YLog.d("[Yodo1AdvertHelper] ratio: " + ratio + ", total: " + total);
            } else {
                bean.percentage = -1.0f;
            }
            YLog.d("[Yodo1AdvertHelper] bean: " + bean.advertCode + ", percentage: " + bean.percentage);
            advertsLst.add(bean);
            playList.add(advertsLst.get((int)i).advertCode);
            YLog.d("[Yodo1AdvertHelper] \u521d\u59cb\u5316[" + (Object)((Object)advertType) + "]\u64ad\u653e\u5217\u8868, \u5e8f\u5217" + (i + 1) + ":" + playList.get(i));
        }
        YLog.d("[Yodo1AdvertHelper] \u521d\u59cb\u5316[" + (Object)((Object)advertType) + "]\u64ad\u653e\u5217\u8868\uff1a" + playList.toString());
    }

    private void sendMsg(Context context, String event, String advertCode) {
    }

    public class AdvertBean {
        public String advertCode;
        public int weight;
        public float percentage;
        public int played = 0;
        public int maxPlayeTimes;
    }

    private static class SingletonHolder {
        private static Yodo1AdvertHelper singleTon = new Yodo1AdvertHelper();

        private SingletonHolder() {
        }
    }
}

