/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.factory;

import android.content.Context;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.sdk.kit.YLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Yodo1AdvertAdapterFactory {
    private static final String TAG = "[Yodo1AdvertAdapterFactory] ";
    private static final String PACKAGE_NAME_ADVERT = "com.yodo1.advert.adapter.AdvertAdapter";
    private static Yodo1AdvertAdapterFactory instance;
    private Map<String, AdapterAdvertBase> _advertAdapters = new HashMap<String, AdapterAdvertBase>();
    private boolean hasInit = false;

    private Yodo1AdvertAdapterFactory() {
    }

    public static Yodo1AdvertAdapterFactory getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertAdapterFactory();
        }
        return instance;
    }

    public Map<String, AdapterAdvertBase> getAdapters() {
        return this._advertAdapters;
    }

    public void initAdvertAdapters(Context context) {
        if (this.hasInit) {
            YLog.v("[Yodo1AdvertAdapterFactory] Yodo1 Ads adapters have been initialized.");
            return;
        }
        this.hasInit = true;
        AdvertTypeBean bean = new AdvertTypeBean(PACKAGE_NAME_ADVERT, AdapterAdvertBase.class, this._advertAdapters);
        this.initAdvertAdapter(context, bean);
    }

    private void initAdvertAdapter(Context context, AdvertTypeBean bean) {
        List<String> advertCodes = this.getAdCodes(context, bean);
        for (int i = 0; i < advertCodes.size(); ++i) {
            try {
                String className = bean.packageName + advertCodes.get(i);
                Class<?> clz = Class.forName(className);
                if (clz != null) {
                    clz.asSubclass(bean.clz);
                    AdapterAdvertBase adapterBase = (AdapterAdvertBase)clz.newInstance();
                    bean.adapters.put(adapterBase.getAdvertCode().toLowerCase(Locale.getDefault()), adapterBase);
                    YLog.d("[Yodo1AdvertAdapterFactory] \u5b9e\u4f8b\u5316\u5e7f\u544a " + className + ", \u5730\u5740 = " + adapterBase);
                    continue;
                }
                YLog.d(TAG + advertCodes.get(i) + " adapter failed to new instance, the adapter is not exist!");
                continue;
            }
            catch (Exception e) {
                YLog.d(TAG + advertCodes.get(i) + " adapter failed to new instance, the adapter is not exist!");
            }
        }
    }

    private List<String> getAdCodes(Context context, AdvertTypeBean bean) {
        ArrayList<AdsConfigEntity> adList = new ArrayList<AdsConfigEntity>();
        List<AdsConfigEntity> adList1 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        List<AdsConfigEntity> adList2 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        List<AdsConfigEntity> adList3 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        List<AdsConfigEntity> adList4 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
        List<AdsConfigEntity> adList5 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        adList.addAll(adList1);
        adList.addAll(adList2);
        adList.addAll(adList3);
        adList.addAll(adList4);
        adList.addAll(adList5);
        ArrayList<String> weight = new ArrayList<String>();
        for (int i = 0; i < adList.size(); ++i) {
            weight.add(((AdsConfigEntity)adList.get(i)).getAdvertCode());
        }
        YLog.d("[Yodo1AdvertAdapterFactory] isTestModule: " + YOnlineConfigUtils.isTestModule(context));
        if (YOnlineConfigUtils.isTestModule(context) && YOnlineConfigUtils.isEmptyTestAdList()) {
            weight.clear();
            weight.add("yodo1");
            YLog.d("[Yodo1AdvertAdapterFactory] \u5df2\u6dfb\u52a0Yodo1\u6d4b\u8bd5\u5e7f\u544a");
            return weight;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(weight.size());
        set.addAll(weight);
        weight.clear();
        weight.addAll(set);
        YLog.d("[Yodo1AdvertAdapterFactory] getAdCodesList " + ((Object)weight).toString());
        return weight;
    }

    private class AdvertTypeBean {
        public String packageName;
        public Class<?> clz;
        public Map<String, AdapterAdvertBase> adapters;

        public AdvertTypeBean(String fullPackageName, Class<?> clz, Map<String, AdapterAdvertBase> adapters) {
            this.packageName = fullPackageName;
            this.clz = clz;
            this.adapters = adapters;
        }
    }
}

