/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.factory;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.factory.Yodo1SplashAdActivity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;
import java.util.Map;

public class Yodo1AdvertActivityObserver
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "[Yodo1AdvertActivityObserver] ";
    String mainClassName = "";

    private boolean isMainActivity(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mainClassName)) {
            this.mainClassName = Yodo1SharedPreferences.getString((Context)activity, "YODO1_MAIN_CLASS");
        }
        return activity.getClass().getName().equals(this.mainClassName);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (!this.isMainActivity(activity)) {
            return;
        }
        YLog.v("[Yodo1AdvertActivityObserver] onActivityCreated");
        YLog.d("[Yodo1AdvertActivityObserver] onActivityCreated, mainClassName = " + this.mainClassName);
        boolean splashAdSwitch = YOnlineConfigUtils.isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
        YLog.d("[Yodo1AdvertActivityObserver] onActivityCreated, SplashAd switch = " + splashAdSwitch);
        if (splashAdSwitch) {
            Intent intent = new Intent((Context)activity, Yodo1SplashAdActivity.class);
            activity.startActivity(intent);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (!this.isMainActivity(activity)) {
            return;
        }
        YLog.v("[Yodo1AdvertActivityObserver] onActivityResumed");
        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener(){

            @Override
            public void getDataFinish(int code, String onlineConfig) {
            }
        });
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
                if (adapter.getValue() == null) continue;
                adapter.getValue().onResume(activity);
            }
            Yodo1Analytics.onResume(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (!this.isMainActivity(activity)) {
            return;
        }
        YLog.v("[Yodo1AdvertActivityObserver] onActivityPaused");
        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() == null) continue;
            adapter.getValue().onPause(activity);
        }
        Yodo1Analytics.onPause(activity);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (!this.isMainActivity(activity)) {
            return;
        }
        YLog.v("[Yodo1AdvertActivityObserver] onActivityDestroyed");
        for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters().entrySet()) {
            if (adapter.getValue() == null) continue;
            adapter.getValue().onDestroy(activity);
        }
        Yodo1Analytics.onDestroy();
        Yodo1HttpManage.getInstance().onDestroy();
    }
}

