/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.cocos;

import android.app.Activity;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.open.Yodo1Advert;

public class CocosYodo1Advert {
    static Activity mainactivity;

    public static void init(Activity activity, String appkey) {
        mainactivity = activity;
        Yodo1Advert.initSDK(mainactivity, appkey);
    }

    public static void setUserConsent(boolean consent) {
        Yodo1Advert.setUserConsent(consent);
    }

    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        Yodo1Advert.setTagForUnderAgeOfConsent(underAgeOfConsent);
    }

    public static void showInterstitial() {
        mainactivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Advert.showInterstitial(mainactivity, new InterstitialCallback(){

                    @Override
                    public void onInterstitialClosed() {
                        CocosYodo1Advert.showInterstitialAdEvent(0);
                    }

                    @Override
                    public void onInterstitialShowSucceeded() {
                        CocosYodo1Advert.showInterstitialAdEvent(4);
                    }

                    @Override
                    public void onInterstitialClicked() {
                        CocosYodo1Advert.showInterstitialAdEvent(2);
                    }

                    @Override
                    public void onInterstitialShowFailed(AdErrorCode arg0) {
                        CocosYodo1Advert.showInterstitialAdEvent(-1);
                    }
                });
            }
        });
    }

    public static boolean hasInter() {
        return Yodo1Advert.interstitialIsReady(mainactivity);
    }

    public static void showVideo() {
        mainactivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (Yodo1Advert.videoIsReady(mainactivity)) {
                    boolean bl = Yodo1Advert.showVideo(mainactivity, new VideoCallback(){

                        @Override
                        public void onVideoClosed(boolean isFinished) {
                            if (isFinished) {
                                CocosYodo1Advert.showVideoEvent(1);
                            } else {
                                CocosYodo1Advert.showVideoEvent(0);
                            }
                        }

                        @Override
                        public void onVideoShow() {
                            CocosYodo1Advert.showVideoEvent(4);
                        }

                        @Override
                        public void onVideoClicked() {
                            CocosYodo1Advert.showVideoEvent(2);
                        }

                        @Override
                        public void onVideoShowFailed(AdErrorCode arg0) {
                            CocosYodo1Advert.showVideoEvent(-1);
                        }
                    });
                }
            }
        });
    }

    public static boolean hasVideo() {
        return Yodo1Advert.videoIsReady(mainactivity);
    }

    public static void setBannerAlign(final Activity activity, final int align) {
        mainactivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Advert.setBannerAlign(activity, align);
            }
        });
    }

    public static void showBanner() {
        mainactivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Advert.showBanner(mainactivity, new BannerCallback(){

                    @Override
                    public void onBannerShowFailed(AdErrorCode arg0) {
                        CocosYodo1Advert.showBanner(-1);
                    }

                    @Override
                    public void onBannerShow() {
                        CocosYodo1Advert.showBanner(4);
                    }

                    @Override
                    public void onBannerClosed() {
                        CocosYodo1Advert.showBanner(0);
                    }

                    @Override
                    public void onBannerClicked() {
                        CocosYodo1Advert.showBanner(2);
                    }
                });
            }
        });
    }

    public static void hideBanner() {
        mainactivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Yodo1Advert.hideBanner(mainactivity);
            }
        });
    }

    public static native void showInterstitialAdEvent(int var0);

    public static native void showVideoEvent(int var0);

    public static native void showBanner(int var0);
}

