/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter.kit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yodo1.advert.adapter.kit.Yodo1CountDownView;
import com.yodo1.advert.adapter.kit.Yodo1VideoAds;
import com.yodo1.advert.adapter.kit.Yodo1VideoCallback;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.RR;
import com.yodo1.sdk.kit.YLog;
import java.io.IOException;

public class Yodo1VPActivity
extends Activity {
    int position = 0;
    private Yodo1CountDownView cdv;
    private SurfaceView surfaceView;
    private RelativeLayout rel_video;
    private RelativeLayout rel_down;
    private ImageView img_bg;
    private ImageView imgclose;
    private Yodo1VideoCallback callback = Yodo1VideoAds.yodo1VideoCallback;
    private Bitmap bm;
    private MediaPlayer player;
    private SurfaceHolder holder;
    private boolean videoPause = false;
    private String videoPath = "";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        int orientation = intent.getIntExtra("orientation", 1);
        if (orientation == 1) {
            this.setRequestedOrientation(1);
        } else {
            this.setRequestedOrientation(0);
        }
        this.getWindow().setFormat(-3);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(RR.layout((Context)this, "yodo1_vp_activity"));
        this.initView();
        this.videoPath = this.getCacheDir().getAbsolutePath() + "/local_video.mp4";
        this.loadLoaingPage(orientation);
    }

    public void initView() {
        this.cdv = (Yodo1CountDownView)this.findViewById(RR.id((Context)this, "yodo1_view_countdowm"));
        this.surfaceView = (SurfaceView)this.findViewById(RR.id((Context)this, "yodo1_surfaceview_player"));
        this.rel_video = (RelativeLayout)this.findViewById(RR.id((Context)this, "yodo1_rel_player"));
        this.rel_down = (RelativeLayout)this.findViewById(RR.id((Context)this, "yodo1_rel_closepage"));
        this.img_bg = (ImageView)this.findViewById(RR.id((Context)this, "yodo1_iv_bgimage"));
        this.imgclose = (ImageView)this.findViewById(RR.id((Context)this, "yodo1_iv_close"));
        this.player = new MediaPlayer();
        this.img_bg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.VIEW");
                Uri uri = Uri.parse((String)"https://yodo1opp.com/");
                intent.setData(uri);
                Yodo1VPActivity.this.startActivity(intent);
            }
        });
        this.imgclose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Yodo1VPActivity.this.callback.onVideoClosed();
                Yodo1VPActivity.this.finish();
            }
        });
        this.surfaceView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Yodo1VPActivity.this.callback.onVideoClicked();
            }
        });
    }

    public void loadVideoView() {
        try {
            this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new MyCallBack());
            this.player.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    Yodo1VPActivity.this.player.start();
                    YLog.d("Yodo1VP  \u64ad\u653e\u6210\u529f \uff1a ");
                    Yodo1VPActivity.this.callback.onVideoShow();
                }
            });
            this.player.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    YLog.d("Yodo1VP  \u64ad\u653e\u5b8c\u6210 \uff1a ");
                    Yodo1VPActivity.this.callback.onVideoFinish();
                    Yodo1VPActivity.this.rel_video.setVisibility(8);
                    Yodo1VPActivity.this.rel_down.setVisibility(0);
                    if (Yodo1VPActivity.this.bm != null) {
                        Yodo1VPActivity.this.img_bg.setImageBitmap(Yodo1VPActivity.this.bm);
                    } else if (Yodo1VPActivity.this.getResources().getConfiguration().orientation == 1) {
                        Yodo1VPActivity.this.img_bg.setImageResource(RR.drawable((Context)Yodo1VPActivity.this, "yodo1splash_portrait"));
                    } else {
                        Yodo1VPActivity.this.img_bg.setImageResource(RR.drawable((Context)Yodo1VPActivity.this, "yodo1splash_landscape"));
                    }
                }
            });
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(this.videoPath);
            String duration = mmr.extractMetadata(9);
            int time = (int)Math.round(Double.valueOf(duration) / 1000.0);
            this.setCdvCountDown(time);
            YLog.d("Yodo1VP  \u5f53\u524d\u89c6\u9891\u603b\u65f6\u957f \uff1a " + duration);
            YLog.d("Yodo1VP  \u5f53\u524d\u89c6\u9891\u603b\u65f6\u957f \uff1a " + time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCdvCountDown(int time) {
        this.cdv.setCountdownTime(time);
        this.cdv.startCountDown();
    }

    protected void onResume() {
        super.onResume();
        if (this.videoPause) {
            this.videoPause = false;
            this.rel_video.setVisibility(0);
            this.rel_down.setVisibility(8);
        }
        this.loadVideoView();
    }

    protected void onPause() {
        super.onPause();
        if (this.rel_video.getVisibility() == 0) {
            this.videoPause = true;
        }
        if (this.player != null && this.player.isPlaying()) {
            try {
                this.player.pause();
                this.videoPause = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            if (this.player != null) {
                if (this.player.isPlaying()) {
                    this.player.stop();
                }
                this.player.release();
                this.player.reset();
                this.player = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void loadLoaingPage(int orientation) {
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-video-landing-page-portrait.png";
        if (orientation == 1) {
            url = "https://docs.yodo1.com/media/ad-test-resource/ad-video-landing-page-landscape.png";
        }
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>(){

            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                Yodo1VPActivity.this.bm = response.get();
            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {
            }

            @Override
            public void onFinish(int what) {
            }
        };
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }

    private class MyCallBack
    implements SurfaceHolder.Callback {
        private MyCallBack() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            Uri uri = Uri.parse((String)Yodo1VPActivity.this.videoPath);
            Yodo1VPActivity.this.player.setDisplay(holder);
            if (!Yodo1VPActivity.this.player.isPlaying()) {
                try {
                    Yodo1VPActivity.this.player.reset();
                    Yodo1VPActivity.this.player.setDataSource((Context)Yodo1VPActivity.this, uri);
                    Yodo1VPActivity.this.player.prepare();
                    Yodo1VPActivity.this.player.seekTo(Yodo1VPActivity.this.position);
                    YLog.d("Yodo1VP  \u5f00\u59cb\u64ad\u653e \uff1a " + Yodo1VPActivity.this.position);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (Yodo1VPActivity.this.player.isPlaying()) {
                Yodo1VPActivity.this.position = Yodo1VPActivity.this.player.getCurrentPosition();
                Yodo1VPActivity.this.player.stop();
                YLog.d("Yodo1VP  \u5f53\u524d\u64ad\u653e\u5e02\u573a \uff1a " + Yodo1VPActivity.this.position);
            }
        }
    }
}

