/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter.kit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.RR;

public class Yodo1InterAdView
extends RelativeLayout {
    private OnYodo1AdsCallBack adsCallBack;
    private Context context;
    private ImageView adImg;
    private ImageButton adCloseBtn;
    private Bitmap bm;
    private FrameLayout frameLayout;
    private RelativeLayout view;
    private boolean isLoded;

    public Yodo1InterAdView(Context context) {
        super(context);
        this.context = context;
        this.view = (RelativeLayout)View.inflate((Context)context, (int)RR.layout(context, "yodo1_inter_view"), (ViewGroup)this);
        this.initView();
        this.loadAds();
    }

    private void initView() {
        this.adImg = (ImageView)this.findViewById(RR.id(this.context, "yodo1_iv_interimg"));
        this.adCloseBtn = (ImageButton)this.findViewById(RR.id(this.context, "yodo1_iv_interclose"));
        this.adImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent("android.intent.action.VIEW");
                Uri uri = Uri.parse((String)"https://yodo1opp.com/");
                intent.setData(uri);
                Yodo1InterAdView.this.context.startActivity(intent);
                Yodo1InterAdView.this.adsCallBack.setOnAdClickListener();
            }
        });
        this.adCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Yodo1InterAdView.this.removeYodo1Ads();
                Yodo1InterAdView.this.adsCallBack.setOnAdCloseListener();
            }
        });
    }

    public boolean adLoaded() {
        return this.isLoded;
    }

    public void loadAds() {
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-interestital.png";
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>(){

            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                Yodo1InterAdView.this.bm = response.get();
                Yodo1InterAdView.this.isLoded = true;
                Yodo1InterAdView.this.adsCallBack.setOnAdLoadSuccessListener();
            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {
                Yodo1InterAdView.this.adsCallBack.setOnAdLoadFailedListener();
            }

            @Override
            public void onFinish(int what) {
            }
        };
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }

    public void showYodo1Ads(Activity activity) {
        if (this.isLoded) {
            this.frameLayout = (FrameLayout)activity.findViewById(0x1020002);
            this.frameLayout.addView((View)this.view);
            this.adImg.setImageBitmap(this.bm);
            this.adsCallBack.setOnAdShowSuccessListener();
        }
    }

    public void removeYodo1Ads() {
        this.frameLayout.removeView((View)this.view);
    }

    public void setOnYodo1AdsCallback(OnYodo1AdsCallBack callback) {
        this.adsCallBack = callback;
    }

    public static interface OnYodo1AdsCallBack {
        public void setOnAdClickListener();

        public void setOnAdCloseListener();

        public void setOnAdShowSuccessListener();

        public void setOnAdLoadSuccessListener();

        public void setOnAdLoadFailedListener();
    }
}

