/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter.kit;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;

public class Yodo1CountDownView
extends View {
    private int mRingColor = -16776961;
    private float mRingWidth = 10.0f;
    private int mRingProgessTextSize = 30;
    private int mWidth;
    private int mHeight;
    private Paint mPaint = new Paint(1);
    private RectF mRectF;
    private int mProgessTextColor = -1;
    private int mCountdownTime = 60;
    private float mCurrentProgress;
    private OnCountDownFinishListener mListener;

    public Yodo1CountDownView(Context context) {
        this(context, null);
    }

    public Yodo1CountDownView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Yodo1CountDownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    public void setCountdownTime(int mCountdownTime) {
        this.mCountdownTime = mCountdownTime;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.mRectF = new RectF(0.0f + this.mRingWidth / 2.0f, 0.0f + this.mRingWidth / 2.0f, (float)this.mWidth - this.mRingWidth / 2.0f, (float)this.mHeight - this.mRingWidth / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.mRingColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mRingWidth);
        canvas.drawArc(this.mRectF, -90.0f, this.mCurrentProgress - 360.0f, false, this.mPaint);
        Paint textPaint = new Paint();
        textPaint.setAntiAlias(true);
        textPaint.setTextAlign(Paint.Align.CENTER);
        String text = this.mCountdownTime - (int)(this.mCurrentProgress / 360.0f * (float)this.mCountdownTime) + "";
        textPaint.setTextSize((float)this.mRingProgessTextSize);
        textPaint.setColor(this.mProgessTextColor);
        Paint.FontMetricsInt fontMetrics = textPaint.getFontMetricsInt();
        int baseline = (int)((this.mRectF.bottom + this.mRectF.top - (float)fontMetrics.bottom - (float)fontMetrics.top) / 2.0f);
        canvas.drawText(text, this.mRectF.centerX(), (float)baseline, textPaint);
    }

    private ValueAnimator getValA(long countdownTime) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
        valueAnimator.setDuration(countdownTime);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator.setRepeatCount(0);
        return valueAnimator;
    }

    public void startCountDown() {
        this.setClickable(false);
        ValueAnimator valueAnimator = this.getValA(this.mCountdownTime * 1000);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float i = Float.valueOf(String.valueOf(animation.getAnimatedValue())).floatValue();
                Yodo1CountDownView.this.mCurrentProgress = (int)(360.0f * (i / 100.0f));
                Yodo1CountDownView.this.invalidate();
            }
        });
        valueAnimator.start();
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (Yodo1CountDownView.this.mListener != null) {
                    Yodo1CountDownView.this.mListener.countDownFinished();
                }
                Yodo1CountDownView.this.setClickable(true);
            }
        });
    }

    public void setAddCountDownListener(OnCountDownFinishListener mListener) {
        this.mListener = mListener;
    }

    public static interface OnCountDownFinishListener {
        public void countDownFinished();
    }
}

