/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdaptervungle
extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "Vungle";
    private static final String KEY_VUNGLE_APP_ID = "ad_vungle_app_id";
    private static final String VUNGLE_PLACEMENTID = "ad_vungle_video_placementid";
    private static final String VUNGLE_INTERSTITIAL_PLACEMENTID = "ad_vungle_inter_placementid";
    private static String appId;
    private static String interstitialPlacementId;
    private static String rewardedPlacementId;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback(){

        public void onAdStart(String placementReferenceId) {
            YLog.d("Vungle PlayAdCallback onAdStart, placementReferenceId: " + placementReferenceId);
            if (placementReferenceId.equals(interstitialPlacementId) && AdvertAdaptervungle.this.intersititalCallback != null) {
                AdvertAdaptervungle.this.intersititalCallback.onEvent(4, AdvertAdaptervungle.CHANNEL_CODE);
            }
            if (placementReferenceId.equals(rewardedPlacementId) && AdvertAdaptervungle.this.videoCallback != null) {
                AdvertAdaptervungle.this.videoCallback.onEvent(4, AdvertAdaptervungle.CHANNEL_CODE);
            }
        }

        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            YLog.d("Vungle PlayAdCallback onAdEnd, placementReferenceId: " + placementReferenceId + ", completed: " + completed + ", isCTAClicked: " + isCTAClicked);
            if (placementReferenceId.equals(interstitialPlacementId) && AdvertAdaptervungle.this.intersititalCallback != null) {
                if (isCTAClicked) {
                    AdvertAdaptervungle.this.intersititalCallback.onEvent(2, AdvertAdaptervungle.CHANNEL_CODE);
                }
                AdvertAdaptervungle.this.intersititalCallback.onEvent(0, AdvertAdaptervungle.CHANNEL_CODE);
            }
            if (placementReferenceId.equals(rewardedPlacementId) && AdvertAdaptervungle.this.videoCallback != null) {
                AdvertAdaptervungle.this.videoCallback.onEvent(2, AdvertAdaptervungle.CHANNEL_CODE);
                if (completed) {
                    YLog.d("Vungle,  onAdEnd  \u5173\u95ed");
                    AdvertAdaptervungle.this.videoCallback.onEvent(5, AdvertAdaptervungle.CHANNEL_CODE);
                }
                AdvertAdaptervungle.this.videoCallback.onEvent(0, AdvertAdaptervungle.CHANNEL_CODE);
            }
        }

        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d("Vungle PlayAdCallback onError, placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());
        }
    };
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback(){

        public void onAdLoad(String placementReferenceId) {
            YLog.d("Vungle LoadAdCallback onAdLoad, placementReferenceId: " + placementReferenceId);
            if (AdvertAdaptervungle.this.reloadInterCallback != null && placementReferenceId.equals(interstitialPlacementId)) {
                AdvertAdaptervungle.this.reloadInterCallback.onReloadSuccess(AdvertAdaptervungle.this.getAdvertCode());
            }
            if (AdvertAdaptervungle.this.reloadVideoCallback != null && placementReferenceId.equals(rewardedPlacementId)) {
                AdvertAdaptervungle.this.reloadVideoCallback.onReloadSuccess(AdvertAdaptervungle.this.getAdvertCode());
            }
        }

        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d("Vungle LoadAdCallback onError placementReferenceId: " + placementReferenceId + ", Throwable message: " + throwable.getMessage());
            if (AdvertAdaptervungle.this.reloadInterCallback != null && placementReferenceId.equals(interstitialPlacementId)) {
                AdvertAdaptervungle.this.reloadInterCallback.onReloadFailed(6, 0, throwable.getMessage() + "", AdvertAdaptervungle.this.getAdvertCode());
            }
            if (AdvertAdaptervungle.this.reloadVideoCallback != null && placementReferenceId.equals(rewardedPlacementId)) {
                AdvertAdaptervungle.this.reloadVideoCallback.onReloadFailed(6, 0, throwable.getMessage() + "", AdvertAdaptervungle.this.getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return "6.4.11";
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {
        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);
        if (TextUtils.isEmpty((CharSequence)appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_VUNGLE_APP_ID);
        }
        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, VUNGLE_PLACEMENTID);
        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, VUNGLE_INTERSTITIAL_PLACEMENTID);
        if (TextUtils.isEmpty((CharSequence)appId)) {
            YLog.d("Vungle appId is null");
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Vungle.init((String)appId, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

                    public void onSuccess() {
                        YLog.d("Vungle init onSuccess");
                    }

                    public void onError(Throwable throwable) {
                        YLog.d("Vungle init onError, cause message: " + throwable.getMessage());
                    }

                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d("Vungle init onAutoCacheAdAvailable, s: " + s);
                    }
                });
            }
        });
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        boolean isReady = this.interstitialAdvertIsLoaded(activity);
        YLog.d("Vungle showIntersititalAdvert... isReady: " + isReady);
        if (isReady) {
            Vungle.playAd((String)interstitialPlacementId, null, (PlayAdCallback)this.vunglePlayAdCallback);
        } else {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }
        YLog.d("Vungle reloadInterstitialAdvert...");
        if (Vungle.isInitialized()) {
            Vungle.loadAd((String)interstitialPlacementId, (LoadAdCallback)this.vungleLoadAdCallback);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd((String)interstitialPlacementId);
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        boolean isReady = this.videoAdvertIsLoaded(activity);
        YLog.d("Vungle showVideoAdvert... isReady: " + isReady);
        if (isReady) {
            Vungle.playAd((String)rewardedPlacementId, null, (PlayAdCallback)this.vunglePlayAdCallback);
        } else {
            callback.onAdError(2, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        YLog.d("Vungle reloadVideoAdvert...");
        if (Vungle.isInitialized()) {
            Vungle.loadAd((String)rewardedPlacementId, (LoadAdCallback)this.vungleLoadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd((String)rewardedPlacementId);
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Vungle.Consent consentStatus = privacy.isHasUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus((Vungle.Consent)consentStatus, (String)"");
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)interstitialPlacementId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)rewardedPlacementId))) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

