/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.ads.IShowAdListener;
import com.unity3d.services.monetization.placementcontent.ads.ShowAdPlacementContent;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterunityads
extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "Unityads";
    private static final String KEY_UNITYADS_APP_ID = "ad_unityads_app_id";
    private static final String KEY_UNITYADS_INTERSTITIAL_ID = "ad_unityads_interstitial_id";
    private static final String KEY_UNITYADS_REWARDED_ID = "ad_unityads_rewarded_id";
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    private String appId;
    private String interstitialPlacementId;
    private String rewardedPlacementId;
    IUnityMonetizationListener monetizationListener = new IUnityMonetizationListener(){

        public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
            YLog.d("Unityads onPlacementContentReady, placementId: " + placementId);
            if (AdvertAdapterunityads.this.reloadInterCallback != null && placementId.equals(AdvertAdapterunityads.this.interstitialPlacementId)) {
                AdvertAdapterunityads.this.reloadInterCallback.onReloadSuccess(AdvertAdapterunityads.this.getAdvertCode());
            }
            if (AdvertAdapterunityads.this.reloadVideoCallback != null && placementId.equals(AdvertAdapterunityads.this.rewardedPlacementId)) {
                AdvertAdapterunityads.this.reloadVideoCallback.onReloadSuccess(AdvertAdapterunityads.this.getAdvertCode());
            }
        }

        public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
            YLog.d("Unityads onPlacementContentStateChange, placementId: " + placementId);
        }

        public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
            YLog.d("Unityads onUnityServicesError, error: " + error.name() + ", message: " + message);
            if (AdvertAdapterunityads.this.reloadInterCallback != null) {
                AdvertAdapterunityads.this.reloadInterCallback.onReloadFailed(6, 0, "code:" + error.name() + ", msg:" + message, AdvertAdapterunityads.this.getAdvertCode());
            }
            if (AdvertAdapterunityads.this.reloadVideoCallback != null) {
                AdvertAdapterunityads.this.reloadVideoCallback.onReloadFailed(6, 0, "code:" + error.name() + ", msg:" + message, AdvertAdapterunityads.this.getAdvertCode());
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Unityads showVideoAdvert");
        if (!this.videoAdvertIsLoaded(activity)) {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
            return;
        }
        PlacementContent pc = UnityMonetization.getPlacementContent((String)this.rewardedPlacementId);
        if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
            ShowAdPlacementContent p = (ShowAdPlacementContent)pc;
            p.show(activity, new IShowAdListener(){

                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d("Unityads RewardedAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);
                    if (placementId.equals(AdvertAdapterunityads.this.rewardedPlacementId) && withState == UnityAds.FinishState.COMPLETED) {
                        callback.onEvent(5, AdvertAdapterunityads.this.getAdvertCode());
                    }
                    callback.onEvent(0, AdvertAdapterunityads.this.getAdvertCode());
                }

                public void onAdStarted(String placementId) {
                    YLog.d("Unityads RewardedAd onAdStarted, placementId:" + placementId);
                    callback.onEvent(4, AdvertAdapterunityads.this.getAdvertCode());
                }
            });
        } else {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty((CharSequence)this.rewardedPlacementId) && UnityMonetization.isReady((String)this.rewardedPlacementId);
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Unityads showIntersititalAdvert");
        if (!this.interstitialAdvertIsLoaded(activity)) {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
            return;
        }
        PlacementContent pc = UnityMonetization.getPlacementContent((String)this.interstitialPlacementId);
        if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
            ShowAdPlacementContent p = (ShowAdPlacementContent)pc;
            p.show(activity, new IShowAdListener(){

                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d("Unityads InterstitialAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);
                    callback.onEvent(0, AdvertAdapterunityads.this.getAdvertCode());
                }

                public void onAdStarted(String placementId) {
                    YLog.d("Unityads InterstitialAd onAdStarted, placementId: " + placementId);
                    callback.onEvent(4, AdvertAdapterunityads.this.getAdvertCode());
                }
            });
        } else {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty((CharSequence)this.interstitialPlacementId) && UnityMonetization.isReady((String)this.interstitialPlacementId);
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return UnityAds.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {
        this.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            this.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        }
        this.interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_INTERSTITIAL_ID);
        this.rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_REWARDED_ID);
        if (!UnityServices.isInitialized()) {
            if (TextUtils.isEmpty((CharSequence)this.appId)) {
                YLog.d("Unityads unityGameID is null");
                return;
            }
            UnityMonetization.initialize((Activity)activity, (String)this.appId, (IUnityMonetizationListener)this.monetizationListener, (boolean)false);
        }
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        MetaData gdprMetaData = new MetaData((Context)context);
        gdprMetaData.set("gdpr.consent", (Object)privacy.isHasUserConsent());
        gdprMetaData.commit();
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.interstitialPlacementId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.rewardedPlacementId))) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

