/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;
import java.util.Hashtable;

public class AdvertAdaptertapjoy
extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "Tapjoy";
    private static final String KEY_APPKEY = "ad_tapjoy_appkey";
    private static final String KEY_PLACEMENT_VIDEO = "ad_tapjoy_placement_video";
    private static final String KEY_PLACEMENT_INTERSTITIAL = "ad_tapjoy_placement_interstitial";
    private static String appkey;
    private static String placementInterstitial;
    private static String placementVideo;
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    private TJPlacement intersitialPlacement;
    private TJPlacement videoPlacement;
    private TJPlacementListener videoListener = new TJPlacementListener(){

        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d("Tapjoy RewardedAd onRequestSuccess");
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d("Tapjoy RewardedAd onRequestFailure, tjPlacement: " + tjPlacement + ", tjError code: " + tjError.code + ", tjError message: " + tjError.message);
            if (AdvertAdaptertapjoy.this.reloadVideoCallback != null) {
                AdvertAdaptertapjoy.this.reloadVideoCallback.onReloadFailed(6, tjError.code, tjError.message, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d("Tapjoy RewardedAd onContentReady");
            if (AdvertAdaptertapjoy.this.reloadVideoCallback != null) {
                AdvertAdaptertapjoy.this.reloadVideoCallback.onReloadSuccess(AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d("Tapjoy RewardedAd onContentShow");
            if (AdvertAdaptertapjoy.this.videoCallback != null) {
                AdvertAdaptertapjoy.this.videoCallback.onEvent(4, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d("Tapjoy RewardedAd onContentDismiss");
            if (AdvertAdaptertapjoy.this.videoCallback != null) {
                AdvertAdaptertapjoy.this.videoCallback.onEvent(0, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d("Tapjoy RewardedAd onPurchaseRequest");
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d("Tapjoy RewardedAd onRewardRequest");
        }

        public void onClick(TJPlacement tjPlacement) {
            YLog.d("Tapjoy RewardedAd onClick");
            if (AdvertAdaptertapjoy.this.videoCallback != null) {
                AdvertAdaptertapjoy.this.videoCallback.onEvent(2, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }
    };
    private TJPlacementVideoListener tjPlacementVideoListener = new TJPlacementVideoListener(){

        public void onVideoStart(TJPlacement tjPlacement) {
        }

        public void onVideoError(TJPlacement tjPlacement, String s) {
        }

        public void onVideoComplete(TJPlacement tjPlacement) {
            if (AdvertAdaptertapjoy.this.videoCallback != null) {
                AdvertAdaptertapjoy.this.videoCallback.onEvent(5, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }
    };
    private TJPlacementListener interstitialListener = new TJPlacementListener(){

        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d("Tapjoy InterstitialAd onRequestSuccess");
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d("Tapjoy InterstitialAd onRequestFailure, tjPlacement:" + tjPlacement + ", tjError code:" + tjError.code + ", tjError message: " + tjError.message);
            if (AdvertAdaptertapjoy.this.reloadInterCallback != null) {
                AdvertAdaptertapjoy.this.reloadInterCallback.onReloadFailed(5, tjError.code, tjError.message, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d("Tapjoy InterstitialAd onContentReady");
            if (AdvertAdaptertapjoy.this.reloadInterCallback != null) {
                AdvertAdaptertapjoy.this.reloadInterCallback.onReloadSuccess(AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }

        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d("Tapjoy InterstitialAd onContentShow");
            if (AdvertAdaptertapjoy.this.intersititalCallback != null) {
                AdvertAdaptertapjoy.this.intersititalCallback.onEvent(4, AdvertAdaptertapjoy.CHANNEL_CODE);
            }
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d("Tapjoy InterstitialAd onContentDismiss");
            if (AdvertAdaptertapjoy.this.intersititalCallback != null) {
                AdvertAdaptertapjoy.this.intersititalCallback.onEvent(0, AdvertAdaptertapjoy.CHANNEL_CODE);
            }
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d("Tapjoy InterstitialAd onPurchaseRequest");
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d("Tapjoy InterstitialAd onRewardRequest");
        }

        public void onClick(TJPlacement tjPlacement) {
            YLog.d("Tapjoy InterstitialAd onClick");
            if (AdvertAdaptertapjoy.this.intersititalCallback != null) {
                AdvertAdaptertapjoy.this.intersititalCallback.onEvent(2, AdvertAdaptertapjoy.this.getAdvertCode());
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.videoCallback = callback;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdvertAdaptertapjoy.this.videoPlacement != null && AdvertAdaptertapjoy.this.videoPlacement.isContentReady()) {
                    AdvertAdaptertapjoy.this.videoPlacement.showContent();
                } else {
                    callback.onAdError(2, "The AD has not been cached successfully, try again later.", AdvertAdaptertapjoy.CHANNEL_CODE);
                }
            }
        });
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        try {
            if (Tapjoy.isConnected()) {
                YLog.d("Tapjoy video onConnectSuccess");
                this.videoPlacement = Tapjoy.getPlacement((String)placementVideo, (TJPlacementListener)this.videoListener);
                this.videoPlacement.setVideoListener(this.tjPlacementVideoListener);
                this.videoPlacement.requestContent();
            } else {
                YLog.d("Tapjoy SDK must finish connecting before requesting content.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.videoPlacement != null && this.videoPlacement.isContentReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        try {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdvertAdaptertapjoy.this.intersitialPlacement != null && AdvertAdaptertapjoy.this.intersitialPlacement.isContentReady()) {
                        AdvertAdaptertapjoy.this.intersitialPlacement.showContent();
                    } else {
                        callback.onAdError(2, "The AD has not been cached successfully, try again later.", AdvertAdaptertapjoy.CHANNEL_CODE);
                    }
                }
            });
        }
        catch (Exception exception) {
            callback.onAdError(2, "Exception", CHANNEL_CODE);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }
        try {
            if (Tapjoy.isConnected()) {
                this.intersitialPlacement = Tapjoy.getPlacement((String)placementInterstitial, (TJPlacementListener)this.interstitialListener);
                this.intersitialPlacement.requestContent();
            } else {
                YLog.d("Tapjoy SDK must finish connecting before requesting content.");
            }
        }
        catch (Exception exception) {
            YLog.d("Tapjoy SDK Exception .");
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.intersitialPlacement != null && this.intersitialPlacement.isContentReady();
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return Tapjoy.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APPKEY);
        placementVideo = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_VIDEO);
        placementInterstitial = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_INTERSTITIAL);
        if (TextUtils.isEmpty((CharSequence)appkey)) {
            return;
        }
        Hashtable<String, String> connectFlags = new Hashtable<String, String>();
        boolean isDebugEnabled = false;
        if (isDebugEnabled) {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "true");
            Tapjoy.setDebugEnabled((boolean)true);
            TapjoyLog.setDebugEnabled((boolean)true);
        } else {
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "false");
            Tapjoy.setDebugEnabled((boolean)false);
            TapjoyLog.setDebugEnabled((boolean)false);
        }
        YLog.d("Tapjoy init ...");
        Tapjoy.setActivity((Activity)activity);
        Tapjoy.connect((Context)activity.getApplicationContext(), (String)appkey, connectFlags, (TJConnectListener)new TJConnectListener(){

            public void onConnectSuccess() {
                YLog.d("Tapjoy onConnectSuccess");
            }

            public void onConnectFailure() {
                YLog.d("Tapjoy onConnectFailure");
            }
        });
    }

    @Override
    public void onResume(Activity activity) {
        Tapjoy.onActivityStart((Activity)activity);
    }

    @Override
    public void onPause(Activity activity) {
        Tapjoy.onActivityStart((Activity)activity);
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        Tapjoy.setUserConsent((String)(privacy.isHasUserConsent() ? "1" : "0"));
        Tapjoy.belowConsentAge((boolean)privacy.isAgeRestrictedUser());
        Tapjoy.setActivity((Activity)context);
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty((CharSequence)appkey) || TextUtils.isEmpty((CharSequence)placementInterstitial)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && (TextUtils.isEmpty((CharSequence)appkey) || TextUtils.isEmpty((CharSequence)placementVideo))) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

