/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdaptersupersonic
extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "Supersonic";
    private static final String KEY_SUPERSONIC_APP_ID = "ad_supersonic_app_id";
    private static String appId = "";
    RewardedVideoListener rewardedVideoListener = new RewardedVideoListener(){

        public void onRewardedVideoAdClosed() {
            YLog.d("Supersonic onRewardedVideoAdClosed");
            if (AdvertAdaptersupersonic.this.videoCallback != null) {
                AdvertAdaptersupersonic.this.videoCallback.onEvent(0, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.d("Supersonic onRewardedVideoAvailabilityChanged, available: " + available);
            if (AdvertAdaptersupersonic.this.reloadVideoCallback != null && available) {
                AdvertAdaptersupersonic.this.reloadVideoCallback.onReloadSuccess(AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdStarted() {
            YLog.d("Supersonic onRewardedVideoAdStarted");
        }

        public void onRewardedVideoAdEnded() {
            YLog.d("Supersonic onRewardedVideoAdEnded");
        }

        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.d("Supersonic onRewardedVideoAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (AdvertAdaptersupersonic.this.reloadVideoCallback != null) {
                AdvertAdaptersupersonic.this.reloadVideoCallback.onReloadFailed(6, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), AdvertAdaptersupersonic.this.getAdvertCode());
            }
            if (AdvertAdaptersupersonic.this.videoCallback != null) {
                AdvertAdaptersupersonic.this.videoCallback.onAdError(4, ironSourceError.getErrorMessage(), AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdClicked(Placement placement) {
            YLog.d("Supersonic onRewardedVideoAdClicked");
            if (AdvertAdaptersupersonic.this.videoCallback != null) {
                AdvertAdaptersupersonic.this.videoCallback.onEvent(2, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdOpened() {
            YLog.d("Supersonic onRewardedVideoAdOpened");
            if (AdvertAdaptersupersonic.this.videoCallback != null) {
                AdvertAdaptersupersonic.this.videoCallback.onEvent(4, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdRewarded(Placement placement) {
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.d("Supersonic onRewardedVideoAdRewarded, rewardName: " + rewardName + ", rewardAmount: " + rewardAmount);
            if (AdvertAdaptersupersonic.this.videoCallback != null) {
                AdvertAdaptersupersonic.this.videoCallback.onEvent(5, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }
    };
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    InterstitialListener interstitialListener = new InterstitialListener(){

        public void onInterstitialAdReady() {
            YLog.d("Supersonic onInterstitialAdReady");
            if (AdvertAdaptersupersonic.this.reloadInterCallback != null) {
                AdvertAdaptersupersonic.this.reloadInterCallback.onReloadSuccess(AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
            YLog.d("Supersonic onInterstitialAdLoadFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (AdvertAdaptersupersonic.this.reloadInterCallback != null) {
                AdvertAdaptersupersonic.this.reloadInterCallback.onReloadFailed(6, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onInterstitialAdOpened() {
            YLog.d("Supersonic onInterstitialAdOpened");
        }

        public void onInterstitialAdClosed() {
            YLog.d("Supersonic onInterstitialAdClosed");
            if (AdvertAdaptersupersonic.this.intersititalCallback != null) {
                AdvertAdaptersupersonic.this.intersititalCallback.onEvent(0, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onInterstitialAdShowSucceeded() {
            YLog.d("Supersonic onInterstitialAdShowSucceeded");
            if (AdvertAdaptersupersonic.this.intersititalCallback != null) {
                AdvertAdaptersupersonic.this.intersititalCallback.onEvent(4, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.d("Supersonic onInterstitialAdShowFailed, error code: " + ironSourceError.getErrorCode() + ", error message: " + ironSourceError.getErrorMessage());
            if (AdvertAdaptersupersonic.this.intersititalCallback != null) {
                AdvertAdaptersupersonic.this.intersititalCallback.onAdError(4, ironSourceError.getErrorMessage(), AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }

        public void onInterstitialAdClicked() {
            YLog.d("Supersonic onInterstitialAdClicked");
            if (AdvertAdaptersupersonic.this.intersititalCallback != null) {
                AdvertAdaptersupersonic.this.intersititalCallback.onEvent(2, AdvertAdaptersupersonic.this.getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean isInterstitialReady = AdvertAdaptersupersonic.this.interstitialAdvertIsLoaded(activity);
                YLog.d("Supersonic showIntersititalAdvert... isInterstitialReady: " + isInterstitialReady);
                if (isInterstitialReady) {
                    IronSource.showInterstitial();
                } else if (AdvertAdaptersupersonic.this.intersititalCallback != null) {
                    AdvertAdaptersupersonic.this.intersititalCallback.onAdError(3, "The AD has not been cached successfully, try again later.", AdvertAdaptersupersonic.this.getAdvertCode());
                }
            }
        });
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }
        YLog.d("Supersonic reloadInterstitialAdvert...");
        if (!this.interstitialAdvertIsLoaded(activity)) {
            IronSource.loadInterstitial();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        boolean isRewardedVideoAvailable = this.videoAdvertIsLoaded(activity);
        YLog.d("Supersonic showVideoAdvert ... isRewardedVideoAvailable: " + isRewardedVideoAvailable);
        if (isRewardedVideoAvailable) {
            IronSource.showRewardedVideo();
        } else if (this.videoCallback != null) {
            this.videoCallback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return IronSource.isRewardedVideoAvailable();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty((CharSequence)appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_SUPERSONIC_APP_ID);
        }
        if (TextUtils.isEmpty((CharSequence)appId)) {
            YLog.d("Supersonic appId is null");
            return;
        }
        IronSource.init((Activity)activity, (String)appId);
        IntegrationHelper.validateIntegration((Activity)activity);
    }

    @Override
    public void initVideoAd(Activity activity) {
        IronSource.setRewardedVideoListener((RewardedVideoListener)this.rewardedVideoListener);
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        IronSource.setInterstitialListener((InterstitialListener)this.interstitialListener);
    }

    @Override
    public void onResume(Activity activity) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        IronSource.onResume((Activity)activity);
    }

    @Override
    public void onPause(Activity activity) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        IronSource.onPause((Activity)activity);
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        IronSource.setConsent((boolean)privacy.isHasUserConsent());
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (TextUtils.isEmpty((CharSequence)appId)) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

