/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterfacebook
extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "FaceBook";
    public static final String CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID = "ad_facebook_sdk_key";
    public static final String CONFIG_KEY_FACEBOOK_VIDEO_ID = "ad_facebook_video_key";
    public static String INTERSTITIAL_ID;
    public static String VIDEO_ID;
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    private InterstitialAd interstitialAd;
    private RewardedVideoAd rewardedVideoAd = null;
    private boolean rewardedVideoLoading = false;
    private InterstitialAdListener adInterListener = new InterstitialAdListener(){

        public void onInterstitialDisplayed(Ad ad) {
            if (AdvertAdapterfacebook.this.intersititalCallback != null) {
                AdvertAdapterfacebook.this.intersititalCallback.onEvent(4, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onInterstitialDismissed(Ad ad) {
            if (AdvertAdapterfacebook.this.intersititalCallback != null) {
                AdvertAdapterfacebook.this.intersititalCallback.onEvent(0, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onError(Ad ad, AdError adError) {
            YLog.d("FaceBook InterstitialAd AdError, error code: " + adError.getErrorCode() + ", message: " + adError.getErrorMessage());
            if (AdvertAdapterfacebook.this.reloadInterCallback != null) {
                AdvertAdapterfacebook.this.reloadInterCallback.onReloadFailed(6, adError.getErrorCode(), adError.getErrorMessage(), AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onAdLoaded(Ad ad) {
            if (AdvertAdapterfacebook.this.reloadInterCallback != null) {
                AdvertAdapterfacebook.this.reloadInterCallback.onReloadSuccess(AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdClicked(Ad ad) {
            if (AdvertAdapterfacebook.this.intersititalCallback != null) {
                AdvertAdapterfacebook.this.intersititalCallback.onEvent(2, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }
    };
    private RewardedVideoAdListener adVideoListener = new RewardedVideoAdListener(){

        public void onRewardedVideoCompleted() {
            if (AdvertAdapterfacebook.this.videoCallback != null) {
                AdvertAdapterfacebook.this.videoCallback.onEvent(5, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onLoggingImpression(Ad ad) {
            if (AdvertAdapterfacebook.this.videoCallback != null) {
                AdvertAdapterfacebook.this.videoCallback.onEvent(4, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onRewardedVideoClosed() {
            YLog.d("FaceBook onRewardedVideoClosed");
            if (AdvertAdapterfacebook.this.videoCallback != null) {
                AdvertAdapterfacebook.this.videoCallback.onEvent(0, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onError(Ad ad, AdError adError) {
            YLog.d("FaceBook RewardedVideoAd onError, error message: " + adError.getErrorMessage());
            AdvertAdapterfacebook.this.rewardedVideoLoading = false;
            if (AdvertAdapterfacebook.this.reloadVideoCallback != null) {
                AdvertAdapterfacebook.this.reloadVideoCallback.onReloadFailed(6, adError.getErrorCode(), adError.getErrorMessage(), AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onAdLoaded(Ad ad) {
            AdvertAdapterfacebook.this.rewardedVideoLoading = false;
            if (AdvertAdapterfacebook.this.reloadVideoCallback != null) {
                AdvertAdapterfacebook.this.reloadVideoCallback.onReloadSuccess(AdvertAdapterfacebook.this.getAdvertCode());
            }
        }

        public void onAdClicked(Ad ad) {
            if (AdvertAdapterfacebook.this.videoCallback != null) {
                AdvertAdapterfacebook.this.videoCallback.onEvent(2, AdvertAdapterfacebook.this.getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return "5.5.0";
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AdvertAdapterfacebook.this.interstitialAdvertIsLoaded(activity)) {
                        AdvertAdapterfacebook.this.interstitialAd.show();
                    } else {
                        AdvertAdapterfacebook.this.intersititalCallback.onAdError(3, "The AD has not been cached successfully, try again later.", AdvertAdapterfacebook.this.getAdvertCode());
                    }
                }
                catch (Exception exception) {
                    AdvertAdapterfacebook.this.intersititalCallback.onAdError(2, "No cached ads", AdvertAdapterfacebook.this.getAdvertCode());
                }
            }
        });
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.interstitialAd != null && this.interstitialAd.isAdLoaded() && !this.interstitialAd.isAdInvalidated();
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }
        if (!this.interstitialAdvertIsLoaded(activity)) {
            this.interstitialAd.loadAd();
        }
    }

    @Override
    public void showVideoAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d("FaceBook showRewardVideo");
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdvertAdapterfacebook.this.videoAdvertIsLoaded(activity)) {
                    AdvertAdapterfacebook.this.rewardedVideoAd.show();
                } else if (AdvertAdapterfacebook.this.videoCallback != null) {
                    AdvertAdapterfacebook.this.videoCallback.onAdError(3, "The AD has not been cached successfully, try again later.", AdvertAdapterfacebook.this.getAdvertCode());
                }
            }
        });
    }

    @Override
    public void reloadVideoAdvert(final Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        YLog.d("FaceBook reloadVideoAdvert ...");
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!AdvertAdapterfacebook.this.videoAdvertIsLoaded(activity) && !AdvertAdapterfacebook.this.rewardedVideoLoading) {
                    AdvertAdapterfacebook.this.rewardedVideoAd.loadAd();
                    AdvertAdapterfacebook.this.rewardedVideoLoading = true;
                }
            }
        }, 1000L);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.rewardedVideoAd != null && this.rewardedVideoAd.isAdLoaded() && !this.rewardedVideoAd.isAdInvalidated();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID);
        VIDEO_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, CONFIG_KEY_FACEBOOK_VIDEO_ID);
        AudienceNetworkAds.initialize((Context)activity);
        AdSettings.addTestDevice((String)"1d6b2709-fca3-4d75-a47a-7d0179a21350");
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        if (!TextUtils.isEmpty((CharSequence)INTERSTITIAL_ID)) {
            this.interstitialAd = new InterstitialAd((Context)activity, INTERSTITIAL_ID);
            this.interstitialAd.setAdListener(this.adInterListener);
        }
    }

    @Override
    public void initVideoAd(Activity activity) {
        if (!TextUtils.isEmpty((CharSequence)VIDEO_ID)) {
            this.rewardedVideoAd = new RewardedVideoAd((Context)activity, VIDEO_ID);
            this.rewardedVideoAd.setAdListener(this.adVideoListener);
        }
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
        if (this.rewardedVideoAd != null) {
            this.rewardedVideoAd.destroy();
            this.rewardedVideoAd = null;
        }
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        AdSettings.setIsChildDirected((boolean)privacy.isAgeRestrictedUser());
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty((CharSequence)INTERSTITIAL_ID)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && TextUtils.isEmpty((CharSequence)VIDEO_ID)) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

