/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapteradmob
extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "AdMob";
    private static final String KEY_AdMob_INTERSTITIAL_APP_ID = "ad_admob_interstitial_appId";
    private static final String KEY_AdMob_INTERSTITIAL_UNIT_ID = "ad_admob_interstitial_id";
    private static final String KEY_AdMob_VIDEO_APP_ID = "ad_admob_video_appId";
    private static final String KEY_AdMob_VIDEO_UNIT_ID = "ad_admob_video_unitId";
    private static final String KEY_AdMob_BANNER_APP_ID = "ad_admob_banner_appId";
    private static final String KEY_AdMob_BANNER_UNIT_ID = "ad_admob_banner_unitId";
    private String appId;
    private String bannerUnitId;
    private String interUnitId;
    private String videoUnitId;
    private boolean isBannerLoaded;
    private boolean interIsLoded;
    private boolean videoIsLoded = false;
    private int align = 34;
    private AdRequest adRequest;
    private AdView mBannerAdView;
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardedVideoAd;
    private Yodo1AdCallback intersititalCallback;
    private Yodo1AdCallback videoCallback;
    private Yodo1AdCallback bannerCallback;
    private Yodo1ReloadCallback reloadInterCallback;
    private Yodo1ReloadCallback reloadVideoCallback;
    private Yodo1ReloadCallback reloadBannerCallback;
    private Yodo1Privacy privacy;
    private AdListener adBannerListener = new AdListener(){

        public void onAdLoaded() {
            AdvertAdapteradmob.this.isBannerLoaded = true;
            YLog.d("AdMob BannerAd onAdLoaded");
        }

        public void onAdFailedToLoad(int errorCode) {
            AdvertAdapteradmob.this.isBannerLoaded = false;
            YLog.d("AdMob BannerAd onAdFailedToLoad, " + errorCode);
        }

        public void onAdOpened() {
            YLog.d("AdMob BannerAd onAdOpened");
        }

        public void onAdLeftApplication() {
            YLog.d("AdMob BannerAd onAdLeftApplication");
            if (AdvertAdapteradmob.this.bannerCallback != null) {
                AdvertAdapteradmob.this.bannerCallback.onEvent(2, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onAdClosed() {
            YLog.d("AdMob BannerAd onAdClosed");
            if (AdvertAdapteradmob.this.bannerCallback != null) {
                AdvertAdapteradmob.this.bannerCallback.onEvent(0, AdvertAdapteradmob.this.getAdvertCode());
            }
        }
    };
    private RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener(){

        public void onRewardedVideoAdLoaded() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoAdLoaded");
            AdvertAdapteradmob.this.videoIsLoded = true;
            if (AdvertAdapteradmob.this.reloadVideoCallback != null) {
                AdvertAdapteradmob.this.reloadVideoCallback.onReloadSuccess(AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdOpened() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoAdOpened");
            if (AdvertAdapteradmob.this.videoCallback != null) {
                AdvertAdapteradmob.this.videoCallback.onEvent(4, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onRewardedVideoStarted() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoStarted");
        }

        public void onRewardedVideoAdClosed() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoAdClosed");
            if (AdvertAdapteradmob.this.videoCallback != null) {
                AdvertAdapteradmob.this.videoCallback.onEvent(0, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onRewarded(RewardItem rewardItem) {
            YLog.d("AdMob RewardedVideoAd onRewarded");
        }

        public void onRewardedVideoAdLeftApplication() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoAdLeftApplication");
            if (AdvertAdapteradmob.this.videoCallback != null) {
                AdvertAdapteradmob.this.videoCallback.onEvent(2, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onRewardedVideoAdFailedToLoad(int errorCode) {
            YLog.d("AdMob BannerAd onRewardedVideoAdFailedToLoad, error code:" + errorCode);
            AdvertAdapteradmob.this.videoIsLoded = false;
            if (AdvertAdapteradmob.this.reloadVideoCallback != null) {
                AdvertAdapteradmob.this.reloadVideoCallback.onReloadFailed(6, errorCode, "", AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onRewardedVideoCompleted() {
            YLog.d("AdMob RewardedVideoAd onRewardedVideoCompleted");
            if (AdvertAdapteradmob.this.videoCallback != null) {
                AdvertAdapteradmob.this.videoCallback.onEvent(5, AdvertAdapteradmob.this.getAdvertCode());
            }
        }
    };
    private AdListener adInterstitialListener = new AdListener(){

        public void onAdClosed() {
            YLog.d("AdMob InterstitialAd onAdClosed");
            if (AdvertAdapteradmob.this.intersititalCallback != null) {
                AdvertAdapteradmob.this.intersititalCallback.onEvent(0, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onAdFailedToLoad(int errorCode) {
            YLog.d("AdMob InterstitialAd onAdFailedToLoad, adErrorCode: " + errorCode);
            AdvertAdapteradmob.this.interIsLoded = false;
            if (AdvertAdapteradmob.this.reloadInterCallback != null) {
                AdvertAdapteradmob.this.reloadInterCallback.onReloadFailed(6, errorCode, "", AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onAdOpened() {
            YLog.d("AdMob InterstitialAd onAdOpened");
            if (AdvertAdapteradmob.this.intersititalCallback != null) {
                AdvertAdapteradmob.this.intersititalCallback.onEvent(4, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onAdLeftApplication() {
            YLog.d("AdMob InterstitialAd onAdLeftApplication");
            if (AdvertAdapteradmob.this.intersititalCallback != null) {
                AdvertAdapteradmob.this.intersititalCallback.onEvent(2, AdvertAdapteradmob.this.getAdvertCode());
            }
        }

        public void onAdLoaded() {
            YLog.d("AdMob InterstitialAd onAdLoaded");
            AdvertAdapteradmob.this.interIsLoded = true;
            if (AdvertAdapteradmob.this.reloadInterCallback != null) {
                AdvertAdapteradmob.this.reloadInterCallback.onReloadSuccess(AdvertAdapteradmob.this.getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
        this.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_AdMob_BANNER_APP_ID);
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            this.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_AdMob_VIDEO_APP_ID);
        }
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            this.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_AdMob_INTERSTITIAL_APP_ID);
        }
        if (!TextUtils.isEmpty((CharSequence)this.appId)) {
            MobileAds.initialize((Context)activity.getApplicationContext(), (String)this.appId);
        }
        Bundle admobExtras = new Bundle();
        if (this.privacy != null && !this.privacy.isHasUserConsent()) {
            admobExtras.putString("npa", "1");
        }
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.addNetworkExtrasBundle(AdMobAdapter.class, admobExtras);
        this.adRequest = builder.build();
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mBannerAdView != null) {
            this.mBannerAdView.resume();
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.resume((Context)activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mBannerAdView != null) {
            this.mBannerAdView.pause();
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.pause((Context)activity);
        }
    }

    @Override
    public void onDestroy(Activity activity) {
        if (this.mBannerAdView != null) {
            this.mBannerAdView.destroy();
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy((Context)activity);
        }
    }

    @Override
    public void initVideoAd(Activity activity) {
        this.videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_AdMob_VIDEO_UNIT_ID);
        if (TextUtils.isEmpty((CharSequence)this.videoUnitId)) {
            YLog.d("AdMob VideoUnitId is null");
            return;
        }
        this.mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance((Context)activity);
        this.mRewardedVideoAd.setRewardedVideoAdListener(this.rewardedVideoAdListener);
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        this.videoIsLoded = false;
        if (this.mRewardedVideoAd == null) {
            callback.onAdError(0, "uninitialized", this.getAdvertCode());
            return;
        }
        if (this.mRewardedVideoAd.isLoaded()) {
            this.mRewardedVideoAd.show();
        } else {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        if (this.mRewardedVideoAd == null) {
            reloadCallback.onReloadFailed(0, 0, "uninitialized", this.getAdvertCode());
            return;
        }
        this.mRewardedVideoAd.loadAd(this.videoUnitId, this.adRequest);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.videoIsLoded;
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        this.interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, "ad_admob_interstitial_id1");
        if (TextUtils.isEmpty((CharSequence)this.interUnitId)) {
            YLog.d("AdMob interUnitId is null");
            return;
        }
        YLog.d("AdMob interUnitId: " + this.interUnitId);
        this.mInterstitialAd = new InterstitialAd((Context)activity);
        this.mInterstitialAd.setAdUnitId(this.interUnitId);
        this.mInterstitialAd.setAdListener(this.adInterstitialListener);
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadInterCallback = reloadCallback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }
        if (this.mInterstitialAd == null) {
            reloadCallback.onReloadFailed(5, 0, "uninitialized", this.getAdvertCode());
            return;
        }
        if (!this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.loadAd(this.adRequest);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.interIsLoded;
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        this.interIsLoded = false;
        if (this.mInterstitialAd == null) {
            callback.onAdError(0, "uninitialized", this.getAdvertCode());
            return;
        }
        if (this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.show();
        } else {
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void initBannerAd(Activity activity) {
        this.bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_AdMob_BANNER_UNIT_ID);
        if (TextUtils.isEmpty((CharSequence)this.bannerUnitId)) {
            YLog.d("AdMob BannerUnitId  is null");
            return;
        }
        if (this.mBannerAdView == null) {
            this.mBannerAdView = new AdView((Context)activity);
            this.mBannerAdView.setAdUnitId(this.bannerUnitId);
            this.mBannerAdView.setAdSize(AdSize.BANNER);
            this.mBannerAdView.setAdListener(this.adBannerListener);
            this.mBannerAdView.loadAd(this.adRequest);
        }
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.bannerCallback = callback;
        if (!this.isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, null, callback)) {
            return;
        }
        if (this.mBannerAdView == null) {
            callback.onAdError(0, "uninitialized", this.getAdvertCode());
            return;
        }
        if (this.isBannerLoaded) {
            YLog.d("AdMob showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity, (View)this.mBannerAdView, this.align);
            callback.onEvent(4, this.getAdvertCode());
        } else {
            YLog.d("AdMob showBanner, the banner has not been loaded.");
            callback.onAdError(3, "The AD has not been cached successfully, try again later.", this.getAdvertCode());
        }
    }

    @Override
    public void removeBanner(Activity activity) {
        this.isBannerLoaded = false;
        YLog.d("AdMob removeBanner");
        if (this.mBannerAdView != null) {
            this.mBannerAdView.destroy();
            this.mBannerAdView = null;
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d("AdMob hideBanner");
        if (this.mBannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, (View)this.mBannerAdView);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d("AdMob setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded;
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        this.privacy = privacy;
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd) {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.bannerUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.interUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.videoUnitId))) {
            isValid = false;
        }
        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(5, 0, "", this.getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(5, "", this.getAdvertCode());
            }
        }
        return isValid;
    }
}

