package com.yodo1.plugin.dmp.yodo1.open;

import android.app.Activity;
import android.app.Application;

import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConst;
import com.yodo1.plugin.dmp.yodo1.helper.Yodo1AnalyticsManage;
import com.yodo1.sdk.kit.YLog;

import java.util.HashMap;

/**
 * Created by zhuxiaochen on 2017/9/1.
 */

public class Yodo1Analytics {
    private static final String TAG = "[Yodo1Analytics] ";

    private static Yodo1AnalyticsManage manage = Yodo1AnalyticsManage.getInstance();

    /**
     * Application初始化
     *
     * @param application
     */
    public static void createApp(Application application) {
        YLog.d(TAG + "createApp...");
    }

    /**
     * 初始化SDK
     *
     * @param appKey
     */
    public static void initSDK(Activity activity, String appKey) {
        YLog.d(TAG + "initSDK... " + appKey);
        manage.initSDK(activity, appKey);

    }


    public static void onResume(Activity activity) {
        YLog.d(TAG + "onResume...");
        manage.onResume(activity);
    }

    public static void onPause(Activity activity) {
        YLog.d(TAG + "onPause...");
        manage.onPause(activity);
    }

    public static void onDestroy() {
        YLog.d(TAG + "onDestroy...");
        manage.onDestroy();
    }

    public static void onEvent(String eventId, String advertCode, String showResult) {
        YLog.d(TAG + "onEvent... " + eventId + " " + advertCode + " " + showResult);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(AnalyticsConst.AdvertCode, advertCode);
        map.put(AnalyticsConst.Result, showResult);
        manage.onEvent(eventId, map);
    }

}
