package com.yodo1.android.ops.utils;

/**
 * Created by yodo1 on 2016/3/11.
 */
public interface Yodo1OpsCallback {
    public void onResult(ResultCode resultCode, String msg);

    public enum ResultCode {
        Success("成功", 1), Failed("失败", 0), Cancel("取消", 2), Payment_Omissive("漏单", 4);
        private String name;
        private int value;

        private ResultCode(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public static ResultCode toEntry(int value) {
            ResultCode result = Failed;
            for (ResultCode code : ResultCode.values()) {
                if (code.value() == value) {
                    result = code;
                    break;
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return name;
        }

        public int value() {
            return value;
        }
    }
}
