package com.yodo1.advert.factory;

import android.content.Context;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class Yodo1AdvertAdapterFactory {
    private static final String TAG = "[Yodo1AdvertAdapterFactory] ";

    private static final String PACKAGE_NAME_ADVERT = "com.yodo1.advert.adapter.AdvertAdapter"; //存放插屏插件的完整包名

    private static Yodo1AdvertAdapterFactory instance;
    private Map<String, AdapterAdvertBase> _advertAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的插屏广告插件，避免重复实例化
    private boolean hasInit = false;

    private Yodo1AdvertAdapterFactory() {
    }

    public static Yodo1AdvertAdapterFactory getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertAdapterFactory();
        }
        return instance;
    }

    /**
     * 获取所有已经实例化的广告Adapter
     *
     * @return
     */
    public Map<String, AdapterAdvertBase> getAdapters() {

        return _advertAdapters;
    }

    /**
     * 实例化所有广告
     */
    public void initAdvertAdapters(Context context) {
        if (hasInit) {
            YLog.v(TAG + "Yodo1 Ads adapters have been initialized.");
            return;
        }
        hasInit = true;

        AdvertTypeBean bean = new AdvertTypeBean(PACKAGE_NAME_ADVERT, AdapterAdvertBase.class, _advertAdapters);
        initAdvertAdapter(context, bean);
    }

    private void initAdvertAdapter(Context context, AdvertTypeBean bean) {
        List<String> advertCodes = getAdCodes(context, bean);
        for (int i = 0; i < advertCodes.size(); i++) {

            try {
                String className = bean.packageName + advertCodes.get(i);
                Class clz = Class.forName(className);
                if (clz != null) {
                    clz.asSubclass(bean.clz); //如果该类不是继承广告类，那么这里会catch出去
                    AdapterAdvertBase adapterBase = (AdapterAdvertBase) clz.newInstance();
                    bean.adapters.put(adapterBase.getAdvertCode().toLowerCase(Locale.getDefault()), adapterBase);
                    YLog.d(TAG + "实例化广告 " + className + ", 地址 = " + adapterBase);
                } else {
                    YLog.d(TAG + advertCodes.get(i) + " adapter failed to new instance, the adapter is not exist!");
                }
            } catch (Exception e) {
                YLog.d(TAG + advertCodes.get(i) + " adapter failed to new instance, the adapter is not exist!");
            }
        }
    }

    /**
     * 获取广告列表
     *
     * @return
     */
    private List<String> getAdCodes(Context context, AdvertTypeBean bean) {
        List<AdsConfigEntity> adList = new ArrayList<>();

        List<AdsConfigEntity> adList1 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        List<AdsConfigEntity> adList2 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        List<AdsConfigEntity> adList3 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        List<AdsConfigEntity> adList4 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
        List<AdsConfigEntity> adList5 = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);

        adList.addAll(adList1);
        adList.addAll(adList2);
        adList.addAll(adList3);
        adList.addAll(adList4);
        adList.addAll(adList5);

        List<String> weight = new ArrayList<>();
        for (int i = 0; i < adList.size(); i++) {
            weight.add(adList.get(i).getAdvertCode());
        }

        YLog.d(TAG + "isTestModule: " + YOnlineConfigUtils.isTestModule(context));

        if (YOnlineConfigUtils.isTestModule(context) && YOnlineConfigUtils.isEmptyTestAdList()) {
            weight.clear();
            weight.add("yodo1");

            YLog.d(TAG + "已添加Yodo1测试广告");
            return weight;
        }

        LinkedHashSet<String> set = new LinkedHashSet<String>(weight.size());
        set.addAll(weight);
        weight.clear();
        weight.addAll(set);

        YLog.d(TAG + "getAdCodesList " + weight.toString());

        return weight;
    }


    private class AdvertTypeBean {
        public String packageName; //存放插件的完整包名
        public Class<?> clz; //实现方法的广告插件基类
        public Map<String, AdapterAdvertBase> adapters; //存放实例化好的广告插件的集合

        public AdvertTypeBean(String fullPackageName, Class<?> clz, Map<String, AdapterAdvertBase> adapters) {
            this.packageName = fullPackageName;
            this.clz = clz;
            this.adapters = adapters;
        }

    }
}
