package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

public class AdvertAdapterfacebook extends AdapterAdvertBase {
    public static final String CHANNEL_CODE = "FaceBook";

    public static final String CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID = "ad_facebook_sdk_key";
    public static final String CONFIG_KEY_FACEBOOK_VIDEO_ID = "ad_facebook_video_key";

    public static String INTERSTITIAL_ID, VIDEO_ID;

    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;

    private InterstitialAd interstitialAd;
    private RewardedVideoAd rewardedVideoAd = null;

    private boolean rewardedVideoLoading = false;

    private InterstitialAdListener adInterListener = new InterstitialAdListener() {
        @Override
        public void onInterstitialDisplayed(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialDismissed(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.d(CHANNEL_CODE + " InterstitialAd AdError, error code: " + adError.getErrorCode() + ", message: " + adError.getErrorMessage());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onLoggingImpression(Ad ad) {

        }

        @Override
        public void onAdClicked(Ad ad) {
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    private RewardedVideoAdListener adVideoListener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoCompleted() {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoClosed() {
            YLog.d(CHANNEL_CODE + " onRewardedVideoClosed");
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.d(CHANNEL_CODE + " RewardedVideoAd onError, error message: " + adError.getErrorMessage());
            rewardedVideoLoading = false;
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            rewardedVideoLoading = false;
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdClicked(Ad ad) {
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                try {
                    if (interstitialAdvertIsLoaded(activity)) {
                        interstitialAd.show();
                    } else {
                        intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
                    }
                } catch (Exception exception) {
                    intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "No cached ads", getAdvertCode());
                }
            }
        });
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isAdLoaded() && !interstitialAd.isAdInvalidated();
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null)) {
            return;
        }

        if (!interstitialAdvertIsLoaded(activity)) {
            interstitialAd.loadAd();
        }
    }

    /**
     * 播放
     *
     * @param activity
     * @param callback
     */
    @Override
    public void showVideoAdvert(final Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.d(CHANNEL_CODE + " showRewardVideo");

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (videoAdvertIsLoaded(activity)) {
                    rewardedVideoAd.show();
                } else {
                    if (videoCallback != null) {
                        videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
                    }
                }
            }
        });
    }

    /**
     * 预加载
     *
     * @param activity
     * @param reloadCallback
     */
    @Override
    public void reloadVideoAdvert(final Activity activity, final Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;
        YLog.d(CHANNEL_CODE + " reloadVideoAdvert ...");

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }

        new Handler().postDelayed(new Runnable() {
            public void run() {
                // Check if rewardedVideoAd has been loaded successfully
                if (!videoAdvertIsLoaded(activity) && !rewardedVideoLoading) {
                    rewardedVideoAd.loadAd();
                    rewardedVideoLoading = true;
                }
            }
        }, 1000);
    }


    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedVideoAd != null && rewardedVideoAd.isAdLoaded() && !rewardedVideoAd.isAdInvalidated();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

        INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID);
        VIDEO_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, CONFIG_KEY_FACEBOOK_VIDEO_ID);

        AudienceNetworkAds.initialize(activity);

        AdSettings.addTestDevice("1d6b2709-fca3-4d75-a47a-7d0179a21350");
    }

    @Override
    public void initInterstitialAd(Activity activity) {
        if (!TextUtils.isEmpty(INTERSTITIAL_ID)) {
            interstitialAd = new InterstitialAd(activity, INTERSTITIAL_ID);
            interstitialAd.setAdListener(adInterListener);
        }
    }

    @Override
    public void initVideoAd(Activity activity) {
        if (!TextUtils.isEmpty(VIDEO_ID)) {
            rewardedVideoAd = new RewardedVideoAd(activity, VIDEO_ID);
            rewardedVideoAd.setAdListener(adVideoListener);
        }
    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (interstitialAd != null) {
            interstitialAd.destroy();
            interstitialAd = null;
        }

        if (rewardedVideoAd != null) {
            rewardedVideoAd.destroy();
            rewardedVideoAd = null;
        }
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        AdSettings.setIsChildDirected(privacy.isAgeRestrictedUser());
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(INTERSTITIAL_ID)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(VIDEO_ID)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
