package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;


public class AdvertAdapterapplovinmax extends AdapterAdvertBase {
    private static final String CHANNEL_CODE_MAX = "ApplovinMax";

    private static final String KEY_APPLOVIN_INTERSTITIAL_ID = "ad_applovin_interstitial_id";
    private static final String KEY_APPLOVIN_VIDEO_ID = "ad_applovin_video_id";
    private static final String KEY_APPLOVIN_BANNER_ID = "ad_applovin_banner_id";

    private String interUnitId, videoUnitId, bannerUnitId;

    private Yodo1AdCallback intersititalCallback, videoCallback, bannerCallback;
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;

    private MaxInterstitialAd interstitialAd;
    private MaxRewardedAd rewardedAd;
    private MaxAdView bannerAdView;

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private boolean initSuccess = false;
    private Yodo1Privacy privacy;

    private boolean isBannerLoaded;

    private MaxAdListener interstitialAdListener = new MaxAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdLoaded, UnitId: " + maxAd.getAdUnitId());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdDisplayed, UnitId: " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdHidden, UnitId: " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdClicked, UnitId: " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d(getAdvertCode() + " InterstitialAd onAdDisplayFailed, UnitId: " + maxAd.getAdUnitId());
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }
            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }
    };

    private MaxRewardedAdListener videoAdListener = new MaxRewardedAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onAdLoaded");
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d(getAdvertCode() + " RewardedAd onAdLoadFailed, s: " + s + ", i: " + i);
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, s, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onAdDisplayed, UnitId: " + maxAd.getAdUnitId());
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onAdHidden, UnitId: " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onAdClicked, UnitId: " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d(getAdvertCode() + " RewardedAd onAdDisplayFailed, i: " + i + ", UnitId: " + maxAd.getAdUnitId());
            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "", getAdvertCode());
            }

            if (rewardedAd != null) {
                rewardedAd.loadAd();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onRewardedVideoStarted, UnitId: " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            YLog.d(getAdvertCode() + " RewardedAd onRewardedVideoCompleted, UnitId: " + maxAd.getAdUnitId());
            if (videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {

        }
    };

    private MaxAdViewAdListener bannerAdListener = new MaxAdViewAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdLoaded, adUnitId: " + ad.getAdUnitId());
            isBannerLoaded = true;
        }

        @Override
        public void onAdLoadFailed(String adUnitId, int errorCode) {
            YLog.d(getAdvertCode() + " BannerAd onAdLoadFailed, adUnitId: " + adUnitId + ", errorCode: " + errorCode);
            isBannerLoaded = false;
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }

        @Override
        public void onAdHidden(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdHidden, adUnitId: " + ad.getAdUnitId());
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdClicked, adUnitId: " + ad.getAdUnitId());
            if (bannerCallback != null) {
                bannerCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, int errorCode) {
            YLog.d(getAdvertCode() + " BannerAd onAdDisplayFailed, adUnitId: " + ad.getAdUnitId() + ", errorCode: " + errorCode);
            if (bannerCallback != null) {
                bannerCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode + "", getAdvertCode());
            }
        }

        @Override
        public void onAdExpanded(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }

        @Override
        public void onAdCollapsed(MaxAd ad) {
            YLog.d(getAdvertCode() + " BannerAd onAdDisplayed, adUnitId: " + ad.getAdUnitId());

        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE_MAX;
    }

    @Override
    public String getSDKVesion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        AppLovinSdk.initializeSdk(activity, new AppLovinSdk.SdkInitializationListener() {
            @Override
            public void onSdkInitialized(final AppLovinSdkConfiguration configuration) {
                // AppLovin SDK is initialized, start loading ads
                YLog.d(getAdvertCode() + " SDK is initialized, " + configuration.getConsentDialogState().name());
                initSuccess = true;

                if (privacy != null) {

                    if (configuration.getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES) {
                        // Show user consent dialog
                        AppLovinPrivacySettings.setHasUserConsent(privacy.isHasUserConsent(), activity);
                    }
                    YLog.d(getAdvertCode() + " SDK isChild, " + privacy.isAgeRestrictedUser());
                    AppLovinPrivacySettings.setIsAgeRestrictedUser(privacy.isAgeRestrictedUser(), activity);
                }
            }
        });
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initVideoAd(final Activity activity) {
        videoUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, getAdvertCode(), KEY_APPLOVIN_VIDEO_ID);
        if (TextUtils.isEmpty(videoUnitId)) {
            YLog.d(getAdvertCode() + " videoUnitId is null");
            return;
        }

        new Handler().postDelayed(new Runnable() {
            public void run() {
                if (!initSuccess) {
                    YLog.d(getAdvertCode() + " SDK uninitialized successfully");
                    return;
                }

                if (rewardedAd == null) {
                    rewardedAd = MaxRewardedAd.getInstance(videoUnitId, activity);
                    rewardedAd.setListener(videoAdListener);
                }
            }
        }, 3000);
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;

        if (rewardedAd == null) {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }

        if (rewardedAd.isReady()) {
            rewardedAd.showAd();
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null)) {
            return;
        }

        if (rewardedAd == null) {
            initVideoAd(activity);
            reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "uninitialized", getAdvertCode());
            return;
        }

        rewardedAd.loadAd();
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedAd != null && rewardedAd.isReady();
    }

    @Override
    public void initInterstitialAd(final Activity activity) {
        interUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, getAdvertCode(), KEY_APPLOVIN_INTERSTITIAL_ID);
        if (TextUtils.isEmpty(interUnitId)) {
            YLog.d(getAdvertCode() + " interUnitId is null");
            return;
        }

        new Handler().postDelayed(new Runnable() {
            public void run() {
                if (!initSuccess) {
                    YLog.d(getAdvertCode() + " SDK uninitialized successfully");
                    return;
                }

                if (interstitialAd == null) {
                    interstitialAd = new MaxInterstitialAd(interUnitId, activity);
                    interstitialAd.setListener(interstitialAdListener);
                }
            }
        }, 3000);
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadInterCallback = reloadCallback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, reloadCallback, null)) {
            return;
        }

        if (interstitialAd == null) {
            initInterstitialAd(activity);
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "uninitialized", getAdvertCode());
            return;
        }

        interstitialAd.loadAd();
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        if (interstitialAd == null) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }
        if (interstitialAd.isReady()) {
            // Load the first ad
            interstitialAd.showAd();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void initBannerAd(final Activity activity) {
        bannerUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, getAdvertCode(), KEY_APPLOVIN_BANNER_ID);
        if (TextUtils.isEmpty(bannerUnitId)) {
            YLog.d(getAdvertCode() + " bannerUnitId is null");
            return;
        }

        new Handler().postDelayed(new Runnable() {
            public void run() {
                if (!initSuccess) {
                    YLog.d(getAdvertCode() + " SDK uninitialized successfully");
                    return;
                }

                if (bannerAdView == null) {
                    bannerAdView = new MaxAdView(bannerUnitId, activity);
                    bannerAdView.setListener(bannerAdListener);
                    bannerAdView.loadAd();
                }
            }
        }, 3000);
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.bannerCallback = callback;

        if (!isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, null, callback)) {
            return;
        }

        if (bannerAdView == null) {
            initBannerAd(activity);
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "uninitialized", getAdvertCode());
            return;
        }

        if (isBannerLoaded) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public boolean hasLoadBanner() {
        return isBannerLoaded;
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(getAdvertCode() + " hideBanner");
        if (bannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void removeBanner(Activity activity) {

    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(getAdvertCode() + " setBannerAlign, align:" + align);
    }


    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        this.privacy = privacy;
        YLog.d(getAdvertCode() + " has user constent:  " + privacy.isHasUserConsent());
        YLog.d(getAdvertCode() + " is age restricted user:  " + privacy.isAgeRestrictedUser());
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd) {
            if (TextUtils.isEmpty(bannerUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(interUnitId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(videoUnitId)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
