package com.yodo1.advert;

import android.app.Activity;

import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 2016/3/22.
 */
public abstract class AdapterAdvertBase implements AdLifecycle {

    /**
     * 获取广告平台的AdvertCode，要与类名后缀一致
     *
     * @return String adChannelCode
     */
    public abstract String getAdvertCode();

    /**
     * 获取广告平台的Sdk版本号
     *
     * @return String SdkVersion
     */
    public String getSDKVesion() {
        return null;
    }

    /**
     * 校验广告SDK manifest声明是否正确
     *
     * @param activity Acvivity
     */
    public void validateAdsAdapter(Activity activity) {
    }

    /**
     * EU consent and GDPR
     *
     * @param privacy Yodo1's privacy
     * @param context Activity
     */
    public void setPrivacy(final Yodo1Privacy privacy, final Activity context) {
    }

    /**
     * Initialize rewarded video ad
     *
     * @param activity Activity
     */
    public void initVideoAd(Activity activity) {
    }

    /**
     * Show reward video Ad
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Reload reward video Ad
     *
     * @param activity       Activity
     * @param reloadCallback Yodo1ReloadCallback
     */
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @param activity Activity
     * @return true, if the reward video ads have been cached, false otherwise.
     */
    public boolean videoAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Initialize interstitial ad
     *
     * @param activity Activity
     */
    public void initInterstitialAd(Activity activity) {
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Reload interstitial Ad
     *
     * @param activity Activity
     * @param callback Yodo1ReloadCallback
     */
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }

    /**
     * Whether the intertitial ads have been cached
     *
     * @param activity Activity
     * @return true, if the intertitial ads have been cached, false otherwise.
     */
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Initialize banner ad
     *
     * @param activity Activity
     */
    public void initBannerAd(Activity activity) {
    }

    /**
     * Show banner Ad
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
    }

    /**
     * Remove banner ad
     *
     * @param activity Activity
     */
    public void removeBanner(Activity activity) {
    }

    /**
     * Hide banner ad
     *
     * @param activity Activity
     */
    public void hideBanner(Activity activity) {
    }

    /**
     * 设置广告显示位置
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public void setBannerAlign(Activity activity, int align) {
    }

    /**
     * Whether the banner ads have been cached
     *
     * @return true, if the banner ads have been cached, false otherwise.
     */
    public boolean hasLoadBanner() {
        return false;
    }

    /**
     * Initialize native(原生) ad
     */
    public void initNativeAd(Activity activity) {
    }

    /**
     * Show native(原生) Ad.
     *
     * @param activity Activity
     * @param px       广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py       广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw       广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph       广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param callback Yodo1AdCallback
     */
    public void showNativeAdvert(Activity activity, float px, float py, float pw, float ph, Yodo1AdCallback callback) {
    }

    /**
     * Remove native(原生) ad
     *
     * @param activity Activity
     */
    public void removeNativeAdvert(Activity activity) {
    }

    /**
     * Reload navive(原生) ad
     *
     * @param activity Activity
     * @param callback Yodo1ReloadCallback
     */
    public void reloadNativeAdvert(Activity activity, Yodo1ReloadCallback callback) {
    }

    /**
     * Whether the native ads have been cached
     *
     * @param activity Activity
     * @return true, if the native ads have been cached, false otherwise.
     */
    public boolean nativeAdvertIsLoaded(Activity activity) {
        return false;
    }

    /**
     * Show splash Ad.
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    public void showSplashAdvert(Activity activity, Yodo1AdCallback callback) {
    }
}
