package com.yodo1.advert.cocos;

import android.app.Activity;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.open.Yodo1Advert;

public class CocosYodo1Advert {
    static Activity mainactivity;

    public static void init(Activity activity, String appkey) {
        mainactivity = activity;
        Yodo1Advert.initSDK(mainactivity, appkey);
    }

    /**
     * SDK requires that publishers set a flag indicating whether a user located in the European Economic Area (i.e., EEA/GDPR data subject) has provided opt-in consent for the collection and use of personal data.
     *
     * @param consent true, If the user has consented, false otherwise.
     */
    public static void setUserConsent(boolean consent) {
        Yodo1Advert.setUserConsent(consent);
    }

    /**
     * To ensure COPPA, GDPR, and Google Play policy compliance, you should indicate whether a user is a child.
     *
     * @param underAgeOfConsent true, If the user is known to be in an age-restricted category (i.e., under the age of 16), false otherwise.
     */
    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        Yodo1Advert.setTagForUnderAgeOfConsent(underAgeOfConsent);
    }

    public static void showInterstitial() {
        mainactivity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                Yodo1Advert.showInterstitial(mainactivity, new InterstitialCallback() {

                    @Override
                    public void onInterstitialClosed() {
                        showInterstitialAdEvent(AdEventCode.ADVERT_EVENT_CLOSE);
                    }

                    @Override
                    public void onInterstitialShowSucceeded() {
                        showInterstitialAdEvent(AdEventCode.ADVERT_EVENT_DISPLAY);
                    }

                    @Override
                    public void onInterstitialClicked() {
                        showInterstitialAdEvent(AdEventCode.ADVERT_EVENT_CLICK);
                    }

                    @Override
                    public void onInterstitialShowFailed(AdErrorCode arg0) {
                        showInterstitialAdEvent(AdEventCode.ADVERT_EVENT_DISPLAY_FAILED);
                    }

                });
            }
        });
    }

    public static boolean hasInter() {
        return Yodo1Advert.interstitialIsReady(mainactivity);
    }


    public static void showVideo() {
        mainactivity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                if (Yodo1Advert.videoIsReady(mainactivity)) {
                    boolean b = Yodo1Advert.showVideo(mainactivity, new VideoCallback() {

                        @Override
                        public void onVideoClosed(boolean isFinished) {
                            if (isFinished) {
                                showVideoEvent(AdEventCode.ADVERT_EVENT_FINISH);
                            } else {
                                showVideoEvent(AdEventCode.ADVERT_EVENT_CLOSE);
                            }
                        }

                        @Override
                        public void onVideoShow() {
                            showVideoEvent(AdEventCode.ADVERT_EVENT_DISPLAY);
                        }

                        @Override
                        public void onVideoClicked() {
                            showVideoEvent(AdEventCode.ADVERT_EVENT_CLICK);
                        }

                        @Override
                        public void onVideoShowFailed(AdErrorCode arg0) {
                            showVideoEvent(AdEventCode.ADVERT_EVENT_DISPLAY_FAILED);
                        }

                    });
                } else {

                }
            }

        });
    }

    public static boolean hasVideo() {
        return Yodo1Advert.videoIsReady(mainactivity);
    }

    public static void setBannerAlign(final Activity activity, final int align) {
        mainactivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.setBannerAlign(activity, align);
            }
        });
    }

    public static void showBanner() {
        mainactivity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                Yodo1Advert.showBanner(mainactivity, new BannerCallback() {

                    @Override
                    public void onBannerShowFailed(AdErrorCode arg0) {
                        showBanner(AdEventCode.ADVERT_EVENT_DISPLAY_FAILED);
                    }

                    @Override
                    public void onBannerShow() {
                        showBanner(AdEventCode.ADVERT_EVENT_DISPLAY);
                    }

                    @Override
                    public void onBannerClosed() {
                        showBanner(AdEventCode.ADVERT_EVENT_CLOSE);
                    }

                    @Override
                    public void onBannerClicked() {
                        showBanner(AdEventCode.ADVERT_EVENT_CLICK);
                    }
                });
            }
        });
    }

    public static void hideBanner() {
        mainactivity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                Yodo1Advert.hideBanner(mainactivity);
            }
        });
    }

    public static native void showInterstitialAdEvent(int eventCode);

    public static native void showVideoEvent(int eventCode);

    public static native void showBanner(int eventCode);
}
