package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.ads.IShowAdListener;
import com.unity3d.services.monetization.placementcontent.ads.ShowAdPlacementContent;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdapterunityads extends AdapterAdvertBase {
    private static final String CHANNEL_CODE = "Unityads";

    private static final String KEY_UNITYADS_APP_ID = "ad_unityads_app_id";
    private static final String KEY_UNITYADS_INTERSTITIAL_ID = "ad_unityads_interstitial_id";
    private static final String KEY_UNITYADS_REWARDED_ID = "ad_unityads_rewarded_id";

    private Yodo1AdCallback intersititalCallback, videoCallback; //插屏回调
    private Yodo1ReloadCallback reloadInterCallback, reloadVideoCallback;
    private String appId, interstitialPlacementId, rewardedPlacementId;

    IUnityMonetizationListener monetizationListener = new IUnityMonetizationListener() {
        @Override
        public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
            YLog.d(CHANNEL_CODE + " onPlacementContentReady, placementId: " + placementId);
            if (reloadInterCallback != null && placementId.equals(interstitialPlacementId)) {
                reloadInterCallback.onReloadSuccess(getAdvertCode());
            }

            if (reloadVideoCallback != null && placementId.equals(rewardedPlacementId)) {
                reloadVideoCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
            YLog.d(CHANNEL_CODE + " onPlacementContentStateChange, placementId: " + placementId);
        }

        @Override
        public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
            YLog.d(CHANNEL_CODE + " onUnityServicesError, error: " + error.name() + ", message: " + message);
            if (reloadInterCallback != null) {
                reloadInterCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }

            if (reloadVideoCallback != null) {
                reloadVideoCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(CHANNEL_CODE + " showVideoAdvert");

        if (!videoAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        PlacementContent pc = UnityMonetization.getPlacementContent(rewardedPlacementId);
        if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
            ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
            p.show(activity, new IShowAdListener() {
                @Override
                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d(CHANNEL_CODE + " RewardedAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);

                    if (placementId.equals(rewardedPlacementId) && withState == UnityAds.FinishState.COMPLETED) {
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                    }
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                }

                @Override
                public void onAdStarted(String placementId) {
                    YLog.d(CHANNEL_CODE + " RewardedAd onAdStarted, placementId:" + placementId);
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            });
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadVideoCallback = reloadCallback;

        isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, reloadCallback, null);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady(rewardedPlacementId);
    }


    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(CHANNEL_CODE + " showIntersititalAdvert");

        if (!interstitialAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        PlacementContent pc = UnityMonetization.getPlacementContent(interstitialPlacementId);
        if (pc.getType().equalsIgnoreCase("SHOW_AD")) {
            ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
            p.show(activity, new IShowAdListener() {
                @Override
                public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                    YLog.d(CHANNEL_CODE + " InterstitialAd onAdFinished, placementId: " + placementId + ", FinishState : " + withState);

                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                }

                @Override
                public void onAdStarted(String placementId) {
                    YLog.d(CHANNEL_CODE + " InterstitialAd onAdStarted, placementId: " + placementId);
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            });
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadInterCallback = callback;

        isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, callback, null);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(interstitialPlacementId) && UnityMonetization.isReady(interstitialPlacementId);
    }


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return UnityAds.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {
        appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_APP_ID);
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_UNITYADS_INTERSTITIAL_ID);
        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_UNITYADS_REWARDED_ID);

        if (!UnityServices.isInitialized()) {
            if (TextUtils.isEmpty(appId)) {
                YLog.d(CHANNEL_CODE + " unityGameID is null");
                return;
            }
            UnityMonetization.initialize(activity, appId, monetizationListener, false);
        }
    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        MetaData gdprMetaData = new MetaData(context);
        gdprMetaData.set("gdpr.consent", privacy.isHasUserConsent());
        gdprMetaData.commit();
    }

    public boolean isValidConfiguration(Yodo1OnlineConfigAgent.AdvertType advertType, Yodo1ReloadCallback reloadCallback, Yodo1AdCallback adCallback) {
        boolean isValid = true;
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(interstitialPlacementId)) {
                isValid = false;
            }
        } else if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) {
            if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(rewardedPlacementId)) {
                isValid = false;
            }
        }

        if (!isValid) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "", getAdvertCode());
            }
            if (adCallback != null) {
                adCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_ID_NULL, "", getAdvertCode());
            }
        }

        return isValid;
    }
}
