/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.sensor;

import android.content.Context;
import android.text.TextUtils;
import com.yodo1.onlineconfig.b;
import com.yodo1.sdk.kit.f;
import com.yodo1.sdk.kit.g;
import com.yodo1.sensor.Yodo1SensorHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1Sensor {
    private static final String TAG = "[Yodo1Sensor] ";
    private static final String DEFAULT_PRODUCTION_URL = "https://sensors.yodo1api.com/sa?project=production";
    private static final String DEFAULT_DEV_URL = "https://sensors.yodo1api.com/sa?project=default ";
    private static final String KEY_SENSORS_SWITCH = "Sensors_Switch";
    private static final String KEY_SENSORS_SWITCH_DEBUG_MODE = "Sensors_Switch_DebugMode";
    private static final String KEY_SENSORS_SERVER_URL = "Sensors_ServerUrl";
    private static Yodo1SensorHelper helper = Yodo1SensorHelper.getInstance();
    private static boolean enabled = false;

    private static boolean isEnabled() {
        return b.h().a(KEY_SENSORS_SWITCH, "on").equals("on");
    }

    private static boolean isDebugMode() {
        String string = b.h().a(KEY_SENSORS_SWITCH_DEBUG_MODE, "off");
        f.a(TAG, "The sensor debugMode enabled = " + string);
        return string.equals("on");
    }

    private static boolean isLocalProductionEvn(Context context) {
        String string = g.a(context, "LocalIsSensorProduction");
        f.a(TAG, "isLocalProductionEvn isProduction = " + string);
        return TextUtils.equals((CharSequence)string, (CharSequence)"true");
    }

    private static String getServerUrl(Context context) {
        if (Yodo1Sensor.isLocalProductionEvn(context)) {
            return b.h().a(KEY_SENSORS_SERVER_URL, DEFAULT_PRODUCTION_URL);
        }
        return b.h().a(KEY_SENSORS_SERVER_URL, DEFAULT_DEV_URL);
    }

    public static void init(Context context) {
        f.a("[Yodo1Sensor] The Yodo1Sensor init  method is called...");
        if (helper.isInitialized()) {
            return;
        }
        if (Yodo1Sensor.isEnabled()) {
            enabled = true;
            f.a("[Yodo1Sensor] The sensor is turn on....");
            String string = Yodo1Sensor.getServerUrl(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            helper.init(context, string, Yodo1Sensor.isDebugMode());
        } else {
            enabled = false;
            f.a("[Yodo1Sensor] The sensor is turn off....");
        }
    }

    public static void destroy() {
        if (!enabled) {
            return;
        }
        f.a("[Yodo1Sensor] The onDestroy of activity life cycle method is called...");
        helper.onDestroy();
    }

    public static void track(String string, JSONObject jSONObject) {
        if (!enabled) {
            return;
        }
        f.a("[Yodo1Sensor] The track method is called...");
        Yodo1Sensor.appendReportFields(jSONObject);
        helper.track(string, jSONObject);
    }

    public static void profileSet(JSONObject jSONObject) {
        if (!enabled) {
            return;
        }
        f.a("[Yodo1Sensor] The profileSet method is called...");
        helper.profileSet(jSONObject);
    }

    public static String getLoginId() {
        if (!enabled) {
            return "";
        }
        f.a("[Yodo1Sensor] The getLoginId method is called...");
        return helper.getLoginId();
    }

    public static String getAnonymousId() {
        if (!enabled) {
            return "";
        }
        f.a("[Yodo1Sensor] The getAnonymousId method is called...");
        return helper.getAnonymousId();
    }

    public static void login(String string) {
        if (!enabled) {
            return;
        }
        f.a("[Yodo1Sensor] The login method is called...");
        helper.login(string);
    }

    public static void loginOut() {
        if (!enabled) {
            return;
        }
        f.a("[Yodo1Sensor] The loginOut method is called...");
        helper.loginOut();
    }

    public static void trackAppStartup() {
        JSONObject jSONObject;
        if (!enabled) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        Yodo1Sensor.track("startup", jSONObject2);
        helper.trackTimerStart("end");
        f.a("[Yodo1Sensor]  track event : startup");
    }

    public static void trackAppQuit() {
        JSONObject jSONObject;
        if (!enabled) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        helper.trackTimerEnd("end", jSONObject2);
        f.a("[Yodo1Sensor]  track event : end");
    }

    private static void appendReportFields(JSONObject jSONObject) {
        JSONArray jSONArray = b.h().c();
        if (jSONArray == null) {
            return;
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String string;
            String string2;
            block11: {
                JSONObject jSONObject2;
                block10: {
                    jSONObject2 = jSONArray.getJSONObject(i2);
                    string2 = null;
                    if (!jSONObject2.has("key")) break block10;
                    string2 = jSONObject2.getString("key");
                }
                string = null;
                if (!jSONObject2.has("value")) break block11;
                string = jSONObject2.getString("value");
            }
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            try {
                jSONObject.put(string2, (Object)string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            continue;
        }
    }
}

