/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.idtracking;

import android.content.Context;
import android.content.SharedPreferences;
import com.umeng.analytics.pro.av;
import com.umeng.analytics.pro.bl;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.internal.crash.UMCrashManager;
import com.umeng.commonsdk.statistics.common.DataHelper;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.common.b;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.File;
import org.json.JSONObject;

public class Envelope {
    private static final String dummyID1 = "1234567890987654321";
    private static final String dummyID2 = "02:00:00:00:00:00";
    private final byte[] SEED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int CODEX_ENCRYPT;
    private final int CODEX_NORMAL;
    private String mVersion = "1.0";
    private String mAddress = null;
    private byte[] mSignature = null;
    private byte[] mGuid = null;
    private byte[] mChecksum = null;
    private int mSerialNo = 0;
    private int mTimestamp = 0;
    private int mLength = 0;
    private byte[] mEntity = null;
    private byte[] identity = null;
    private boolean encrypt = false;

    private Envelope(byte[] byArray, String string, byte[] byArray2) throws Exception {
        this.CODEX_ENCRYPT = 1;
        this.CODEX_NORMAL = 0;
        if (byArray != null && byArray.length != 0) {
            Envelope envelope = this;
            this.mAddress = string;
            this.mLength = byArray.length;
            envelope.mEntity = b.a(byArray);
            envelope.mTimestamp = (int)(System.currentTimeMillis() / 1000L);
            this.identity = byArray2;
            return;
        }
        throw new Exception("entity is null or empty");
    }

    public static String getSignature(Context context) {
        if ((context = PreferenceWrapper.getDefault(context)) == null) {
            return null;
        }
        return context.getString("signature", null);
    }

    public static Envelope genEnvelope(Context context, String string, byte[] byArray) {
        Envelope envelope;
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = PreferenceWrapper.getDefault(context);
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        String string2 = sharedPreferences.getString("signature", null);
        int n2 = sharedPreferences.getInt("serial", 1);
        Envelope envelope2 = envelope;
        Context context2 = context;
        Envelope envelope3 = envelope2;
        envelope2(byArray, string, "123456789098765432102:00:00:00:00:00".getBytes());
        envelope2.setSignature(string2);
        envelope3.setSerialNumber(n2);
        envelope3.seal();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        SharedPreferences.Editor editor2 = editor.putInt("serial", n2 + 1);
        editor2.putString("signature", envelope2.getSignature()).commit();
        envelope.export(context2);
        return envelope;
    }

    public static Envelope genEncryptEnvelope(Context context, String string, byte[] byArray) {
        Envelope envelope;
        SharedPreferences sharedPreferences;
        try {
            sharedPreferences = PreferenceWrapper.getDefault(context);
        }
        catch (Exception exception) {
            UMCrashManager.reportCrash(context, exception);
            return null;
        }
        String string2 = sharedPreferences.getString("signature", null);
        int n2 = sharedPreferences.getInt("serial", 1);
        Envelope envelope2 = envelope;
        Context context2 = context;
        Envelope envelope3 = envelope2;
        Envelope envelope4 = envelope2;
        envelope4(byArray, string, "123456789098765432102:00:00:00:00:00".getBytes());
        envelope4.setEncrypt(true);
        envelope2.setSignature(string2);
        envelope3.setSerialNumber(n2);
        envelope3.seal();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        SharedPreferences.Editor editor2 = editor.putInt("serial", n2 + 1);
        editor2.putString("signature", envelope2.getSignature()).commit();
        envelope.export(context2);
        return envelope;
    }

    private byte[] genGuid(byte[] byArray, int n2) {
        byte[] byArray2 = DataHelper.hash(((Envelope)object).identity);
        Object object = DataHelper.hash(((Envelope)object).mEntity);
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[n3 * 2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 * 2;
            byArray3[n4] = (byte)object[i2];
            byArray3[n4 + 1] = byArray2[i2];
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            byte[] byArray4 = byArray3;
            byArray4[i3] = byArray[i3];
            byArray3[byArray4.length - i3 - 1] = byArray[byArray.length - i3 - 1];
        }
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = byArray5;
        byArray6[0] = (byte)(n2 & 0xFF);
        byArray6[1] = (byte)(n2 >> 8 & 0xFF);
        byArray6[2] = (byte)(n2 >> 16 & 0xFF);
        byArray5[3] = (byte)(n2 >>> 24);
        for (int i4 = 0; i4 < byArray3.length; ++i4) {
            byArray3[i4] = (byte)(byArray3[i4] ^ byArray6[i4 % 4]);
        }
        return byArray3;
    }

    private byte[] genSignature() {
        Envelope envelope = this;
        return envelope.genGuid(envelope.SEED, (int)(System.currentTimeMillis() / 1000L));
    }

    private byte[] genCheckSum() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append(DataHelper.toHexString(this.mSignature));
        stringBuilder2.append(this.mSerialNo);
        stringBuilder2.append(this.mTimestamp);
        stringBuilder2.append(this.mLength);
        stringBuilder.append(DataHelper.toHexString(this.mGuid));
        return DataHelper.hash(stringBuilder.toString().getBytes());
    }

    public void setSignature(String string) {
        this.mSignature = DataHelper.reverseHexString(string);
    }

    public String getSignature() {
        return DataHelper.toHexString(this.mSignature);
    }

    public void setSerialNumber(int n2) {
        this.mSerialNo = n2;
    }

    public void setEncrypt(boolean bl2) {
        this.encrypt = bl2;
    }

    public void seal() {
        if (this.mSignature == null) {
            this.mSignature = this.genSignature();
        }
        if (this.encrypt) {
            Envelope envelope = this;
            byte[] byArray = new byte[16];
            try {
                System.arraycopy(envelope.mSignature, 1, byArray, 0, 16);
                envelope.mEntity = DataHelper.encrypt(envelope.mEntity, byArray);
            }
            catch (Exception exception) {}
        }
        Envelope envelope = this;
        envelope.mGuid = envelope.genGuid(envelope.mSignature, this.mTimestamp);
        envelope.mChecksum = envelope.genCheckSum();
    }

    public byte[] toBinary() {
        av av2;
        av av3 = av2;
        av3();
        av3.a(this.mVersion);
        av3.b(this.mAddress);
        av3.c(DataHelper.toHexString(this.mSignature));
        av3.a(this.mSerialNo);
        av3.b(this.mTimestamp);
        av3.c(this.mLength);
        av3.a(this.mEntity);
        av3.d(this.encrypt ? 1 : 0);
        av3.d(DataHelper.toHexString(this.mGuid));
        av2.e(DataHelper.toHexString(this.mChecksum));
        try {
            return new bl().a(av3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void export(Context context) {
        JSONObject jSONObject;
        Object object;
        Object object2;
        String string;
        String string2;
        block20: {
            File file;
            JSONObject jSONObject2;
            string2 = ((Envelope)object).mAddress;
            string = UMEnvelopeBuild.imprintProperty(context, "umid", null);
            String string3 = DataHelper.toHexString(((Envelope)object).mSignature);
            object2 = new byte[16];
            System.arraycopy(((Envelope)object).mSignature, 2, object2, 0, 16);
            object = DataHelper.toHexString(DataHelper.hash(object2));
            object2 = jSONObject2;
            jSONObject2 = new JSONObject();
            jSONObject2.put("appkey", (Object)string2);
            if (string != null) {
                object2.put("umid", (Object)string);
            }
            Object object3 = object2;
            object2.put("signature", (Object)string3);
            object3.put("checksum", object);
            object = file;
            if (new File(context.getFilesDir(), ".umeng").exists()) break block20;
            ((File)object).mkdir();
        }
        try {
            HelperUtils.writeFile(new File((File)object, "exchangeIdentity.json"), object2.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        String string4 = string;
        object = jSONObject;
        new JSONObject().put("appkey", (Object)string2);
        object.put("channel", (Object)UMUtils.getChannel(context));
        if (string4 != null) {
            object.put("umid", (Object)HelperUtils.getUmengMD5(string));
        }
        try {
            HelperUtils.writeFile(new File(context.getFilesDir(), "exid.dat"), object.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.mVersion;
        stringBuilder.append(String.format("version : %s\n", objectArray2));
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = this.mAddress;
        stringBuilder.append(String.format("address : %s\n", objectArray2));
        Object[] objectArray4 = new Object[1];
        objectArray2 = objectArray4;
        objectArray4[0] = DataHelper.toHexString(this.mSignature);
        stringBuilder.append(String.format("signature : %s\n", objectArray2));
        Object[] objectArray5 = new Object[1];
        objectArray2 = objectArray5;
        objectArray5[0] = this.mSerialNo;
        stringBuilder.append(String.format("serial : %s\n", objectArray2));
        Object[] objectArray6 = new Object[1];
        objectArray2 = objectArray6;
        objectArray6[0] = this.mTimestamp;
        stringBuilder.append(String.format("timestamp : %d\n", objectArray2));
        Object[] objectArray7 = new Object[1];
        objectArray2 = objectArray7;
        objectArray7[0] = this.mLength;
        stringBuilder.append(String.format("length : %d\n", objectArray2));
        Object[] objectArray8 = new Object[1];
        objectArray2 = objectArray8;
        objectArray8[0] = DataHelper.toHexString(this.mGuid);
        stringBuilder.append(String.format("guid : %s\n", objectArray2));
        Object[] objectArray9 = new Object[1];
        objectArray2 = objectArray9;
        objectArray9[0] = DataHelper.toHexString(this.mChecksum);
        stringBuilder.append(String.format("checksum : %s ", objectArray2));
        stringBuilder.append(String.format("codex : %d", this.encrypt ? 1 : 0));
        return stringBuilder.toString();
    }
}

