/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.minisdk.util;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.sensorsdata.analytics.android.minisdk.SALog;
import com.yodo1.sdk.base.android.a;
import com.yodo1.sdk.kit.d;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SensorsDataUtils {
    private static final String SHARED_PREF_USER_AGENT_KEY = "sensorsdata.user.agent";
    private static final SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA);
    private static final Map<String, String> sCarrierMap = new HashMap<String, String>(){
        {
            1 v0 = this;
            v0.put("46000", "\u4e2d\u56fd\u79fb\u52a8");
            v0.put("46002", "\u4e2d\u56fd\u79fb\u52a8");
            v0.put("46007", "\u4e2d\u56fd\u79fb\u52a8");
            v0.put("46008", "\u4e2d\u56fd\u79fb\u52a8");
            v0.put("46001", "\u4e2d\u56fd\u8054\u901a");
            v0.put("46006", "\u4e2d\u56fd\u8054\u901a");
            v0.put("46009", "\u4e2d\u56fd\u8054\u901a");
            v0.put("46003", "\u4e2d\u56fd\u7535\u4fe1");
            v0.put("46005", "\u4e2d\u56fd\u7535\u4fe1");
            v0.put("46011", "\u4e2d\u56fd\u7535\u4fe1");
        }
    };
    private static final List<String> mInvalidAndroidId = new ArrayList<String>(){
        {
            2 v0 = this;
            v0.add("9774d56d682e549c");
            v0.add("0123456789abcdef");
        }
    };
    private static final String TAG = "SA.SensorsDataUtils";

    public static String getCarrier(Context object) {
        block8: {
            if (!SensorsDataUtils.checkHasPermission(object, "android.permission.READ_PHONE_STATE")) break block8;
            object = (TelephonyManager)object.getSystemService("phone");
            if (object == null) break block8;
            object = object.getSubscriberId();
            if (TextUtils.isEmpty((CharSequence)object)) break block8;
            try {
                return SensorsDataUtils.operatorToCarrier((String)object);
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getCurrentProcessName(Context context) {
        block11: {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
            Object object;
            int n2;
            block10: {
                Context context2 = context;
                n2 = Process.myPid();
                object = (ActivityManager)context2.getSystemService("activity");
                if (object != null) break block10;
                return null;
            }
            object = object.getRunningAppProcesses();
            if (object == null) break block11;
            object = object.iterator();
            while (true) {
                if (!object.hasNext()) break block11;
                runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo == null) continue;
                if (runningAppProcessInfo.pid == n2) break;
                continue;
                break;
            }
            try {
                return runningAppProcessInfo.processName;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static String operatorToCarrier(String string) {
        String string2 = "\u5176\u4ed6";
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string2;
        }
        for (Map.Entry<String, String> entry : sCarrierMap.entrySet()) {
            if (!string.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return string2;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(d.b(context) + ".sa", 0);
    }

    public static void cleanUserAgent(Context context) {
        SharedPreferences.Editor editor = SensorsDataUtils.getSharedPreferences(context).edit();
        SharedPreferences.Editor editor2 = editor;
        editor.putString(SHARED_PREF_USER_AGENT_KEY, null);
        try {
            editor2.apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeJSONObject(JSONObject jSONObject, JSONObject jSONObject2) throws JSONException {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = jSONObject.get(string);
            if (object instanceof Date) {
                SimpleDateFormat simpleDateFormat = mDateFormat;
                synchronized (simpleDateFormat) {
                    jSONObject2.put(string, (Object)mDateFormat.format((Date)object));
                    continue;
                }
            }
            jSONObject2.put(string, object);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String getUserAgent(Context var0) {
        block26: {
            block25: {
                block23: {
                    block24: {
                        var1_1 = SensorsDataUtils.getSharedPreferences(var0);
                        var2_2 = var1_1.getString("sensorsdata.user.agent", null);
                        if (!TextUtils.isEmpty((CharSequence)var2_2)) break block23;
                        if (Build.VERSION.SDK_INT < 17) break block24;
                        v0 = Class.forName("android.webkit.WebSettings");
                        try {
                            ** if (v0.getMethod((String)"getDefaultUserAgent", new Class[0]) == null) goto lbl-1000
                        }
                        catch (Exception v2) {
                            SALog.i("SA.SensorsDataUtils", "WebSettings NoSuchMethod: getDefaultUserAgent");
                            break block23;
                        }
lbl-1000:
                        // 1 sources

                        {
                            v1 = WebSettings.getDefaultUserAgent((Context)var0);
lbl15:
                            // 2 sources

                            while (true) {
                                var2_2 = v1;
                                ** GOTO lbl40
                                break;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            break block23;
                        }
                    }
                    try {
                        v3 = Class.forName("android.webkit.WebSettingsClassic");
                        v4 = v3;
                        v5 = v3;
                        v6 = new Class[2];
                    }
                    catch (Exception v7) {}
                    v6[0] = Context.class;
                    v6[1] = Class.forName("android.webkit.WebViewClassic");
                    var3_3 = v4.getDeclaredConstructor(v6);
                    var3_3.setAccessible(true);
                    v1 = (String)v5.getMethod("getUserAgentString", new Class[0]).invoke(var3_3.newInstance(new Object[]{var0, null}), new Object[0]);
                    ** continue;
                }
                if (!TextUtils.isEmpty((CharSequence)var2_2)) break block25;
                {
                    catch (Exception v8) {
                        v8.printStackTrace();
                        return null;
                    }
                }
                var2_2 = System.getProperty("http.agent");
            }
            if (TextUtils.isEmpty((CharSequence)var2_2)) break block26;
            v9 = var1_1.edit();
            v10 = v9;
            v9.putString("sensorsdata.user.agent", var2_2);
            v10.apply();
        }
        return var2_2;
    }

    public static boolean checkHasPermission(Context context, String string) {
        block3: {
            try {
                if (a.a(context, string)) break block3;
            }
            catch (Exception exception) {
                SALog.i(TAG, exception.toString());
                return false;
            }
            SALog.i(TAG, "You can fix this by adding the following to your AndroidManifest.xml file:\n<uses-permission android:name=\"" + string + "\" />");
            return false;
        }
        return true;
    }

    public static String networkType(Context context) {
        if (!SensorsDataUtils.checkHasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return "NULL";
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && (connectivityManager = connectivityManager.getNetworkInfo(1)) != null && connectivityManager.isConnectedOrConnecting()) {
            return "WIFI";
        }
        switch (((TelephonyManager)context.getSystemService("phone")).getNetworkType()) {
            default: {
                return "NULL";
            }
            case 13: {
                return "4G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
        }
        return "2G";
    }

    public static boolean isNetworkAvailable(Context context) {
        block4: {
            if (!SensorsDataUtils.checkHasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                return false;
            }
            try {
                context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
                if (context == null) break block4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            if (!context.isConnected()) break block4;
            return true;
        }
        return false;
    }

    public static String getAndroidID(Context object) {
        Context context = object;
        object = "";
        try {
            object = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public static boolean isValidAndroidId(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return !mInvalidAndroidId.contains(string.toLowerCase());
    }
}

