/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.statistics.internal.b;

public class StatTracer
implements b {
    private static final String KEY_CLIENT_REQUEST_SUCCESS = "successful_request";
    private static final String KEY_CLIENT_REQUEST_FAILED = "failed_requests ";
    private static final String KEY_CLIENT_REQUEST_LATENCY = "last_request_spent_ms";
    private static final String KEY_CLIENT_REQUEST_TIME = "last_request_time";
    private static final String KEY_FIRST_ACTIVATE_TIME = "first_activate_time";
    private static final String KEY_LAST_REQ = "last_req";
    private static Context mContext;
    private final int MAX_REQUEST_LIMIT;
    public int mSuccessfulRequest;
    public int mFailedRequest;
    private int mLastRequestLatency;
    public long mLastSuccessfulRequestTime;
    private long lastRequestTime;
    private long firstActivateTime;

    private StatTracer() {
        StatTracer statTracer = this;
        statTracer.MAX_REQUEST_LIMIT = 3600000;
        statTracer.lastRequestTime = 0L;
        statTracer.firstActivateTime = 0L;
        statTracer.init();
    }

    public static StatTracer getInstance(Context context) {
        if (mContext == null) {
            if (context != null) {
                mContext = context.getApplicationContext();
            } else {
                MLog.e("inside StatTracer. please check context. context must not be null!");
            }
        }
        return a.a;
    }

    private void init() {
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(mContext);
        this.mSuccessfulRequest = sharedPreferences.getInt(KEY_CLIENT_REQUEST_SUCCESS, 0);
        this.mFailedRequest = sharedPreferences.getInt(KEY_CLIENT_REQUEST_FAILED, 0);
        this.mLastRequestLatency = sharedPreferences.getInt(KEY_CLIENT_REQUEST_LATENCY, 0);
        this.mLastSuccessfulRequestTime = sharedPreferences.getLong(KEY_CLIENT_REQUEST_TIME, 0L);
        this.lastRequestTime = sharedPreferences.getLong(KEY_LAST_REQ, 0L);
    }

    public int getLastRequestLatency() {
        int n2 = this.mLastRequestLatency;
        if (n2 > 3600000) {
            n2 = 3600000;
        }
        return n2;
    }

    public boolean isFirstRequest() {
        return this.mLastSuccessfulRequestTime == 0L;
    }

    public void logSuccessfulRequest(boolean bl2) {
        ++this.mSuccessfulRequest;
        if (bl2) {
            this.mLastSuccessfulRequestTime = this.lastRequestTime;
        }
    }

    public void logFailedRequest() {
        ++this.mFailedRequest;
    }

    public void logRequestStart() {
        this.lastRequestTime = System.currentTimeMillis();
    }

    public void logRequestEnd() {
        this.mLastRequestLatency = (int)(System.currentTimeMillis() - this.lastRequestTime);
    }

    public void saveSate() {
        long l2 = this.lastRequestTime;
        SharedPreferences.Editor editor = PreferenceWrapper.getDefault(mContext).edit().putInt(KEY_CLIENT_REQUEST_SUCCESS, this.mSuccessfulRequest).putInt(KEY_CLIENT_REQUEST_FAILED, this.mFailedRequest).putInt(KEY_CLIENT_REQUEST_LATENCY, this.mLastRequestLatency).putLong(KEY_LAST_REQ, l2);
        l2 = this.mLastSuccessfulRequestTime;
        editor.putLong(KEY_CLIENT_REQUEST_TIME, l2).commit();
    }

    public long getFirstActivateTime() {
        SharedPreferences sharedPreferences = PreferenceWrapper.getDefault(mContext);
        this.firstActivateTime = PreferenceWrapper.getDefault(mContext).getLong(KEY_FIRST_ACTIVATE_TIME, 0L);
        if (this.firstActivateTime == 0L) {
            long l2 = this.firstActivateTime = System.currentTimeMillis();
            sharedPreferences.edit().putLong(KEY_FIRST_ACTIVATE_TIME, l2).commit();
        }
        return this.firstActivateTime;
    }

    public long getLastReqTime() {
        return this.lastRequestTime;
    }

    @Override
    public void onRequestStart() {
        this.logRequestStart();
    }

    @Override
    public void onRequestEnd() {
        this.logRequestEnd();
    }

    @Override
    public void onRequestSucceed(boolean bl2) {
        this.logSuccessfulRequest(bl2);
    }

    @Override
    public void onRequestFailed() {
        this.logFailedRequest();
    }

    private static class a {
        public static final StatTracer a = new StatTracer();

        private a() {
        }
    }
}

