/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.umeng.commonsdk.config.FieldManagerEx;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.AnalyticsConstants;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.statistics.common.a;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.microedition.khronos.opengles.GL10;

public class DeviceConfigEx {
    protected static final String LOG_TAG = DeviceConfig.class.getName();
    public static final String UNKNOW = "";
    public static final String MOBILE_NETWORK = "2G/3G";
    public static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_EMUI_VERSION_CODE = "ro.build.hw_emui_api_level";

    public static String getImei(Context context) {
        String string;
        block5: {
            string = null;
            if (context != null) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager == null) break block5;
                if (!DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) break block5;
                try {
                    string = telephonyManager.getDeviceId();
                }
                catch (Exception exception) {
                    if (!AnalyticsConstants.UM_DEBUG) break block5;
                    MLog.w("No IMEI.", exception);
                }
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getImeiNew(Context context) {
        String string;
        TelephonyManager telephonyManager;
        String string2;
        block13: {
            Class<?> clazz;
            string2 = null;
            if (!FieldManagerEx.allow("header_tracking_imei")) return string2;
            if (context == null) return string2;
            telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) return string2;
            if (!DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) return string2;
            if (Build.VERSION.SDK_INT < 26) break block13;
            try {
                clazz = telephonyManager.getClass();
            }
            catch (Exception exception) {}
            Method method = clazz.getMethod("getImei", new Class[0]);
            method.setAccessible(true);
            string2 = (String)method.invoke((Object)telephonyManager, new Object[0]);
            if (!TextUtils.isEmpty((CharSequence)string2)) return string2;
            string = telephonyManager.getDeviceId();
            return string;
        }
        try {
            string = telephonyManager.getDeviceId();
            return string;
        }
        catch (Exception exception) {
            if (!AnalyticsConstants.UM_DEBUG) return string2;
            MLog.w("No IMEI.", exception);
        }
        return string2;
    }

    public static String getAndroidId(Context context) {
        String string;
        block3: {
            string = null;
            if (FieldManagerEx.allow("header_tracking_android_id") && context != null) {
                try {
                    string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                }
                catch (Exception exception) {
                    if (!AnalyticsConstants.UM_DEBUG) break block3;
                    MLog.w("can't read android id");
                }
            }
        }
        return string;
    }

    public static String getSerial() {
        int n2;
        if (FieldManagerEx.allow("header_tracking_serial") && (n2 = Build.VERSION.SDK_INT) >= 9) {
            String string = null;
            if (n2 >= 26) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("android.os.Build");
                }
                catch (Throwable throwable) {}
                string = (String)clazz.getMethod("getSerial", new Class[0]).invoke(clazz, new Object[0]);
            } else {
                string = Build.SERIAL;
            }
            return string;
        }
        return null;
    }

    public static String getAppVersionCode(Context context) {
        return UMUtils.getAppVersionCode(context);
    }

    public static String getAppVersionName(Context context) {
        return UMUtils.getAppVersionName(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkPermission(Context context, String string) {
        boolean bl2 = false;
        if (context == null) {
            return bl2;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                if ((Integer)Class.forName("android.content.Context").getMethod("checkSelfPermission", String.class).invoke((Object)context, string) != 0) return false;
                return true;
            }
            catch (Throwable throwable) {}
            return false;
        }
        if (context.getPackageManager().checkPermission(string, context.getPackageName()) == 0) return true;
        return bl2;
    }

    public static String[] getGPU(GL10 object) {
        GL10 gL10;
        String[] stringArray;
        try {
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            String[] stringArray3 = stringArray2;
            String[] stringArray4 = stringArray2;
            GL10 gL102 = object;
            gL10 = gL102;
            object = gL102.glGetString(7936);
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.e(DeviceConfig.LOG_TAG, "Could not read gpu infor:", throwable);
            }
            return new String[0];
        }
        String string = gL10.glGetString(7937);
        stringArray3[0] = object;
        stringArray4[1] = string;
        return stringArray;
    }

    private static String getMacByJavaAPI() {
        block21: {
            block22: {
                byte[] byArray;
                Object object;
                if (!FieldManagerEx.allow("header_device_id_mac")) break block21;
                Object object2 = NetworkInterface.getNetworkInterfaces();
                while (true) {
                    if (!object2.hasMoreElements()) break block21;
                    object = object2.nextElement();
                    if ("wlan0".equals(((NetworkInterface)object).getName())) break;
                    if (!"eth0".equals(((NetworkInterface)object).getName())) continue;
                    break;
                }
                try {
                    byArray = ((NetworkInterface)object).getHardwareAddress();
                }
                catch (Throwable throwable) {}
                object2 = byArray;
                if (byArray != null) {
                    block23: {
                        StringBuilder stringBuilder;
                        if (((Object)object2).length == 0) break block22;
                        Object object3 = object2;
                        object = stringBuilder;
                        stringBuilder = new StringBuilder();
                        int n2 = ((Object)object3).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Object object4 = object;
                            Object object5 = object2[i2];
                            Object[] objectArray = new Object[1];
                            objectArray[0] = (byte)object5;
                            ((StringBuilder)object4).append(String.format("%02X:", objectArray));
                        }
                        if (((StringBuilder)object).length() <= 0) break block23;
                        Object object6 = object;
                        Object object7 = object6;
                        int n3 = ((StringBuilder)object6).length();
                        ((StringBuilder)object7).deleteCharAt(n3 - 1);
                    }
                    return ((StringBuilder)object).toString().toLowerCase(Locale.getDefault());
                }
            }
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String getMacShell() {
        block11: {
            if (!FieldManagerEx.allow("header_device_id_mac")) break block11;
            v0 = new String[3];
            var0 = v0;
            v0[0] = "/sys/class/net/wlan0/address";
            v0[1] = "/sys/class/net/eth0/address";
            v0[2] = "/sys/devices/virtual/net/wlan0/address";
            var1_1 = 0;
            while (true) lbl-1000:
            // 2 sources

            {
                if (var1_1 >= var0.length) break block11;
                break;
            }
            {
                catch (Throwable v1) {}
            }
            {
                block12: {
                    try {
                        var2_2 = DeviceConfigEx.reaMac(var0[var1_1]);
                        if (var2_2 != null) {
                            return var2_2;
                        }
                    }
                    catch (Throwable var2_3) {
                        if (!AnalyticsConstants.UM_DEBUG) break block12;
                        MLog.e(DeviceConfig.LOG_TAG, "open file  Failed", var2_3);
                    }
                }
                ++var1_1;
                ** while (true)
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String reaMac(String object) {
        Object object2;
        FileReader fileReader;
        block16: {
            BufferedReader bufferedReader;
            FileReader fileReader2;
            String string = null;
            fileReader = fileReader2;
            try {
                fileReader2 = new FileReader((String)object);
                object = null;
            }
            catch (Throwable throwable) {
                return string;
            }
            object2 = bufferedReader;
            try {
                bufferedReader = new BufferedReader(fileReader, 1024);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block16;
            }
            try {
                string = bufferedReader.readLine();
            }
            catch (Throwable throwable) {
                object = object2;
                object2 = throwable;
                break block16;
            }
            try {
                fileReader2.close();
            }
            catch (Throwable throwable) {}
            {
                ((BufferedReader)object2).close();
                return string;
            }
        }
        try {
            fileReader.close();
        }
        catch (Throwable throwable) {}
        if (object == null) throw object2;
        try {
            ((BufferedReader)object).close();
            throw object2;
        }
        catch (Throwable throwable) {}
        {
            throw object2;
        }
    }

    public static String getCPU() {
        if (FieldManagerEx.allow("header_cpu")) {
            FileReader fileReader;
            String string = null;
            FileReader fileReader2 = fileReader;
            fileReader = new FileReader("/proc/cpuinfo");
            BufferedReader bufferedReader = new BufferedReader(fileReader2, 1024);
            BufferedReader bufferedReader2 = bufferedReader;
            string = bufferedReader.readLine();
            try {
                bufferedReader2.close();
                fileReader.close();
            }
            catch (Throwable throwable) {
                try {
                    MLog.e(DeviceConfig.LOG_TAG, "Could not read from file /proc/cpuinfo", throwable);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MLog.e(DeviceConfig.LOG_TAG, "Could not open file /proc/cpuinfo", fileNotFoundException);
                }
            }
            if (string != null) {
                String string2 = string;
                return string2.substring(string2.indexOf(58) + 1).trim();
            }
        }
        return UNKNOW;
    }

    public static String getDeviceId(Context context) {
        if (AnalyticsConstants.getDeviceType() == 2) {
            return DeviceConfigEx.getDeviceIdForBox(context);
        }
        return DeviceConfigEx.getDeviceIdForGeneral(context);
    }

    public static String getDeviceIdUmengMD5(Context context) {
        return HelperUtils.getUmengMD5(DeviceConfigEx.getDeviceId(context));
    }

    public static String getMCCMNC(Context context) {
        block10: {
            String string;
            int n2;
            block13: {
                block12: {
                    block11: {
                        try {
                            if (!FieldManagerEx.allow("header_mccmnc")) break block10;
                            if (context != null) break block11;
                            return null;
                        }
                        catch (Throwable throwable) {}
                    }
                    if (DeviceConfigEx.getImsi(context) != null) break block12;
                    return null;
                }
                n2 = context.getResources().getConfiguration().mcc;
                int n3 = context.getResources().getConfiguration().mnc;
                if (n2 == 0) break block10;
                int n4 = n3;
                string = String.valueOf(n4);
                if (n4 >= 10) break block13;
                Object[] objectArray = new Object[1];
                objectArray[0] = n3;
                string = String.format("%02d", objectArray);
            }
            return new StringBuffer().append(String.valueOf(n2)).append(string).toString();
        }
        return null;
    }

    public static String getImsi(Context context) {
        String string;
        block4: {
            if (context == null) {
                return null;
            }
            Context context2 = context;
            context = (TelephonyManager)context2.getSystemService("phone");
            string = null;
            try {
                if (!DeviceConfigEx.checkPermission(context2, "android.permission.READ_PHONE_STATE") || context == null) break block4;
            }
            catch (Throwable throwable) {}
            string = context.getSubscriberId();
        }
        return string;
    }

    public static String getRegisteredOperator(Context object) {
        block5: {
            TelephonyManager telephonyManager;
            if (object == null) {
                return null;
            }
            Context context = object;
            object = null;
            try {
                telephonyManager = (TelephonyManager)context.getSystemService("phone");
            }
            catch (Throwable throwable) {}
            if (!DeviceConfigEx.checkPermission(context, "android.permission.READ_PHONE_STATE") || telephonyManager == null) break block5;
            object = telephonyManager.getNetworkOperator();
        }
        return object;
    }

    public static String getNetworkOperatorName(Context context) {
        block6: {
            if (context == null) {
                return UNKNOW;
            }
            if (FieldManagerEx.allow("header_carrier")) {
                Context context2;
                try {
                    Context context3 = context;
                    context2 = context3;
                    context = (TelephonyManager)context3.getSystemService("phone");
                }
                catch (Throwable throwable) {}
                if (!DeviceConfigEx.checkPermission(context2, "android.permission.READ_PHONE_STATE") || context == null) break block6;
                return context.getNetworkOperatorName();
            }
        }
        return UNKNOW;
    }

    public static String getDisplayResolution(Context context) {
        block8: {
            DisplayMetrics displayMetrics;
            Context context2;
            if (context == null) {
                return UNKNOW;
            }
            try {
                context2 = context;
            }
            catch (Throwable throwable) {
                return UNKNOW;
            }
            context = displayMetrics;
            displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context2.getSystemService("window");
            if (windowManager == null) break block8;
            Context context3 = context;
            Context context4 = context3;
            windowManager.getDefaultDisplay().getMetrics((DisplayMetrics)context);
            int n2 = context3.widthPixels;
            int n3 = context4.heightPixels;
            return String.valueOf(n3) + "*" + String.valueOf(n2);
        }
        return UNKNOW;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getNetworkAccessMode(Context var0) {
        block10: {
            v0 = new String[2];
            var1_1 = v0;
            v0[0] = "";
            v0[1] = "";
            if (var0 == null) {
                return var1_1;
            }
            if (!FieldManagerEx.allow("header_access")) break block10;
            try {
                if (DeviceConfigEx.checkPermission(var0, "android.permission.ACCESS_NETWORK_STATE")) ** GOTO lbl14
            }
            catch (Throwable v1) {}
            var1_1[0] = "";
            return var1_1;
lbl14:
            // 1 sources

            if ((var0 = (ConnectivityManager)var0.getSystemService("connectivity")) != null) ** GOTO lbl18
            var1_1[0] = "";
            return var1_1;
lbl18:
            // 1 sources

            var2_2 = var0.getNetworkInfo(1);
            if (var2_2 == null) ** GOTO lbl25
            if (var2_2.getState() != NetworkInfo.State.CONNECTED) ** GOTO lbl25
            var1_1[0] = "Wi-Fi";
            return var1_1;
lbl25:
            // 2 sources

            if ((var0 = var0.getNetworkInfo(0)) == null) break block10;
            if (var0.getState() != NetworkInfo.State.CONNECTED) break block10;
            v2 = var1_1;
            v3 = var1_1;
            v4 = v2;
            v2[0] = "2G/3G";
            v4[1] = var0.getSubtypeName();
            return v3;
        }
        return var1_1;
    }

    public static String getIPAddress(Context object) {
        Iterator<NetworkInterface> iterator;
        object = null;
        String string = null;
        try {
            iterator = Collections.list(NetworkInterface.getNetworkInterfaces()).iterator();
        }
        catch (SocketException socketException) {
            object = "SocketException";
        }
        block15: while (true) {
            if (!iterator.hasNext()) break;
            NetworkInterface networkInterface = iterator.next();
            Iterator<InetAddress> iterator2 = Collections.list(networkInterface.getInetAddresses()).iterator();
            while (true) {
                InetAddress inetAddress;
                block20: {
                    if (!iterator2.hasNext()) continue block15;
                    inetAddress = iterator2.next();
                    if (inetAddress.isLoopbackAddress()) break block20;
                    if (!(inetAddress instanceof Inet4Address)) break block20;
                    if (networkInterface.getDisplayName().contains("dummy") || object != null) break block20;
                    object = inetAddress.getHostAddress();
                }
                if (inetAddress.isLoopbackAddress()) continue;
                if (!(inetAddress instanceof Inet6Address)) continue;
                if (networkInterface.getDisplayName().contains("dummy") || string != null) continue;
                string = inetAddress.getHostAddress();
                continue;
                break;
            }
            break;
        }
        if (object != null) {
            return object;
        }
        if (string == null) {
            string = "null";
        }
        return string;
    }

    public static int getNetworkType(Context context) {
        int n2;
        block4: {
            Context context2 = context;
            n2 = 0;
            TelephonyManager telephonyManager = (TelephonyManager)context2.getSystemService("phone");
            if (!DeviceConfig.checkPermission(context2, "android.permission.READ_PHONE_STATE")) break block4;
            try {
                n2 = telephonyManager.getNetworkType();
            }
            catch (Exception exception) {
                n2 = -100;
            }
        }
        return n2;
    }

    public static boolean isWiFiAvailable(Context context) {
        if (context == null) {
            return false;
        }
        return WIFI.equals(DeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static boolean isOnline(Context context) {
        block6: {
            if (context == null) {
                return false;
            }
            try {
                if (!DeviceConfigEx.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) break block6;
            }
            catch (Throwable throwable) {}
            context = (ConnectivityManager)context.getSystemService("connectivity");
            if (context == null) break block6;
            context = context.getActiveNetworkInfo();
            if (context == null) break block6;
            return context.isConnectedOrConnecting();
        }
        return false;
    }

    public static int getTimeZone(Context object) {
        block5: {
            if (object == null) {
                return 8;
            }
            if (FieldManagerEx.allow("header_timezone")) {
                object = Calendar.getInstance(DeviceConfigEx.getLocale((Context)object));
                if (object == null) break block5;
                try {
                    return ((Calendar)object).getTimeZone().getRawOffset() / 3600000;
                }
                catch (Throwable throwable) {
                    MLog.i(LOG_TAG, "error in getTimeZone", throwable);
                }
            }
        }
        return 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isChineseAera(Context object) {
        if (object == null) {
            return false;
        }
        String string = UMEnvelopeBuild.imprintProperty((Context)object, "country", UNKNOW);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string.equals("cn");
        }
        if (DeviceConfigEx.getImsi((Context)object) == null) {
            if (TextUtils.isEmpty((CharSequence)(object = DeviceConfigEx.getLocaleInfo((Context)object)[0])) || !((String)object).equalsIgnoreCase("cn")) return false;
            return true;
        }
        int n2 = object.getResources().getConfiguration().mcc;
        if (n2 == 460 || n2 == 461) return true;
        if (n2 != 0 || TextUtils.isEmpty((CharSequence)(object = DeviceConfigEx.getLocaleInfo((Context)object)[0])) || !((String)object).equalsIgnoreCase("cn")) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getLocaleInfo(Context object) {
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Unknown";
        stringArray[1] = "Unknown";
        if (FieldManagerEx.allow("header_local_info")) {
            if (object == null) {
                return stringArray2;
            }
            try {
                object = DeviceConfigEx.getLocale((Context)object);
                if (object != null) {
                    stringArray2[0] = ((Locale)object).getCountry();
                    stringArray2[1] = ((Locale)object).getLanguage();
                }
                if (TextUtils.isEmpty((CharSequence)stringArray2[0])) {
                    stringArray2[0] = "Unknown";
                }
                if (TextUtils.isEmpty((CharSequence)stringArray2[1])) {
                    stringArray2[1] = "Unknown";
                }
                return stringArray2;
            }
            catch (Throwable throwable) {
                MLog.e(LOG_TAG, "error in getLocaleInfo", throwable);
            }
        }
        return stringArray2;
    }

    private static Locale getLocale(Context context) {
        Configuration configuration;
        Locale locale = null;
        if (context == null) {
            return Locale.getDefault();
        }
        Configuration configuration2 = configuration;
        try {
            Configuration configuration3 = configuration2;
            configuration3();
            configuration3.setToDefaults();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration2);
            locale = configuration.locale;
        }
        catch (Throwable throwable) {
            MLog.e(LOG_TAG, "fail to read user config locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMac(Context context) {
        String string = UNKNOW;
        if (FieldManagerEx.allow("header_mc") || FieldManagerEx.allow("header_tracking_mac")) {
            if (context == null) {
                return string;
            }
            int n2 = Build.VERSION.SDK_INT;
            if (n2 < 23) {
                string = DeviceConfigEx.getMacBySystemInterface(context);
            } else if (n2 == 23) {
                string = DeviceConfigEx.getMacByJavaAPI();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = AnalyticsConstants.CHECK_DEVICE ? DeviceConfigEx.getMacShell() : DeviceConfigEx.getMacBySystemInterface(context);
                }
            } else {
                string = DeviceConfigEx.getMacByJavaAPI();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = DeviceConfigEx.getMacBySystemInterface(context);
                }
            }
        }
        return string;
    }

    private static String getMacBySystemInterface(Context context) {
        block9: {
            block12: {
                block10: {
                    block11: {
                        if (context == null) {
                            return UNKNOW;
                        }
                        try {
                            if (!FieldManagerEx.allow("header_device_id_mac")) break block9;
                        }
                        catch (Throwable throwable) {
                            if (AnalyticsConstants.UM_DEBUG) {
                                MLog.w(LOG_TAG, "Could not get mac address." + throwable.toString());
                            }
                            return UNKNOW;
                        }
                        Context context2 = context;
                        Context context3 = context2;
                        context = (WifiManager)context2.getSystemService("wifi");
                        if (!DeviceConfigEx.checkPermission(context3, "android.permission.ACCESS_WIFI_STATE")) break block10;
                        if (context == null) break block11;
                        return context.getConnectionInfo().getMacAddress();
                    }
                    return UNKNOW;
                }
                if (!AnalyticsConstants.UM_DEBUG) break block12;
                MLog.w(LOG_TAG, "Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
            }
            return UNKNOW;
        }
        return UNKNOW;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getResolutionArray(Context context) {
        WindowManager windowManager;
        DisplayMetrics displayMetrics;
        block8: {
            DisplayMetrics displayMetrics2;
            if (context == null) {
                return null;
            }
            if (!FieldManagerEx.allow("header_resolution")) return null;
            Context context2 = context;
            displayMetrics = displayMetrics2;
            displayMetrics2 = new DisplayMetrics();
            windowManager = (WindowManager)context2.getSystemService("window");
            if (windowManager != null) break block8;
            return null;
        }
        try {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = -1;
            if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                DisplayMetrics displayMetrics3 = displayMetrics;
                n2 = DeviceConfigEx.reflectMetrics(displayMetrics3, "noncompatWidthPixels");
                n3 = DeviceConfigEx.reflectMetrics(displayMetrics3, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                DisplayMetrics displayMetrics4 = displayMetrics;
                n2 = displayMetrics4.widthPixels;
                n3 = displayMetrics4.heightPixels;
            }
            int[] nArray = new int[2];
            if (n2 > n3) {
                nArray[0] = n3;
                nArray[1] = n2;
                return nArray;
            }
            nArray[0] = n2;
            nArray[1] = n3;
            return nArray;
        }
        catch (Throwable throwable) {
            if (!AnalyticsConstants.UM_DEBUG) return null;
            MLog.e(LOG_TAG, "read resolution fail", throwable);
        }
        return null;
    }

    private static int reflectMetrics(Object object, String string) {
        Field field;
        try {
            field = DisplayMetrics.class.getDeclaredField(string);
        }
        catch (Throwable throwable) {
            return -1;
        }
        field.setAccessible(true);
        return field.getInt(object);
    }

    public static String getPackageName(Context context) {
        if (context == null) {
            return null;
        }
        return context.getPackageName();
    }

    public static String getAppSHA1Key(Context context) {
        ByteArrayInputStream byteArrayInputStream;
        int n2;
        PackageManager packageManager;
        String string = null;
        try {
            packageManager = context.getPackageManager();
            n2 = 64;
        }
        catch (Exception exception) {}
        byte[] byArray = packageManager.getPackageInfo((String)DeviceConfigEx.getPackageName((Context)context), (int)n2).signatures[0].toByteArray();
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        string = DeviceConfigEx.byte2HexFormatted(MessageDigest.getInstance("SHA1").digest(((X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(byteArrayInputStream2)).getEncoded()));
        return string;
    }

    public static String getAppHashKey(Context context) {
        block6: {
            int n2;
            PackageManager packageManager;
            try {
                packageManager = context.getPackageManager();
                n2 = 64;
            }
            catch (Throwable throwable) {}
            Signature signature = packageManager.getPackageInfo((String)DeviceConfigEx.getPackageName((Context)context), (int)n2).signatures;
            int n3 = 0;
            if (((Signature[])signature).length <= 0) break block6;
            signature = signature[n3];
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(signature.toByteArray());
            return Base64.encodeToString((byte[])messageDigest.digest(), (int)0).trim();
        }
        return null;
    }

    public static String getAppMD5Signature(Context context) {
        ByteArrayInputStream byteArrayInputStream;
        int n2;
        PackageManager packageManager;
        String string = null;
        if (context == null) {
            return string;
        }
        try {
            packageManager = context.getPackageManager();
            n2 = 64;
        }
        catch (Throwable throwable) {}
        byte[] byArray = packageManager.getPackageInfo((String)DeviceConfigEx.getPackageName((Context)context), (int)n2).signatures[0].toByteArray();
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        string = DeviceConfigEx.byte2HexFormatted(MessageDigest.getInstance("MD5").digest(((X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(byteArrayInputStream2)).getEncoded()));
        return string;
    }

    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder2.append(string.toUpperCase(Locale.getDefault()));
            if (i2 >= byArray.length - 1) continue;
            stringBuilder2.append(':');
        }
        return stringBuilder2.toString();
    }

    public static String getApplicationLable(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static String getAppName(Context context) {
        String string;
        block3: {
            string = null;
            if (context == null) {
                return string;
            }
            try {
                string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.loadLabel(context.getPackageManager()).toString();
            }
            catch (Throwable throwable) {
                if (!AnalyticsConstants.UM_DEBUG) break block3;
                MLog.i(LOG_TAG, throwable);
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static String getDeviceIdForGeneral(Context var0) {
        block59: {
            block60: {
                block58: {
                    var1_1 = "";
                    if (var0 == null) {
                        return var1_1;
                    }
                    if (Build.VERSION.SDK_INT >= 23) break block58;
                    var1_1 = DeviceConfigEx.getIMEI(var0);
                    if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
                    if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl14
                    MLog.w(DeviceConfigEx.LOG_TAG, new Object[]{"No IMEI."});
lbl14:
                    // 2 sources

                    var1_1 = DeviceConfigEx.getMacBySystemInterface(var0);
                    if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
                    if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl29
                    var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
                    if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl29
                    v0 = DeviceConfigEx.LOG_TAG;
                    v1 = new Object[1];
                    v1[0] = "getDeviceId, ANDROID_ID: " + var1_1;
                    MLog.i(v0, v1);
lbl29:
                    // 3 sources

                    ** if (!TextUtils.isEmpty((CharSequence)var1_1)) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        v2 = DeviceConfigEx.getSerialNo();
lbl32:
                        // 3 sources

                        while (true) {
                            var1_1 = v2;
                            ** GOTO lbl142
                            break;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block59;
                    }
                }
                if (Build.VERSION.SDK_INT != 23) ** GOTO lbl83
                var1_1 = DeviceConfigEx.getIMEI(var0);
                if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
                var1_1 = DeviceConfigEx.getMacByJavaAPI();
                if (!TextUtils.isEmpty((CharSequence)var1_1)) ** GOTO lbl58
                if (!AnalyticsConstants.CHECK_DEVICE) break block60;
                v3 = DeviceConfigEx.getMacShell();
lbl51:
                // 2 sources

                while (true) {
                    var1_1 = v3;
                    ** GOTO lbl58
                    break;
                }
            }
            v3 = DeviceConfigEx.getMacBySystemInterface(var0);
            ** continue;
lbl58:
            // 2 sources

            if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl66
            try {
                v4 = DeviceConfigEx.LOG_TAG;
                v5 = new Object[1];
            }
            catch (Throwable v6) {}
            v5[0] = "getDeviceId, MAC: " + var1_1;
            MLog.i(v4, v5);
lbl66:
            // 2 sources

            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl79
            var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
            if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl79
            v7 = DeviceConfigEx.LOG_TAG;
            v8 = new Object[1];
            v8[0] = "getDeviceId, ANDROID_ID: " + var1_1;
            MLog.i(v7, v8);
lbl79:
            // 3 sources

            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            v2 = DeviceConfigEx.getSerialNo();
            ** GOTO lbl32
lbl83:
            // 1 sources

            if (Build.VERSION.SDK_INT < 29) ** GOTO lbl107
            var1_1 = DeviceConfigEx.getOaid(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getIdfa(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getAndroidId(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getSerialNo();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getMacByJavaAPI();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            v2 = DeviceConfigEx.getMacBySystemInterface(var0);
            ** continue;
lbl107:
            // 1 sources

            var1_1 = DeviceConfigEx.getIMEI(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getSerialNo();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl126
            var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
            if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl126
            v9 = DeviceConfigEx.LOG_TAG;
            v10 = new Object[1];
            v10[0] = "getDeviceId, ANDROID_ID: " + var1_1;
            MLog.i(v9, v10);
lbl126:
            // 3 sources

            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getMacByJavaAPI();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block59;
            var1_1 = DeviceConfigEx.getMacBySystemInterface(var0);
            if (!AnalyticsConstants.UM_DEBUG) break block59;
            v11 = DeviceConfigEx.LOG_TAG;
            v12 = new Object[1];
            v12[0] = "getDeviceId, MAC: " + var1_1;
            MLog.i(v11, v12);
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public static String getDeviceIdForBox(Context var0) {
        block62: {
            block63: {
                block61: {
                    var1_1 = "";
                    if (var0 == null) {
                        return var1_1;
                    }
                    if (Build.VERSION.SDK_INT >= 23) break block61;
                    if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl18
                    var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
                    if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl18
                    v0 = DeviceConfigEx.LOG_TAG;
                    v1 = new Object[1];
                    v1[0] = "getDeviceId, ANDROID_ID: " + var1_1;
                    MLog.i(v0, v1);
lbl18:
                    // 3 sources

                    if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
                    var1_1 = DeviceConfigEx.getMacBySystemInterface(var0);
                    if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl29
                    v2 = DeviceConfigEx.LOG_TAG;
                    v3 = new Object[1];
                    v3[0] = "getDeviceId, MAC: " + var1_1;
                    MLog.i(v2, v3);
lbl29:
                    // 2 sources

                    ** if (!TextUtils.isEmpty((CharSequence)var1_1)) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        var1_1 = DeviceConfigEx.getSerialNo();
                        ** if (!TextUtils.isEmpty((CharSequence)var1_1)) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            v4 = DeviceConfigEx.getIMEI(var0);
lbl36:
                            // 3 sources

                            while (true) {
                                var1_1 = v4;
                                ** GOTO lbl149
                                break;
                            }
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block62;
                    }
                }
                if (Build.VERSION.SDK_INT != 23) ** GOTO lbl87
                if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl55
                var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
                if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl55
                v5 = DeviceConfigEx.LOG_TAG;
                v6 = new Object[1];
                v6[0] = "getDeviceId, ANDROID_ID: " + var1_1;
                MLog.i(v5, v6);
lbl55:
                // 3 sources

                if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
                var1_1 = DeviceConfigEx.getMacByJavaAPI();
                if (!TextUtils.isEmpty((CharSequence)var1_1)) ** GOTO lbl71
                if (!AnalyticsConstants.CHECK_DEVICE) break block63;
                v7 = DeviceConfigEx.getMacShell();
lbl64:
                // 2 sources

                while (true) {
                    var1_1 = v7;
                    ** GOTO lbl71
                    break;
                }
            }
            v7 = DeviceConfigEx.getMacBySystemInterface(var0);
            ** continue;
lbl71:
            // 2 sources

            if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl79
            try {
                v8 = DeviceConfigEx.LOG_TAG;
                v9 = new Object[1];
            }
            catch (Throwable v10) {}
            v9[0] = "getDeviceId, MAC: " + var1_1;
            MLog.i(v8, v9);
lbl79:
            // 2 sources

            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getSerialNo();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            v4 = DeviceConfigEx.getIMEI(var0);
            ** GOTO lbl36
lbl87:
            // 1 sources

            if (Build.VERSION.SDK_INT < 29) ** GOTO lbl114
            var1_1 = DeviceConfigEx.getOaid(var0);
            Log.e((String)"test_oaid", (String)("+++++++" + var1_1));
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getIdfa(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getAndroidId(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getSerialNo();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getMacByJavaAPI();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            v4 = DeviceConfigEx.getMacBySystemInterface(var0);
            ** continue;
lbl114:
            // 1 sources

            if (!FieldManagerEx.allow("header_device_id_android_id")) ** GOTO lbl125
            var1_1 = Settings.Secure.getString((ContentResolver)var0.getContentResolver(), (String)"android_id");
            if (!AnalyticsConstants.UM_DEBUG) ** GOTO lbl125
            v11 = DeviceConfigEx.LOG_TAG;
            v12 = new Object[1];
            v12[0] = "getDeviceId: ANDROID_ID: " + var1_1;
            MLog.i(v11, v12);
lbl125:
            // 3 sources

            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getSerialNo();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getIMEI(var0);
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getMacByJavaAPI();
            if (!TextUtils.isEmpty((CharSequence)var1_1)) break block62;
            var1_1 = DeviceConfigEx.getMacBySystemInterface(var0);
            if (!AnalyticsConstants.UM_DEBUG) break block62;
            v13 = DeviceConfigEx.LOG_TAG;
            v14 = new Object[1];
            v14[0] = "getDeviceId, MAC: " + var1_1;
            MLog.i(v13, v14);
        }
        return var1_1;
    }

    private static String getOaid(Context object) {
        block3: {
            SharedPreferences sharedPreferences;
            Context context = object;
            object = UNKNOW;
            try {
                sharedPreferences = context.getSharedPreferences("umeng_sp_oaid", 0);
                if (sharedPreferences == null) break block3;
            }
            catch (Throwable throwable) {}
            object = sharedPreferences.getString("key_umeng_sp_oaid", UNKNOW);
        }
        return object;
    }

    private static String getIdfa(Context context) {
        String string;
        block3: {
            string = UNKNOW;
            try {
                if (!FieldManagerEx.allow("header_tracking_idfa")) break block3;
            }
            catch (Throwable throwable) {}
            string = a.a(context);
        }
        return string;
    }

    private static String getIMEI(Context context) {
        String string;
        block9: {
            string = UNKNOW;
            if (FieldManagerEx.allow("header_device_id_imei")) {
                if (context == null) {
                    return string;
                }
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    if (!DeviceConfigEx.checkPermission(context, "android.permission.READ_PHONE_STATE")) break block9;
                    string = telephonyManager.getDeviceId();
                    if (!AnalyticsConstants.UM_DEBUG) break block9;
                    String string2 = LOG_TAG;
                    Object[] objectArray = new Object[1];
                    try {
                        objectArray[0] = "getDeviceId, IMEI: " + string;
                        MLog.i(string2, objectArray);
                    }
                    catch (Throwable throwable) {
                        if (!AnalyticsConstants.UM_DEBUG) break block9;
                        MLog.w(LOG_TAG, "No IMEI.", throwable);
                    }
                }
            }
        }
        return string;
    }

    private static String getSerialNo() {
        int n2;
        String string = UNKNOW;
        if (FieldManagerEx.allow("header_device_id_serialNo") && (n2 = Build.VERSION.SDK_INT) >= 9) {
            if (n2 >= 26) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("android.os.Build");
                }
                catch (Throwable throwable) {}
                string = (String)clazz.getMethod("getSerial", new Class[0]).invoke(clazz, new Object[0]);
            } else {
                string = Build.SERIAL;
            }
        }
        if (AnalyticsConstants.UM_DEBUG) {
            MLog.i(LOG_TAG, "getDeviceId, serial no: " + string);
        }
        return string;
    }

    public static String getSubOSName(Context object) {
        Object object2;
        block10: {
            block11: {
                block7: {
                    block9: {
                        block8: {
                            object = null;
                            if (!FieldManagerEx.allow("header_sub_os_name")) break block11;
                            object = DeviceConfigEx.getBuildProp();
                            object2 = object.getProperty(KEY_MIUI_VERSION_NAME);
                            if (!TextUtils.isEmpty((CharSequence)object2)) break block7;
                            if (!DeviceConfigEx.isFlyMe()) break block8;
                            object2 = "Flyme";
                        }
                        if (!DeviceConfigEx.isEmui((Properties)object)) break block9;
                        object2 = "Emui";
                        break block10;
                    }
                    try {
                        if (!TextUtils.isEmpty((CharSequence)DeviceConfigEx.getYunOSVersion((Properties)object))) {
                            object2 = "YunOS";
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        object2 = null;
                    }
                }
                object2 = "MIUI";
                break block10;
                break block10;
            }
            object2 = object;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSubOSVersion(Context object) {
        String string;
        block9: {
            block8: {
                object = null;
                if (!FieldManagerEx.allow("header_sub_os_version")) {
                    return object;
                }
                object = DeviceConfigEx.getBuildProp();
                Object object2 = object.getProperty(KEY_MIUI_VERSION_NAME);
                if (!TextUtils.isEmpty((CharSequence)object2)) return object2;
                if (!DeviceConfigEx.isFlyMe()) break block8;
                try {
                    string = DeviceConfigEx.getFlymeVersion((Properties)object);
                    return string;
                }
                catch (Throwable throwable) {
                    return object2;
                }
            }
            try {
                if (!DeviceConfigEx.isEmui((Properties)object)) break block9;
            }
            catch (Throwable throwable) {
                return null;
            }
            string = DeviceConfigEx.getEmuiVersion((Properties)object);
            return string;
        }
        string = DeviceConfigEx.getYunOSVersion((Properties)object);
        return string;
    }

    private static String getYunOSVersion(Properties object) {
        if (!TextUtils.isEmpty((CharSequence)(object = ((Properties)object).getProperty("ro.yunos.version")))) {
            return object;
        }
        return null;
    }

    private static String getFlymeVersion(Properties object) {
        block4: {
            try {
                object = ((Properties)object).getProperty("ro.build.display.id").toLowerCase(Locale.getDefault());
            }
            catch (Throwable throwable) {}
            if (!((String)object).contains("flyme os")) break block4;
            return ((String)object).split(" ")[2];
        }
        return null;
    }

    private static String getEmuiVersion(Properties object) {
        Properties properties = object;
        object = null;
        try {
            object = properties.getProperty(KEY_EMUI_VERSION_CODE, null);
        }
        catch (Exception exception) {}
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getBuildProp() {
        FileInputStream fileInputStream;
        Properties properties;
        block8: {
            FileInputStream fileInputStream2;
            block9: {
                Properties properties2;
                properties = properties2;
                properties2 = new Properties();
                Object var1_1 = null;
                fileInputStream = fileInputStream2;
                Properties properties3 = properties;
                FileInputStream fileInputStream3 = fileInputStream;
                FileInputStream fileInputStream4 = fileInputStream3;
                fileInputStream3(new File(Environment.getRootDirectory(), "build.prop"));
                try {
                    properties3.load(fileInputStream4);
                }
                catch (Throwable throwable) {
                    break block8;
                }
                try {}
                catch (Throwable throwable) {
                    return properties;
                }
                break block9;
                catch (Throwable throwable) {
                    fileInputStream = var1_1;
                }
                break block8;
            }
            fileInputStream2.close();
            return properties;
        }
        if (fileInputStream == null) return properties;
        {
            fileInputStream.close();
        }
        return properties;
    }

    private static boolean isFlyMe() {
        Class<Build> clazz;
        try {
            clazz = Build.class;
        }
        catch (Throwable throwable) {
            return false;
        }
        clazz.getMethod("hasSmartBar", new Class[0]);
        return true;
    }

    private static boolean isEmui(Properties properties) {
        try {
            return properties.getProperty(KEY_EMUI_VERSION_CODE, null) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getDeviceType(Context object) {
        block5: {
            String string;
            block4: {
                block3: {
                    string = "Phone";
                    if (!FieldManagerEx.allow("header_device_type")) break block4;
                    if (object == null) {
                        return string;
                    }
                    try {
                        if (!((object.getResources().getConfiguration().screenLayout & 0xF) >= 3)) break block3;
                    }
                    catch (Throwable throwable) {}
                    object = "Tablet";
                    break block5;
                }
                object = "Phone";
                break block5;
            }
            object = string;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDBencryptID(Context object) {
        String string;
        block7: {
            String string2 = null;
            if (object == null) return string2;
            try {
                TelephonyManager telephonyManager = (TelephonyManager)object.getSystemService("phone");
                if (telephonyManager != null && DeviceConfigEx.checkPermission(object, "android.permission.READ_PHONE_STATE")) {
                    string2 = telephonyManager.getDeviceId();
                }
                if (!TextUtils.isEmpty(string2)) return string2;
                string2 = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"android_id");
                if (!TextUtils.isEmpty((CharSequence)string2)) return string2;
                if (Build.VERSION.SDK_INT < 9) return string2;
                if (Build.VERSION.SDK_INT < 26) break block7;
                object = Class.forName("android.os.Build");
            }
            catch (Throwable throwable) {
                return string2;
            }
            string = (String)object.getMethod("getSerial", new Class[0]).invoke(object, new Object[0]);
            return string;
        }
        string = Build.SERIAL;
        return string;
    }
}

