package com.yodo1.sdk.kit.cache;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * CacheUtils
 * <p>
 * Created by KasoGG on 2017/2/17.
 */
class CacheUtils {
    private static final String TAG = CacheUtils.class.getSimpleName();

    static String hashKey(String key) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(key.getBytes("UTF-8"));
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(16);
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            return String.valueOf(key.hashCode());
        }
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException e) {
                Log.e(TAG, "", e);
            }
        }
    }

    static boolean isExpired(Yodo1Cache.CacheEntity cacheEntity) {
        return cacheEntity != null && cacheEntity.expiration != 0 && System.currentTimeMillis() > cacheEntity.expiration;
    }

    static int calculateEntitySize(Yodo1Cache.CacheEntity entity) {
        if (entity == null) {
            return 1;
        }
        return entity.bytes != null ? entity.bytes.length + 8 : 8;
    }

    static byte[] bitmapToBytes(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
        byte[] bytes = baos.toByteArray();
        closeQuietly(baos);
        return bytes;
    }

    static Bitmap bytesToBitmap(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
    }

    static byte[] objectToBytes(Object obj) {
        byte[] bytes = null;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            bytes = baos.toByteArray();
        } catch (Exception e) {
            Log.e(TAG, "", e);
        } finally {
            closeQuietly(oos);
        }
        return bytes;
    }

    static Object bytesToObject(byte[] bytes) {
        Object obj = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            obj = ois.readObject();
        } catch (Exception e) {
            Log.e(TAG, "", e);
        } finally {
            closeQuietly(ois);
        }
        return obj;
    }

}