package com.yodo1.sdk.kit;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Looper;
import android.util.Log;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author yodo1
 */
public class Yodo1SharedPreferences {
    private static final String TAG = "Yodo1SharedPreferences";
    private final static String FILE_NAME = "sp_yodo1games";
    private static Editor edt;
    private static SharedPreferences sharedPreferences;
    /**
     * 线程池，切换子线程使用
     */
    private static ExecutorService executorService = Executors.newCachedThreadPool();

    /**
     * 初始化操作，创建sharedPreferences edt对象，仅此一次
     * 注意：初始化必须在程序最开始的部分立刻执行，避免提前调用put get方法导致异常
     */
    public static void init(Context context) {
        if (sharedPreferences != null && edt != null) {
            return;
        }
        Log.i(TAG, "初始化 " + System.currentTimeMillis());
        sharedPreferences = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        edt = sharedPreferences.edit();
        edt.apply();
    }

    /**
     * TODO 开发测试完成，删除调试日志
     * 批量储存数据，多次put，一次apply
     * 只接受string类型的key和value，储存时注意转换成string类型，取值时自行解析数据
     */
    public static void put(Context context, final HashMap<String, String> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        init(context);
        Log.i(TAG, System.currentTimeMillis() + " put操作开始");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    for (String key : data.keySet()) {
                        edt.putString(key, data.get(key));
                    }
                    edt.apply();
                    Log.d(TAG, System.currentTimeMillis() + " 主线程进来的 子线程内执行apply结束 ");
                }
            });
        } else {
            for (String key : data.keySet()) {
                edt.putString(key, data.get(key));
            }
            edt.apply();
            Log.d(TAG, System.currentTimeMillis() + " 子线程进来的 apply执行结束");
        }
        Log.i(TAG, System.currentTimeMillis() + " put操作结束");
    }

    /**
     * TODO 开发测试完成，删除调试日志
     * 批量储存数据，多次put，一次apply
     * 只接受string类型的key和value，储存时注意转换成string类型，取值时自行解析数据
     */
    public static void put(Context context, final HashMap<String, String> data, final Yodo1SharedPreferencesCallback callback) {
        if (data == null || data.size() == 0) {
            return;
        }
        init(context);
        Log.i(TAG, System.currentTimeMillis() + " put操作开始");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    for (String key : data.keySet()) {
                        edt.putString(key, data.get(key));
                    }
                    edt.apply();
                    /**
                     * 主线程进来的，内部开子线程储存数据的，会比直接子线程慢一点，所以需要对外回调储存完成，以便获取数据时能获取到有效值
                     */
                    if (callback != null) {
                        callback.ready();
                    }
                    Log.d(TAG, System.currentTimeMillis() + " 主线程进来的 子线程内执行apply结束 ");
                }
            });
        } else {
            for (String key : data.keySet()) {
                edt.putString(key, data.get(key));
            }
            edt.apply();
            /**
             * 子线程进来的储存数据会实时获取到 不需要对外回调数据储存已完成
             */
            Log.d(TAG, System.currentTimeMillis() + " 子线程进来的 apply执行结束");
        }
        Log.i(TAG, System.currentTimeMillis() + " put操作结束");
    }

    /**
     * TODO 开发测试完成，删除调试日志
     * 单个储存数据，不检测key和values，自行注意
     */
    public static void put(Context context, final String key, final String value) {
        Log.i(TAG, System.currentTimeMillis() + " put操作开始,key = " + key + ",values = " + value);
        init(context);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    edt.putString(key, value);
                    edt.apply();
                    Log.d(TAG, System.currentTimeMillis() + " 主线程进来的 子线程内执行apply结束 ");
                }
            });
        } else {
            edt.putString(key, value);
            edt.apply();
            Log.d(TAG, System.currentTimeMillis() + " 子线程进来的 apply执行结束");
        }
        Log.i(TAG, System.currentTimeMillis() + " put操作结束，获取刚刚储存的值" + getString(context, key));
    }

    /**
     * TODO 开发测试完成，删除调试日志
     * 单个储存数据，不检测key和values，自行注意
     */
    public static void put(Context context, final String key, final String value, final Yodo1SharedPreferencesCallback callback) {
        Log.i(TAG, System.currentTimeMillis() + " put操作开始,key = " + key + ",values = " + value);
        init(context);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    edt.putString(key, value);
                    edt.apply();
                    /**
                     * 主线程进来的，内部开子线程储存数据的，会比直接子线程慢一点，所以需要对外回调储存完成，以便获取数据时能获取到有效值
                     */
                    if (callback != null) {
                        callback.ready();
                    }
                    Log.d(TAG, System.currentTimeMillis() + " 主线程进来的 子线程内执行apply结束 ");
                }
            });
        } else {
            edt.putString(key, value);
            edt.apply();
            /**
             * 子线程进来的储存数据会实时获取到 不需要对外回调数据储存已完成
             */
            Log.d(TAG, System.currentTimeMillis() + " 子线程进来的 apply执行结束");
        }
        Log.i(TAG, System.currentTimeMillis() + " put操作结束，获取刚刚储存的值" + getString(context, key));
    }

    public static void put(Context context, String key, boolean value) {
        init(context);
        edt.putBoolean(key, value);
        edt.apply();

    }

    public static void put(Context context, String key, int value) {
        init(context);
        edt.putInt(key, value);
        edt.apply();
    }

    public static void put(Context context, String key, float value) {
        init(context);
        edt.putFloat(key, value);
        edt.apply();
    }

    public static void put(Context context, String key, long value) {
        init(context);
        edt.putLong(key, value);
        edt.apply();
    }

    public static String getString(Context context, String key) {
        init(context);
        return sharedPreferences.getString(key, null);
    }

    public static int getInt(Context context, String key) {
        init(context);
        return sharedPreferences.getInt(key, 0);
    }

    public static boolean getBoolean(Context context, String key) {
        init(context);
        return sharedPreferences.getBoolean(key, false);
    }

    public static float getFloat(Context context, String key) {
        init(context);
        return sharedPreferences.getFloat(key, 0);
    }

    public static long getLong(Context context, String key) {
        init(context);
        return sharedPreferences.getLong(key, 0);
    }

    public interface Yodo1SharedPreferencesCallback {
        /**
         * 储存操作是否已完成回调
         */
        void ready();
    }

}
