package com.yodo1.sdk.kit;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Base64;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author yodo1
 */
public class Yodo1CommonUtils {

    /**
     * 从Mainfest中获取mata-data值。。其他value类型转化到string.(不可getString.)
     */
    public static String getMetedataStr(Context context, String key) {
        ApplicationInfo appInfo;
        if (context != null && !TextUtils.isEmpty(key)) {
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                return appInfo.metaData.get(key).toString();
            } catch (Exception e) {
                YLog.d("Get meta-data failed, " + key, e);
            }
        }
        return "";
    }

    /**
     * 从Mainfest中获取mata-data值。。类型敏感，不对的类型返回默认值。
     */
    public static <T> T getMetedataStr(Context context, String key, T defaultValue) {
        ApplicationInfo appInfo;
        if (context != null && !TextUtils.isEmpty(key)) {
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Object value = appInfo.metaData.get(key);
                if (value == null) {
                    return defaultValue;
                } else {
                    return (T) value;
                }
            } catch (Exception e) {
                YLog.d("Get meta-data failed, " + key, e);
            }
        }
        return defaultValue;
    }


    /**
     * 手机号验证
     *
     * @param str str
     * @return is mobile number
     */
    public static boolean isMobile(final String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        Pattern p;
        Matcher m;
        boolean b;
        // 验证手机号
        p = Pattern.compile("^[1,9][2,3,4,5,6,7,8,9][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }


    /**
     * 2  * 获取版本号
     * 3  * @return 当前应用的版本号
     * 4
     *
     * @param str str
     * @return a
     */
    public static Long getLongValues(String str) {
        Long value = 0L;
        if (TextUtils.isEmpty(str)) {
            return value;
        }
        try {
            value = Long.valueOf(str);
        } catch (NumberFormatException e) {
            value = 0L;
            YLog.d("数据转换出现异常 NumberFormatException  异常内容： " + str);
        }

        return value;
    }


    /**
     * 获取UTC时间戳,getInstance()
     *
     * @return UTC time
     */
    public static long getUTCTime() {
        return System.currentTimeMillis();
    }

    public static byte[] gzipCompress(String data) throws IOException {
        if ((data == null) || (data.length() == 0)) {
            return new byte[0];
        }
        ByteArrayOutputStream baostream = null;
        GZIPOutputStream outStream = null;
        try {
            baostream = new ByteArrayOutputStream();
            outStream = new GZIPOutputStream(baostream) {
            };
            outStream.write(data.getBytes(StandardCharsets.UTF_8));
            outStream.close();

            return baostream.toByteArray();
        } finally {
            try {
                if (baostream != null) {
                    baostream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    public static String hmacWithKey(String key, byte[] data) {
        String result = "";
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256HMAC.init(secret_key);

            result = Base64.encodeToString(sha256HMAC.doFinal(data), 0);
            YLog.d("hmacWithKey result==" + result);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        }

        return result;
    }
}
