package com.yodo1.plugin.dmp.yodo1.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhuxc on 2018/10/16.
 */

public class Yodo1UtilDao {
    private Yodo1DBUtil du;
    private SQLiteDatabase db;

    private String tableName = "Yodo1AnalyticsDB";

    public Yodo1UtilDao(Context context) {
        du = new Yodo1DBUtil(context, tableName);
        db = du.getWritableDatabase();
    }

    // 获取行数
    public long getLines() {
        Cursor cursor = db.rawQuery("select count(*) from " + tableName, null);
        cursor.moveToFirst();
        long count = cursor.getLong(0);
        cursor.close();
        return count;
    }

    public void add(AnalyticsInfo info) {
        try {
            db.execSQL("insert into " + tableName + " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                    new Object[]{info.getSessionId(), info.getTimestamp(),
                            info.getEventId(), info.getEventData(), info.getChannel(),
                            info.getClientVersion(), info.getEventType(), info.getNetwork(),
                            info.getDeviceId(), info.getTerminal(), info.getBundleId(),
                            info.getDeviceName(), info.getPhoneVersion(), info.getOsVersion(),
                            info.getOs(), info.getGaid(), info.getImei(), info.getAndroidId()
                    });
        } catch (Exception e) {
        }
    }

    public void update(AnalyticsInfo info) {
        try {
            db.execSQL("update " + tableName + " set sessionid=?,timestamp=?,eventid=?,event_data=?," +
                            "channel=?,client_version=?,event_type=?,network=?,device_id=?," +
                            "terminal=?,bundle_id=?,device_name=?,phone_version=?,os_version=?,os=?," +
                            "android_gaid=?,android_imei=?,android_id=? where _id=?",
                    new Object[]{info.getSessionId(), info.getTimestamp(),
                            info.getEventId(), info.getEventData(), info.getChannel(),
                            info.getClientVersion(), info.getEventType(), info.getNetwork(),
                            info.getDeviceId(), info.getTerminal(), info.getBundleId(),
                            info.getDeviceName(), info.getPhoneVersion(), info.getOsVersion(),
                            info.getOs(), info.getGaid(), info.getImei(), info.getAndroidId()
                    });
        } catch (Exception e) {
        }
    }

    public void delete(String name) {
        try {
            db.execSQL("delete from " + tableName + "  where name=?", new String[]{name});
        } catch (Exception e) {
        }
    }

    public void deleteALL() {
        try {
            db.execSQL("delete from " + tableName);
        } catch (Exception e) {
        }
    }

    // 查询单条
    public AnalyticsInfo queryOne(String name) {
        AnalyticsInfo info = new AnalyticsInfo();
        try {
            Cursor c = db.rawQuery("select * from " + tableName + " where name= ?", new String[]{name});
            while (c.moveToNext()) {
                info.setSessionId(c.getString(0));
                info.setTimestamp(c.getString(1));
                info.setEventId(c.getString(2));
                info.setEventData(c.getString(3));
                info.setChannel(c.getString(4));
                info.setClientVersion(c.getString(5));
                info.setEventType(c.getString(6));
                info.setNetwork(c.getString(7));
                info.setDeviceId(c.getString(8));
                info.setTerminal(c.getString(9));
                info.setBundleId(c.getString(10));
                info.setDeviceName(c.getString(11));
                info.setPhoneVersion(c.getString(12));
                info.setOsVersion(c.getString(13));
                info.setOs(c.getString(14));
                info.setGaid(c.getString(15));
                info.setImei(c.getString(16));
                info.setAndroidId(c.getString(17));
            }
            c.close();
        } catch (Exception e) {
        }


        return info;
    }

    /**
     * 查询全部
     *
     * @return
     */
    public List<AnalyticsInfo> queryAllAnalyticsInfo() {
        ArrayList<AnalyticsInfo> infos = new ArrayList<AnalyticsInfo>();
        try {
            Cursor c = db.rawQuery("select * from " + tableName, null);
            while (c.moveToNext()) {
                AnalyticsInfo info = new AnalyticsInfo();
                info.setSessionId(c.getString(0));
                info.setTimestamp(c.getString(1));
                info.setEventId(c.getString(2));
                info.setEventData(c.getString(3));
                info.setChannel(c.getString(4));
                info.setClientVersion(c.getString(5));
                info.setEventType(c.getString(6));
                info.setNetwork(c.getString(7));
                info.setDeviceId(c.getString(8));
                info.setTerminal(c.getString(9));
                info.setBundleId(c.getString(10));
                info.setDeviceName(c.getString(11));
                info.setPhoneVersion(c.getString(12));
                info.setOsVersion(c.getString(13));
                info.setOs(c.getString(14));
                info.setGaid(c.getString(15));
                info.setImei(c.getString(16));
                info.setAndroidId(c.getString(17));

                infos.add(info);
            }
            c.close();
        } catch (Exception e) {
        }
        return infos;
    }

    /**
     * 关闭数据库连接
     */
    public void getClose() {
        if (db != null) {
            db.close();
        }
    }
}