package com.yodo1.onlineconfig;

import android.content.Context;

import com.yodo1.sdk.kit.YLog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * jsonUtils
 *
 * @author yodo1
 */
public class JsonCacheUtils {

    /**
     * 从给定位置读取Json文件
     *
     * @param context  Context
     * @param fileName fileName
     * @return Json String
     */
    public static String readJson(Context context, String fileName) {
        //从给定位置获取文件
        File file = new File(context.getCacheDir(), fileName + ".json");
        BufferedReader reader = null;
        //返回值,使用StringBuffer
        StringBuffer data = new StringBuffer();
        //
        try {
            reader = new BufferedReader(new FileReader(file));
            //每次读取文件的缓存
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                data.append(temp);
            }
        } catch (Exception e) {
            YLog.d("Exception readJson:" + e.getMessage());
        } finally {
            //关闭文件流
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data.toString();
    }

    /**
     * 给定路径与Json文件，存储到硬盘
     *
     * @param context  Context
     * @param json     json
     * @param fileName fileName
     */
    public static void writeJson(Context context, Object json, String fileName) {
        BufferedWriter writer = null;

        //从给定位置获取文件
        File file = new File(context.getCacheDir(), fileName + ".json");

        //如果文件不存在，则新建一个
        if (!file.exists()) {
            try {
                file.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //写入
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(json.toString());
        } catch (IOException e) {
            YLog.d("Exception writeJson:" + e.getMessage());
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
