package com.yodo1.advert.utils;

import android.content.Context;
import android.text.TextUtils;

import com.yodo1.advert.onlineconfig.AdPlacementEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.util.List;
import java.util.Locale;

/**
 * 在线参数获取工具
 *
 * @author yodo1
 */
public class YOnlineConfigUtils {
    private static final String TAG = "[YOnlineConfigUtils] ";

    /**
     * 中文条件下广告开关
     */
    private static final String KEY_PLATFORM_AD_SWITCH_IN_CHINESE = "Platform_AdSwitchInChinese";
    /**
     * 是否需要请求权限
     */
    private static final String KEY_PLATFORM_REQUEST_PERMISSION = "Platform_RequestPermisson";
    /**
     * 广告错误日志上报
     */
    private static final String KEY_PLATFORM_AD_SWITCH_IN_ERROR_UPDATE = "Platform_Feedback_SwitchAd";

    /**
     * 获取广告开关是否打开
     *
     * @return on/off
     */
    public static boolean isTrunOnYodo1Ads(Yodo1OnlineConfigAgent.AdvertType advertType) {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(advertType);
        return !TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()));
    }

    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getIntervalAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getIntervalConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e(TAG + "获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 0;
    }

    /**
     * 获取原生广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getNativeAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getIntervalConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e(TAG + "获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 0;
    }

    /**
     * 获取Banner广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getSwitchingCycle() {
        String value = Yodo1OnlineConfigAgent.getSwitchingCycleConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e(TAG + "获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 30 * 1000;
    }

    /**
     * 获取中文环境下广告开关   如果该开关打开，表示只有在中文环境下才初始化
     *
     * @return on/off
     */
    public static boolean isTrunOnAdForChina(Context activity) {
        String value = Yodo1OnlineConfig.getInstance().getConfigParam(KEY_PLATFORM_AD_SWITCH_IN_CHINESE, "off");
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return !"CN".equals(activity.getResources().getConfiguration().locale.getCountry());
        }
        return false;
    }

    /**
     * 是否请求权限
     *
     * @return on/off
     */
    public static boolean isNeedRequestPermission() {
        String value = Yodo1OnlineConfig.getInstance().getConfigParam(KEY_PLATFORM_REQUEST_PERMISSION, "off");
        YLog.d(TAG + "权限请求开关: " + value);
        return !TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()));
    }

    /**
     * 是否请求权限
     *
     * @return on/off
     */
    public static boolean isTrunOnErrorUpdataSwitch() {
        String value = Yodo1OnlineConfig.getInstance().getConfigParam(KEY_PLATFORM_AD_SWITCH_IN_ERROR_UPDATE, "off");
        YLog.d(TAG + "错误信息收集: " + value);
        return !TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()));
    }

    /**
     * 判断测试模式
     *
     * @return on/off
     */
    public static boolean isTestModule(Context context) {
        return Yodo1SharedPreferences.getBoolean(context, "OnlineConfigParams_TestDevice");
    }

    public static String testDeviceSource(Context context) {
        return Yodo1SharedPreferences.getString(context, "OnlineConfigParams_TestDeviceSource");
    }

    public static String getAppKey(Context context) {
        return Yodo1SharedPreferences.getString(context, "game_appkey");
    }

    public static boolean isEmptyTestAdList() {
        return Yodo1OnlineConfigAgent.getYodo1AdTestInfo(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd) == null
                && Yodo1OnlineConfigAgent.getYodo1AdTestInfo(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd) == null
                && Yodo1OnlineConfigAgent.getYodo1AdTestInfo(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd) == null
                && Yodo1OnlineConfigAgent.getYodo1AdTestInfo(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd) == null
                && Yodo1OnlineConfigAgent.getYodo1AdTestInfo(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd) == null;
    }

    /**
     * @param advertType  Yodo1OnlineConfigAgent.AdvertType
     * @param placementId Placement Id
     * @return true, if the placement is available, false otherwise.
     */
    public static boolean isValidityPlacement(Yodo1OnlineConfigAgent.AdvertType advertType, String placementId) {
        List<AdPlacementEntity> placements = Yodo1OnlineConfigAgent.getPlacements(advertType);
        for (int i = 0; i < placements.size(); i++) {
            AdPlacementEntity placementEntity = placements.get(i);
            if (!placementEntity.getCode().equals(placementId)) {
                continue;
            }
            if (placementEntity.isDisabled()) {
                YLog.v(TAG + "'" + placementId + "' placement has been disabled");
                return false;
            } else {
                YLog.v(TAG + "'" + placementId + "' placement is available");
                return true;
            }
        }
        if (placementId.equals("default")) {
            return true;
        }
        YLog.v(TAG + "'" + placementId + "' placement is invalid");
        return false;
    }
}
