package com.yodo1.advert.unity;

import android.annotation.SuppressLint;
import android.app.Activity;

import com.unity3d.player.UnityPlayer;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author yodo1
 */
public class UnityYodo1Advertising {
    private static final String TAG = "[UnityYodo1Advertising] ";

    @SuppressLint("StaticFieldLeak")
    private static Activity activity = null;
    private static UnityYodo1MessageListener listener = new UnityYodo1MessageListener() {
        @Override
        public void unitySendMessage(String go, String m, String p) {
            UnityPlayer.UnitySendMessage(go, m, p);
        }
    };

    /**
     * Initialize the SDK of unity end.
     *
     * @param activity   Activity
     * @param gameAppKey App key
     */
    public static void initSDK(final Activity activity, String gameAppKey) {
        UnityYodo1Advertising.activity = activity;
        Yodo1Advert.initSDK(activity, gameAppKey);
    }

    /**
     * Set debug log
     *
     * @param enable Debug's log switch
     */
    public static void setLogEnable(boolean enable) {
        Yodo1Advert.setOnLog(enable);
    }

    public static void setUserConsent(boolean consent) {
        Yodo1Advert.setUserConsent(consent);
    }

    public static void setTagForUnderAgeOfConsent(boolean underAgeOfConsent) {
        Yodo1Advert.setTagForUnderAgeOfConsent(underAgeOfConsent);
    }

    public static void setDoNotSell(boolean doNotSell) {
        Yodo1Advert.setDoNotSell(doNotSell);
    }

    public static void unitySendMessage(String go, String m, String p) {
        YLog.d(TAG + "GameObject's name is " + go + ", Method's name is " + m);
        YLog.i(TAG + "Android message will send to unity, " + p);

        if (listener != null) {
            listener.unitySendMessage(go, m, p);
        }
    }

    /**
     * Show rewarded video ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     */
    public static void showVideo(final String gameObject, final String callbackName) {
        showVideo(gameObject, callbackName, "default");
    }

    /**
     * Show rewarded video ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     */
    public static void showVideo(final String gameObject, final String callbackName, final String placementId) {
        YLog.d(TAG + "Unity calls the android showVideo method ...");
        if (activity == null) {
            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showVideo(activity, placementId, new VideoCallback() {
                    @Override
                    public void onVideoClosed(boolean isFinished) {
                        if (isFinished) {
                            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_FINISH, ""));
                        } else {
                            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                        }
                    }

                    @Override
                    public void onVideoShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onVideoShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onVideoClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @return true, if the reward video ads have been cached, false otherwise.
     */
    public static boolean videoIsReady() {
        YLog.d(TAG + "Unity calls the android videoIsReady method ...");
        if (activity == null) {
            return false;
        }
        return Yodo1Advert.videoIsReady(activity);
    }

    /**
     * Show interstitial Ad.
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     */
    public static void showInterstitial(final String gameObject, final String callbackName) {
        showInterstitial(gameObject, callbackName, "default");
    }

    /**
     * Show interstitial Ad.
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     * @param placementId  Placement Id
     */
    public static void showInterstitial(final String gameObject, final String callbackName, final String placementId) {
        YLog.d(TAG + "Unity calls the android showInterstitial method ...");
        if (activity == null) {
            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showInterstitial(activity, placementId, new InterstitialCallback() {

                    @Override
                    public void onInterstitialClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                    }

                    @Override
                    public void onInterstitialShowSucceeded() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onInterstitialShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onInterstitialClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * Whether the interstitial ads have been cached.
     *
     * @return true, if the interstitial ads have been cached, false otherwise.
     */
    public static boolean interstitialIsReady() {
        YLog.d(TAG + "Unity calls the android interstitialIsReady method ...");
        if (activity == null) {
            return false;
        }
        return Yodo1Advert.interstitialIsReady(activity);
    }

    /**
     * Show the native ad.
     *
     * @param gameObject   Unity prepab‘s name
     * @param px           The X coordinates for native ads
     * @param py           The Y coordinates for native ads
     * @param pw           The Width of native ads
     * @param ph           The height of native ads
     * @param callbackName Method name
     */
    public static void showNativeAd(final String gameObject, final float px, final float py, final float pw, final float ph, final String callbackName) {
        showNativeAd(gameObject, "default", px, py, pw, ph, callbackName);
    }

    /**
     * Show native ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param placementId  Placement id
     * @param px           广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py           广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw           广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph           广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     *                     如:showNativeAdvert(this,0.2f, 0.3f,0.6f, 0.3f);
     * @param callbackName Method name
     */
    public static void showNativeAd(final String gameObject, final String placementId, final float px, final float py, final float pw, final float ph, final String callbackName) {
        YLog.d(TAG + "Unity calls the android showNativeAd method ...");
        if (activity == null) {
            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1AdvertHelper.getInstance().showNativeAd(activity, placementId, px, py, pw, ph, new NativeCallback() {
                    @Override
                    public void onNativeClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onNativeShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onNativeShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onNativeClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * Remove native ad
     */
    public static void removeNativeAd() {
        YLog.d(TAG + "Unity calls the android removeNativeAd method ...");
        if (activity == null) {
            return;
        }
        Yodo1AdvertHelper.getInstance().removeNativeAd(activity);
    }

    /**
     * Whether the native ads have been cached.
     *
     * @return true, if the native ads have been cached, false otherwise.
     */
    public static boolean nativeIsReady() {
        if (activity == null) {
            return false;
        }
        return Yodo1AdvertHelper.getInstance().nativeAdIsLoaded(activity);
    }

    /**
     * Show banner ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     * @deprecated The method ShowBanner has been deprecated, please use the method {@link #showBanner} instead
     */
    @Deprecated
    public static void ShowBanner(final String gameObject, final String callbackName) {
        showBanner(gameObject, callbackName, "default");
    }

    /**
     * Show banner ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     */
    public static void showBanner(final String gameObject, final String callbackName) {
        showBanner(gameObject, callbackName, "default");
    }

    /**
     * Show banner ad
     *
     * @param gameObject   Unity prepab‘s name
     * @param callbackName Method name
     */
    public static void showBanner(final String gameObject, final String callbackName, final String placementId) {
        YLog.d(TAG + "Unity calls the android ShowBanner method ...");
        if (activity == null) {
            UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showBanner(activity, placementId, new BannerCallback() {

                    @Override
                    public void onBannerClosed() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onBannerShow() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onBannerShowFailed(AdErrorCode errorCode) {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onBannerClicked() {
                        UnityYodo1Advertising.unitySendMessage(gameObject, callbackName, convertToJsonString(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param align The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     * @deprecated The method SetBannerAlign has been deprecated, please use the method {@link #setBannerAlign} instead
     */
    @Deprecated
    public static void SetBannerAlign(final int align) {
        setBannerAlign(align);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param align The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public static void setBannerAlign(final int align) {
        YLog.d(TAG + "Unity calls the android SetBannerAlign method ...");
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.setBannerAlign(activity, align);
            }
        });
    }

    /**
     * Hide the banner ad.
     *
     * @deprecated The method HideBanner has been deprecated, please use the method {@link #hideBanner} instead
     */
    @Deprecated
    public static void HideBanner() {
        hideBanner();
    }

    /**
     * Hide the banner ad.
     */
    public static void hideBanner() {
        YLog.d(TAG + "Unity calls the android hideBanner method ...");
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.hideBanner(activity);
            }
        });
    }

    /**
     * Remove banner ad
     *
     * @deprecated The method RemoveBanner has been deprecated, please use the method {@link #removeBanner} instead
     */
    @Deprecated
    public static void RemoveBanner() {
        removeBanner();
    }

    /**
     * Remove banner ad
     */
    public static void removeBanner() {
        YLog.d(TAG + "Unity calls the android removeBanner method ...");
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.removeBanner(activity);
            }
        });
    }

    /**
     * Whether banner ads have been cached.
     *
     * @return true, if the banner ads have been cached, false otherwise.
     */
    public static boolean bannerIsReady() {
        YLog.d(TAG + "Unity calls the android bannerIsReady method ...");
        if (activity == null) {
            return false;
        }
        return Yodo1Advert.bannerIsReady(activity);
    }

    /**
     * 将显示广告的状态转换为json字符串
     *
     * @return a string
     */
    private static String convertToJsonString(int flag, int code, String advertCode) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("resulType", flag);
            jsonObj.put("code", code);
//            jsonObj.put("advertCode", advertCode);
        } catch (JSONException ignored) {

        }
        return jsonObj.toString();
    }
}
