package com.yodo1.advert.onlineconfig;

import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author zhuxiaochen
 * Date 2017/8/30
 */
public class Yodo1OnlineConfigAgent {
    private static final String TAG = "[Yodo1OnlineConfigAgent] ";

    /**
     * 视频广告开关
     */
    private static final String KEY_VIDEO_AD_SWITCH = "Platform_VideoAdMasterSwitch";
    /**
     * 视频广告比例及播放次数控制
     */
    private static final String KEY_VIDEO_AD_CONTROL = "Platform_VideoAdControl";
    /**
     * 视频广告key
     */
    private static final String KEY_VIDEO_AD_CONFIG = "Platform_VideoAdConfig";


    /**
     * 插屏广告开关
     */
    private static final String KEY_INTERSTITIAL_AD_SWITCH = "Platform_InterstitialAdMasterSwitch";
    /**
     * 插屏广告比例及播放次数控制
     */
    private static final String KEY_INTERSTITIAL_AD_CONTROL = "Platform_InterstitialAdControl";
    /**
     * 插屏广告key
     */
    private static final String KEY_INTERSTITIAL_AD_CONFIG = "Platform_InterstitialAdConfig";
    /**
     * 插屏广告时间间隔
     */
    private static final String KEY_INTERSTITIAL_AD_INTERVAL = "Platform_InterstitialAdInterval";

    /**
     * banner广告开关
     */
    private static final String KEY_BANNER_AD_SWITCH = "Platform_BannerAdMasterSwitch";
    /**
     * banner广告比例及播放次数控制
     */
    private static final String KEY_BANNER_AD_CONTROL = "Platform_BannerAdControl";
    /**
     * banner广告key
     */
    private static final String KEY_BANNER_AD_CONFIG = "Platform_BannerAdConfig";
    /**
     * banner广告切换时间
     */
    private static final String KEY_BANNER_AD_SWITCHING_CYCLE = "Platform_BannerAdSwitchingCycle";

    /**
     * 原生广告开关
     */
    private static final String KEY_NATIVE_AD_SWITCH = "Platform_NativeAdMasterSwitch";
    /**
     * 原生广告播放列表
     */
    private static final String KEY_NATIVE_AD_CONTROL = "Platform_NativeAdControl";
    /**
     * 原生广告key或者广告位
     */
    private static final String KEY_NATIVE_AD_CONFIG = "Platform_NativeAdConfig";

    /**
     * splash广告开关
     */
    private static final String KEY_SPLASH_AD_SWITCH = "Platform_SplashAdMasterSwitch";
    /**
     * 闪屏广告播放列表
     */
    private static final String KEY_SPLASH_AD_CONTROL = "Platform_SplashAdControl";
    /**
     * 闪屏广告key或者广告位
     */
    private static final String KEY_SPLASH_AD_CONFIG = "Platform_SplashAdConfig";

    /**
     * 最大展示次数
     */
    private static final String KEY_MAX_SHOW_TIMES = "maxShowTimes";
    /**
     * 播放比例
     */
    private static final String KEY_RATIO = "ratio";

    private static final String KEY_PLACEMENT = "Platform_AdPlacementConfig";

    /**
     * 插屏广告测试信息
     */
    private static final String KEY_INTERSTITIAL_AD_TEST_CONFIG = "interstitialAdConfig";
    /**
     * 视频广告测试信息
     */
    private static final String KEY_VIDEO_AD_TEST_CONFIG = "videoAdConfig";
    /**
     * banner广告测试信息
     */
    private static final String KEY_BANNER_AD_TEST_CONFIG = "bannerAdConfig";
    /**
     * 原生广告测试信息
     */
    private static final String KEY_NATIVE_AD_TEST_CONFIG = "nativeAdConfig";
    /**
     * 开屏广告测试信息
     */
    private static final String KEY_SPLASH_AD_TEST_CONFIG = "splashAdConfig";

    /**
     * 广告类型
     */
    public enum AdvertType {
        /**
         * 插屏
         */
        Platform_InterstitialAd,
        /**
         * 视频
         */
        Platform_VideoAd,
        /*
         * Banner
         */
        Platform_BannerAd,
        /**
         * 原生
         */
        Platform_NativeAd,
        /*
         * 闪屏
         */
        Platform_SplashAd,
    }

    /**
     * 获取在线参数, 时间间隔
     *
     * @param advertType AdvertType
     * @return interval time, 单位: 秒
     */
    public static String getIntervalConfigParam(AdvertType advertType) {
        //默认时间间隔为0s
        String result = "0";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_InterstitialAd && obj != null && !obj.isNull(KEY_INTERSTITIAL_AD_INTERVAL)) {
                result = obj.optString(KEY_INTERSTITIAL_AD_INTERVAL);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d(TAG + "[" + advertType.name() + "]  时间间隔: " + result);
        return result;
    }

    /**
     * 获取在线参数, 循环时间
     *
     * @param advertType AdvertType
     * @return 循环时间, 单位: 秒
     */
    public static String getSwitchingCycleConfigParam(AdvertType advertType) {
        //默认的时间间隔30s
        String result = "30";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_BannerAd && obj != null && !obj.isNull(KEY_BANNER_AD_SWITCHING_CYCLE)) {
                result = obj.optString(KEY_BANNER_AD_SWITCHING_CYCLE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d(TAG + "[" + advertType.name() + "]  循环时间: " + result);
        return result;
    }

    /**
     * 获取在线参数, 开关
     *
     * @param advertType AdvertType
     * @return switch, value: off/on
     */
    public static String getActiveConfigParam(AdvertType advertType) {
        String result = "off";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            if (advertType == AdvertType.Platform_InterstitialAd) {
                if (obj != null && !obj.isNull(KEY_INTERSTITIAL_AD_SWITCH)) {
                    result = obj.optString(KEY_INTERSTITIAL_AD_SWITCH);
                }
            } else if (advertType == AdvertType.Platform_BannerAd) {
                if (obj != null && !obj.isNull(KEY_BANNER_AD_SWITCH)) {
                    result = obj.optString(KEY_BANNER_AD_SWITCH);
                }
            } else if (advertType == AdvertType.Platform_VideoAd) {
                if (obj != null && !obj.isNull(KEY_VIDEO_AD_SWITCH)) {
                    result = obj.optString(KEY_VIDEO_AD_SWITCH);
                }
            } else if (advertType == AdvertType.Platform_SplashAd) {
                if (obj != null && !obj.isNull(KEY_SPLASH_AD_SWITCH)) {
                    result = obj.optString(KEY_SPLASH_AD_SWITCH);
                }
            } else if (advertType == AdvertType.Platform_NativeAd) {
                if (obj != null && !obj.isNull(KEY_NATIVE_AD_SWITCH)) {
                    result = obj.optString(KEY_NATIVE_AD_SWITCH);
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        YLog.d(TAG + "[" + advertType.name() + "]  开关: " + result);
        return result;
    }

    /**
     * 获取在线参数, 广告key
     *
     * @param advertType AdvertType
     * @param advertCode Ad network code
     * @param key        Ad network's key
     * @return Ad network's value
     */
    public static String getKeyConfigParam(AdvertType advertType, String advertCode, String key) {
        String result = "";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            JSONObject adconfig = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(KEY_INTERSTITIAL_AD_CONFIG)) {
                        adconfig = new JSONObject(obj.optString(KEY_INTERSTITIAL_AD_CONFIG));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(KEY_BANNER_AD_CONFIG)) {
                        adconfig = new JSONObject(obj.optString(KEY_BANNER_AD_CONFIG));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(KEY_VIDEO_AD_CONFIG)) {
                        adconfig = new JSONObject(obj.optString(KEY_VIDEO_AD_CONFIG));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(KEY_SPLASH_AD_CONFIG)) {
                        adconfig = new JSONObject(obj.optString(KEY_SPLASH_AD_CONFIG));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd) {
                    if (!obj.isNull(KEY_NATIVE_AD_CONFIG)) {
                        adconfig = new JSONObject(obj.optString(KEY_NATIVE_AD_CONFIG));
                    }
                }

                if (adconfig != null) {
                    JSONObject adcode = null;
                    if (!adconfig.isNull(advertCode)) {
                        adcode = adconfig.optJSONObject(advertCode);
                    } else if (!adconfig.isNull(advertCode.toLowerCase())) {
                        adcode = adconfig.optJSONObject(advertCode.toLowerCase());
                    }

                    if (adcode != null && !adcode.isNull(key)) {
                        result = adcode.optString(key);
                    }
                }

            }
            YLog.d(TAG + "[" + advertType.name() + "]  key: " + key + ", value: " + result);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取在线参数 控制对象  包括比例或者权重，最大展示次数
     *
     * @param advertType AdvertType
     * @return An list of AdsConfigEntity
     */
    public static List<AdsConfigEntity> getAdsControl(AdvertType advertType) {
        List<AdsConfigEntity> adsConfigEntities = new ArrayList<>();
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();
            JSONArray adControl = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(KEY_INTERSTITIAL_AD_CONTROL)) {
                        adControl = new JSONArray(obj.optString(KEY_INTERSTITIAL_AD_CONTROL));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(KEY_BANNER_AD_CONTROL)) {
                        adControl = new JSONArray(obj.optString(KEY_BANNER_AD_CONTROL));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(KEY_VIDEO_AD_CONTROL)) {
                        adControl = new JSONArray(obj.optString(KEY_VIDEO_AD_CONTROL));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(KEY_SPLASH_AD_CONTROL)) {
                        adControl = new JSONArray(obj.optString(KEY_SPLASH_AD_CONTROL));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd) {
                    if (!obj.isNull(KEY_NATIVE_AD_CONTROL)) {
                        adControl = new JSONArray(obj.optString(KEY_NATIVE_AD_CONTROL));
                    }
                }

                if (adControl != null) {
                    YLog.d(TAG + "[" + advertType.name() + "]  adControl = " + adControl.toString());

                    for (int i = 0; i < adControl.length(); i++) {
                        JSONObject adControlObj = new JSONObject(adControl.get(i).toString());

                        // 应用迭代器Iterator 获取所有的key值
                        Iterator<String> advertCodes = adControlObj.keys();

                        // 遍历每个key
                        while (advertCodes.hasNext()) {
                            AdsConfigEntity adsConfigEntity = new AdsConfigEntity();

                            String advertCode = advertCodes.next().toString();
                            JSONObject advertCodeObj = new JSONObject(adControlObj.optString(advertCode));
                            if (!advertCodeObj.isNull(KEY_RATIO)) {
                                String adRatio = advertCodeObj.optString(KEY_RATIO);
                                adsConfigEntity.setRatio(adRatio);
                            }

                            if (!advertCodeObj.isNull(KEY_MAX_SHOW_TIMES)) {
                                String adMaxShowTimes = advertCodeObj.optString(KEY_MAX_SHOW_TIMES);
                                adsConfigEntity.setMaxShowTimes(adMaxShowTimes);
                            }

                            adsConfigEntity.setAdvertCode(advertCode.toLowerCase());
                            adsConfigEntities.add(adsConfigEntity);
                        }
                    }
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        YLog.d(TAG + "[" + advertType.name() + "]  Control: " + adsConfigEntities.toString());

        return adsConfigEntities;
    }

    /**
     * 判断高级测试模式
     *
     * @param advertType AdvertType
     * @return The object of ad test info.
     */
    public static JSONObject getYodo1AdTestInfo(AdvertType advertType) {
        JSONObject adControl = null;
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonTestData();
            if (obj != null) {
                JSONObject adObj = obj.optJSONObject("ad_list");

                if (adObj != null) {
                    if (advertType == AdvertType.Platform_InterstitialAd) {
                        if (!adObj.isNull(KEY_INTERSTITIAL_AD_TEST_CONFIG)) {
                            adControl = new JSONObject(adObj.optString(KEY_INTERSTITIAL_AD_TEST_CONFIG));
                        }
                    } else if (advertType == AdvertType.Platform_BannerAd) {
                        if (!adObj.isNull(KEY_BANNER_AD_TEST_CONFIG)) {
                            adControl = new JSONObject(adObj.optString(KEY_BANNER_AD_TEST_CONFIG));
                        }
                    } else if (advertType == AdvertType.Platform_VideoAd) {
                        if (!adObj.isNull(KEY_VIDEO_AD_TEST_CONFIG)) {
                            adControl = new JSONObject(adObj.optString(KEY_VIDEO_AD_TEST_CONFIG));
                        }
                    } else if (advertType == AdvertType.Platform_SplashAd) {
                        if (!adObj.isNull(KEY_SPLASH_AD_TEST_CONFIG)) {
                            adControl = new JSONObject(adObj.optString(KEY_SPLASH_AD_TEST_CONFIG));
                        }
                    } else if (advertType == AdvertType.Platform_NativeAd) {
                        if (!adObj.isNull(KEY_NATIVE_AD_TEST_CONFIG)) {
                            adControl = new JSONObject(adObj.optString(KEY_NATIVE_AD_TEST_CONFIG));
                        }
                    }

                    if (adControl != null) {
                        YLog.d(TAG + "[" + advertType.name() + "]  测试广告信息: " + adControl.toString());
                    }
                    return adControl;
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<AdPlacementEntity> getPlacements(AdvertType advertType) {
        List<AdPlacementEntity> placements = new ArrayList<>();

        try {
            JSONObject jsonObject = Yodo1OnlineConfig.getInstance().getJsonData();
            if (jsonObject != null) {
                JSONArray jsonArray = null;
                if (!jsonObject.isNull(KEY_PLACEMENT)) {
                    jsonArray = new JSONArray(jsonObject.optString(KEY_PLACEMENT));

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject placementObject = new JSONObject(jsonArray.get(i).toString());

                        AdPlacementEntity placementEntity = new AdPlacementEntity();
                        if (!placementObject.isNull("code")) {
                            String code = placementObject.optString("code");
                            placementEntity.setCode(code);
                        }

                        if (!placementObject.isNull("type")) {
                            String type = placementObject.optString("type");
                            placementEntity.setType(type);
                        }

                        if (!placementObject.isNull("disabled")) {
                            int disabled = placementObject.optInt("disabled");
                            placementEntity.setDisabled(disabled == 1);
                        }

                        if (placementEntity.isBannerPlacement() && advertType == AdvertType.Platform_BannerAd) {
                            placements.add(placementEntity);
                        }
                        if (placementEntity.isInterstitialPlacement() && advertType == AdvertType.Platform_InterstitialAd) {
                            placements.add(placementEntity);
                        }
                        if (placementEntity.isVideoPlacement() && advertType == AdvertType.Platform_VideoAd) {
                            placements.add(placementEntity);
                        }
                        if (placementEntity.isNativePlacement() && advertType == AdvertType.Platform_NativeAd) {
                            placements.add(placementEntity);
                        }
                        if (placementEntity.isSplashPlacement() && advertType == AdvertType.Platform_SplashAd) {
                            placements.add(placementEntity);
                        }
                    }
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return placements;
    }
}
