package com.yodo1.advert.callback;

import com.yodo1.advert.entity.AdErrorCode;

public interface VideoCallback {

    /**
     * Called after an video has been dismissed.
     *
     * @param isFinished true, if the reward video ad has been shown completely, false otherwise.
     */
    public void onVideoClosed(boolean isFinished);

    /**
     * Called after an video has been displayed on the screen.
     */
    public void onVideoShow();

    /**
     * Called after an video has attempted to show but failed.
     *
     * @param errorCode The reason for the error
     */
    public void onVideoShowFailed(AdErrorCode errorCode);

    /**
     * Called after an video has been clicked.
     */
    public void onVideoClicked();
}
