package com.yodo1.advert.callback;

import com.yodo1.advert.entity.AdErrorCode;

public interface SplashCallback {

    /**
     * Called after an Splash has been dismissed.
     */
    public void onSplashClosed();

    /**
     * Called after an Splash has been displayed on the screen.
     */
    public void onSplashShow();

    /**
     * Called after an Splash has attempted to show but failed.
     *
     * @param errorCode The reason for the error
     */
    public void onSplashShowFailed(AdErrorCode errorCode);

    /**
     * Called after an Splash has been clicked.
     */
    public void onSplashClicked();
}
