package com.yodo1.advert.callback;

import com.yodo1.advert.entity.AdErrorCode;

public interface NativeCallback {

    /**
     * Called after an Native has been dismissed.
     */
    public void onNativeClosed();

    /**
     * Called after an Native has been displayed on the screen.
     */
    public void onNativeShow();

    /**
     * Called after an Native has attempted to show but failed.
     *
     * @param errorCode The reason for the error
     */
    public void onNativeShowFailed(AdErrorCode errorCode);

    /**
     * Called after an Native has been clicked.
     */
    public void onNativeClicked();
}
