package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.adapter.kit.Yodo1InterAdView;
import com.yodo1.advert.adapter.kit.Yodo1VideoAds;
import com.yodo1.advert.adapter.kit.Yodo1VideoCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteryodo1 extends AdapterAdvertBase {
    public static final String Yodo1_WEB_URL = "https://yodo1opp.com/";
    private static final String TAG = "[AdvertAdapteryodo1] ";
    private static final String CHANNEL_CODE = "Yodo1";
    private Yodo1VideoCallback callback = new Yodo1VideoCallback() {

        @Override
        public void onVideoClosed() {
            YLog.d(TAG + "onVideoClosed");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoFinish() {
            YLog.d(TAG + "onVideoFinish");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoShow() {
            YLog.d(TAG + "onVideoShow");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onVideoShowFailed(int errorCode) {
            YLog.d(TAG + "onVideoShowFailed, " + errorCode);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        @Override
        public void onVideoClicked() {
            YLog.d(TAG + "onVideoClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    private Yodo1InterAdView adView;
    private Yodo1InterAdView.OnYodo1AdsCallBack adsCallBack = new Yodo1InterAdView.OnYodo1AdsCallBack() {
        @Override
        public void setOnAdClickListener() {
            YLog.d(TAG + "setOnAdClickListener");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void setOnAdCloseListener() {
            YLog.d(TAG + "setOnAdCloseListener");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void setOnAdShowSuccessListener() {
            YLog.d(TAG + "setOnAdShowSuccessListener");
            if (getIntersititalCallback() != null) {
                getIntersititalCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadSuccessListener() {
            YLog.d(TAG + "setOnAdLoadSuccessListener");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadFailedListener() {
            YLog.d(TAG + "setOnAdLoadFailedListener");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "error: null", getAdvertCode());
            }
        }
    };

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private ImageView bannerView;
    private boolean isShowSuccess = false;

    /**
     * 访问yodo1地址
     *
     * @param context
     */
    public static void goYodo1Web(Activity context) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        Uri uri = Uri.parse(Yodo1_WEB_URL);
        intent.setData(uri);
        context.startActivity(intent);
    }

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (activity == null || initializeCallback == null) {
            return;
        }

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful");
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initBannerAd(final Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (activity == null || initializeCallback == null) {
            return;
        }

        bannerView = new ImageView(activity);

        loadBannerAds(bannerView);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(600,
                100);//两个400分别为添加图片的大小
        bannerView.setLayoutParams(params);
        bannerView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (callback != null) {
                    YLog.d(TAG + "BannerAd onClick");
                    goYodo1Web(activity);
                    getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }
        });

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful");
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }


    @Override
    public void showBanner(Activity activity, final Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Show banner ad...");
        if (bannerView != null) {
            isShowSuccess = true;
            Yodo1BannerAlign.setYodo1BannerLayout(activity, bannerView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "", getAdvertCode());
        }
    }

    @Override
    public void removeBanner(Activity activity) {
        if (bannerView != null && isShowSuccess) {
            YLog.d(TAG + "Remove banner ad...");
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerView);
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        if (bannerView != null && isShowSuccess) {
            YLog.d(TAG + "Hide banner ad...");
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerView);
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
    }

    @Override
    public boolean hasLoadBanner() {
        return true;
    }

    /**
     * 加载Banner
     */
    public void loadBannerAds(final ImageView imageView) {
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-banner1.png";
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>() {
            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                Bitmap bm = response.get();

                if (getBannerCallback() != null) {
                    getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
                }
                imageView.setImageBitmap(bm);

            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {
                if (getBannerCallback() != null) {
                    getBannerCallback().onEvent(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, getAdvertCode());
                }
            }

            @Override
            public void onFinish(int what) {
            }
        };
        //设置缓存模式
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (activity == null || initializeCallback == null) {
            return;
        }

        Yodo1VideoAds.setYodo1VideoCallback(callback);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful");
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(TAG + "Show rewarded video ad...");
        this.setVideoCallback(callback);
        if (Yodo1VideoAds.isReady()) {
            Yodo1VideoAds.showVideoAds(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "激励视频广告加载中或者已过期，请稍后再次请求广告后进行广告展示！", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadVideoCallback) {
        this.setReloadVideoCallback(reloadVideoCallback);
        YLog.d(TAG + "Loading rewarded video ad...");
        Yodo1VideoAds.loadYodo1Video(activity);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Yodo1VideoAds.isReady();
    }


    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (activity == null || initializeCallback == null) {
            return;
        }

        adView = new Yodo1InterAdView(activity);
        adView.setOnYodo1AdsCallback(adsCallBack);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful");
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.setIntersititalCallback(callback);
        YLog.d(TAG + "Show Interstitial ad ...");

        if (adView != null) {
            adView.showYodo1Ads(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return true;
    }


}
