package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.yandex.mobile.ads.AdEventListener;
import com.yandex.mobile.ads.AdRequest;
import com.yandex.mobile.ads.AdRequestError;
import com.yandex.mobile.ads.AdSize;
import com.yandex.mobile.ads.AdView;
import com.yandex.mobile.ads.InterstitialAd;
import com.yandex.mobile.ads.InterstitialEventListener;
import com.yandex.mobile.ads.MobileAds;
import com.yandex.mobile.ads.rewarded.Reward;
import com.yandex.mobile.ads.rewarded.RewardedAd;
import com.yandex.mobile.ads.rewarded.RewardedAdEventListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdapteryandex extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapteryandex] ";
    private static final String CHANNEL_CODE = "Yandex";

    private static final String KEY_BLOCK_BANNER = "ad_yandex_banner_blockid";
    private static final String KEY_BLOCK_INTERSTITIAL = "ad_yandex_interstitial_blockid";
    private static final String KEY_BLOCK_VIDEO = "ad_yandex_video_blockid";

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private AdView bannerAdView;
    private InterstitialAd interstitialAd;
    private RewardedAd videoAd;

    final private AdRequest adRequest = AdRequest.builder().build();

    final private AdEventListener.SimpleAdEventListener bannerAdListener = new AdEventListener.SimpleAdEventListener() {
        @Override
        public void onAdClosed() {
            YLog.d(TAG + "BannerAd onAdClosed");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdFailedToLoad(@NonNull AdRequestError error) {
            YLog.d(TAG + "BannerAd onAdFailedToLoad, " + error.toString());
            setBannerLoaded(false);
        }

        @Override
        public void onAdLeftApplication() {
            YLog.d(TAG + "BannerAd onAdLeftApplication");
        }

        @Override
        public void onAdLoaded() {
            YLog.d(TAG + "BannerAd onAdLoaded");
            setBannerLoaded(true);
        }

        @Override
        public void onAdOpened() {
            YLog.d(TAG + "BannerAd onAdOpened");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    final private InterstitialEventListener interstitialAdListener = new InterstitialEventListener.SimpleInterstitialEventListener() {
        @Override
        public void onInterstitialDismissed() {
            YLog.d(TAG + "InterstitialAd onInterstitialDismissed");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialFailedToLoad(@NonNull AdRequestError error) {
            YLog.d(TAG + "InterstitialAd onInterstitialFailedToLoad, " + error.toString());
            setInterLoaded(false);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.toString(), getAdvertCode());
            }
        }

        @Override
        public void onInterstitialLoaded() {
            YLog.d(TAG + "InterstitialAd onInterstitialLoaded");
            setInterLoaded(true);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onInterstitialShown() {
            YLog.d(TAG + "InterstitialAd onInterstitialShown");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            YLog.d(TAG + "InterstitialAd onAdClosed");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdLeftApplication() {
            YLog.d(TAG + "InterstitialAd onAdLeftApplication");
        }

        @Override
        public void onAdOpened() {
            YLog.d(TAG + "InterstitialAd onAdOpened");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    final private RewardedAdEventListener.SimpleRewardedAdEventListener videoAdListener = new RewardedAdEventListener.SimpleRewardedAdEventListener() {
        @Override
        public void onAdClosed() {
            YLog.d(TAG + "VideoAd onAdClosed");
        }

        @Override
        public void onAdDismissed() {
            YLog.d(TAG + "VideoAd onAdDismissed");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdFailedToLoad(@NonNull AdRequestError error) {
            YLog.d(TAG + "VideoAd onNoAd, " + error.toString());
            setVideoLoaded(false);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.toString(), getAdvertCode());
            }
        }

        @Override
        public void onAdLeftApplication() {
            YLog.d(TAG + "VideoAd onAdLeftApplication");
        }

        @Override
        public void onAdLoaded() {
            YLog.d(TAG + "VideoAd onAdLoaded");
            setVideoLoaded(true);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdOpened() {
            YLog.d(TAG + "VideoAd onAdOpened");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdShown() {
            YLog.d(TAG + "VideoAd onAdShown");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(@NonNull Reward reward) {
            YLog.d(TAG + "VideoAd onRewarded");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };


    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return MobileAds.getLibraryVersion();
    }

    @Override
    public String getSdkVersion() {
        return MobileAds.getLibraryVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (bannerAdView != null) {
            bannerAdView.destroy();
        }
    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        super.initSdk(activity, initializeCallback);
        if (initializeCallback == null) {
            return;
        }

        // Enabling debug mode
        MobileAds.enableDebugErrorIndicator(true);
        MobileAds.enableLogging(true);

        this.updatePrivacyConsent();
        setInitialized(true);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initBannerAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        String bannerBlockId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_BLOCK_BANNER);
        if (TextUtils.isEmpty(bannerBlockId)) {
            YLog.d(TAG + "Initialize banner ad failure, bannerBlockId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerBlockId is null", getAdvertCode());
            return;
        }

        bannerAdView = new AdView(activity);
        bannerAdView.setBlockId(bannerBlockId);
        bannerAdView.setAdSize(AdSize.BANNER_320x50);
        bannerAdView.setAdEventListener(bannerAdListener);
        bannerAdView.loadAd(adRequest);

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful, bannerBlockId: " + bannerBlockId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        this.updatePrivacyConsent();

        if (hasLoadBanner()) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (bannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String interstitialBlockId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_BLOCK_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialBlockId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialBlockId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialBlockId is null", getAdvertCode());
            return;
        }

        // Create an instance of InterstitialAd
        interstitialAd = new InterstitialAd(activity);
        interstitialAd.setBlockId(interstitialBlockId);
        interstitialAd.setInterstitialEventListener(interstitialAdListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialBlockId: " + interstitialBlockId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.show();
            setInterLoaded(false);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.loadAd(adRequest);
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.isInterLoaded();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String videoBlockId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_BLOCK_VIDEO);
        if (TextUtils.isEmpty(videoBlockId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoBlockId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoBlockId is null", getAdvertCode());
            return;
        }

        // Create an instance of InterstitialAd
        videoAd = new RewardedAd(activity);
        videoAd.setBlockId(videoBlockId);
        videoAd.setRewardedAdEventListener(videoAdListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoBlockId: " + videoBlockId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        YLog.d(TAG + "Showing rewarded video ad...");
        if (videoAd != null) {
            videoAd.show();
            setVideoLoaded(false);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent();

        if (videoAd != null) {
            videoAd.loadAd(adRequest);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.isVideoLoaded();
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            MobileAds.setUserConsent(privacy.isHasUserConsent());
            if (privacy.isHasUserConsent()) {
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has not consented");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
