package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author yodo1
 */
public class AdvertAdapterunityads extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterunityads] ";
    private static final String CHANNEL_CODE = "Unityads";

    private static final String KEY_GAME_ID = "ad_unityads_app_id";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_unityads_interstitial_id";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_unityads_rewarded_id";

    private String interstitialPlacementId;
    private String rewardedPlacementId;

    final private IUnityAdsListener unityAdsListener = new IUnityAdsListener() {
        @Override
        public void onUnityAdsReady(String placementId) {
            YLog.d(TAG + "onPlacementContentReady, placementId: " + placementId);
            if (getReloadInterCallback() != null && placementId.equals(interstitialPlacementId)) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }

            if (getReloadVideoCallback() != null && placementId.equals(rewardedPlacementId)) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsStart(String placementId) {
            YLog.d(TAG + "onUnityAdsStart, placementId: " + placementId);

            if (getInterstitialCallback() != null && placementId.equals(interstitialPlacementId)) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }

            if (getVideoCallback() != null && placementId.equals(rewardedPlacementId)) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsFinish(String placementId, UnityAds.FinishState finishState) {
            YLog.d(TAG + "onAdFinished, placementId: " + placementId + ", FinishState : " + finishState);

            if (getInterstitialCallback() != null && placementId.equals(interstitialPlacementId)) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (getVideoCallback() != null && placementId.equals(rewardedPlacementId)) {
                if (finishState == UnityAds.FinishState.COMPLETED) {
                    getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                }
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsError(UnityAds.UnityAdsError error, String message) {
            YLog.d(TAG + "onUnityAdsError, error: " + error.name() + ", message: " + message);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }

            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "code:" + error.name() + ", msg:" + message, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return UnityAds.getVersion();
    }

    @Override
    public String getSdkVersion() {
        return UnityAds.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInitialized()) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_GAME_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_GAME_ID);
        }

        if (TextUtils.isEmpty(appId)) {
            YLog.i(TAG + "Initialize sdk failure, appId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        if (!UnityAds.isInitialized()) {
            updatePrivacyConsent(activity);
            UnityAds.initialize(activity, appId, unityAdsListener, false, true);
            this.setInitialized(true);
            YLog.d(TAG + "Initialize sdk successful, appId: " + appId);
            initializeCallback.onInitializeSuccess(getAdvertCode());
        }
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialPlacementId: " + interstitialPlacementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(TAG + "Showing interstitial ad...");
        this.setInterstitialCallback(callback);

        if (!interstitialAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        UnityAds.show(activity, interstitialPlacementId);
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadInterCallback(reloadCallback);
        this.updatePrivacyConsent(activity);

        YLog.d(TAG + "Loading interstitial ad...");
        UnityAds.load(interstitialPlacementId);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(interstitialPlacementId) && UnityAds.isReady(interstitialPlacementId);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(rewardedPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedPlacementId is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedPlacementId: " + rewardedPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d(TAG + "Showing rewarded video ad...");
        this.setVideoCallback(callback);

        if (!videoAdvertIsLoaded(activity)) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
            return;
        }

        UnityAds.show(activity, rewardedPlacementId);
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        this.updatePrivacyConsent(activity);

        YLog.d(TAG + "Loading rewarded video ad...");
        UnityAds.load(rewardedPlacementId);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(rewardedPlacementId) && UnityAds.isReady(rewardedPlacementId);
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            MetaData metaData = new MetaData(activity);

            metaData.set("gdpr.consent", privacy.isHasUserConsent());
            if (privacy.isHasUserConsent()) {
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has not consented");
            }

            metaData.set("privacy.useroveragelimit", privacy.isAgeRestrictedUser());
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }

            metaData.set("privacy.consent", !privacy.isDoNotSell());
            if (privacy.isDoNotSell()) {
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }

            metaData.commit();
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }
}
