package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.TJPrivacyPolicy;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import java.util.Hashtable;

/**
 * @author yodo1
 */
public class AdvertAdaptertapjoy extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdaptertapjoy] ";
    private static final String CHANNEL_CODE = "Tapjoy";

    private static final String KEY_APP_KEY = "ad_tapjoy_appkey";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_tapjoy_placement_video";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_tapjoy_placement_interstitial";

    private static String interstitialPlacementId, rewardedVideoPlacementId;

    private TJPlacement interstitialPlacement, videoPlacement;

    final private TJPlacementListener videoListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onRequestSuccess, placement: " + tjPlacement.getName());
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d(TAG + "RewardedAd onRequestFailure, placement: " + tjPlacement.getName() + ", " + getNetworkError(tjError));
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, tjError.code, tjError.message, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentReady, placement: " + tjPlacement.getName());
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentShow, placement: " + tjPlacement.getName());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onContentDismiss, placement: " + tjPlacement.getName());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d(TAG + "RewardedAd onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d(TAG + "RewardedAd onRewardRequest, placement: " + tjPlacement.getName());
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onClick, placement: " + tjPlacement.getName());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    final private TJPlacementVideoListener tjPlacementVideoListener = new TJPlacementVideoListener() {
        @Override
        public void onVideoStart(TJPlacement tjPlacement) {
            YLog.d(TAG + "RewardedAd onVideoStart, placement: " + tjPlacement.getName());

        }

        @Override
        public void onVideoError(TJPlacement tjPlacement, String s) {
            YLog.d(TAG + "RewardedAd onVideoError, placement: " + tjPlacement.getName() + ", s: " + s);

        }

        @Override
        public void onVideoComplete(TJPlacement tjPlacement) {
            // Best Practice: We recommend calling getCurrencyBalance as often as possible so the user�s balance is always up-to-date.
            YLog.d(TAG + "RewardedAd onVideoComplete, placement: " + tjPlacement.getName());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    final private TJPlacementListener interstitialListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onRequestSuccess, placement: " + tjPlacement.getName());
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d(TAG + "InterstitialAd onRequestFailure, tjPlacement:" + tjPlacement.getName() + ", " + getNetworkError(tjError));
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, tjError.code, tjError.message, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentReady, placement: " + tjPlacement.getName());
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentShow, placement: " + tjPlacement.getName());
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, CHANNEL_CODE);
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onContentDismiss, placement: " + tjPlacement.getName());
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, CHANNEL_CODE);
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d(TAG + "InterstitialAd onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d(TAG + "InterstitialAd onRewardRequest, placement: " + tjPlacement.getName());
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            YLog.d(TAG + "InterstitialAd onClick, placement: " + tjPlacement.getName());
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return Tapjoy.getVersion();
    }

    @Override
    public String getSdkVersion() {
        return Tapjoy.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        Tapjoy.onActivityStart(activity);
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_KEY);
        if (TextUtils.isEmpty(appKey)) {
            appKey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_KEY);
        }
        if (TextUtils.isEmpty(appKey)) {
            YLog.d(TAG + "Initialize sdk failure, appKey is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appKey is null", getAdvertCode());
            return;
        }
        Hashtable<String, Object> connectFlags = new Hashtable<>();

        boolean isDebugEnabled = false;
        connectFlags.put("TJC_OPTION_ENABLE_LOGGING", isDebugEnabled ? "true" : "false");
        Tapjoy.setDebugEnabled(isDebugEnabled);
        TapjoyLog.setDebugEnabled(isDebugEnabled);

        Tapjoy.setActivity(activity);

        this.updatePrivacyConsent();
        Tapjoy.connect(activity.getApplicationContext(), appKey, connectFlags, new TJConnectListener() {
            @Override
            public void onConnectSuccess() {
                YLog.d(TAG + "Initialize sdk successful, onConnectSuccess");

                setInitialized(true);
                initializeCallback.onInitializeSuccess(getAdvertCode());
            }

            @Override
            public void onConnectFailure() {
                YLog.d(TAG + "Initialize sdk failure, onConnectFailure");
                initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_COMMON, 0, "connect failure", getAdvertCode());
            }
        });
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialPlacementId: " + interstitialPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (interstitialAdvertIsLoaded(activity)) {
                        YLog.d(TAG + "Showing interstitial ad...");
                        interstitialPlacement.showContent();
                    }

                }
            });
        } catch (Exception exception) {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Exception", CHANNEL_CODE);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        try {
            this.updatePrivacyConsent();
            if (Tapjoy.isConnected()) {
                YLog.d(TAG + "Loading interstitial ad...");
                interstitialPlacement = Tapjoy.getPlacement(interstitialPlacementId, interstitialListener);
                interstitialPlacement.requestContent();
            } else {
                YLog.d(TAG + "SDK must finish connecting before requesting content.");
            }
        } catch (Exception exception) {
            YLog.d("Tapjoy SDK Exception .");
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialPlacement != null && interstitialPlacement.isContentReady();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        rewardedVideoPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(rewardedVideoPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, rewardedVideoPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "rewardedVideoPlacementId is null", getAdvertCode());
            return;
        }

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, rewardedVideoPlacementId: " + rewardedVideoPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (videoAdvertIsLoaded(activity)) {
                    YLog.d(TAG + "Showing rewarded video ad...");

                    videoPlacement.showContent();
                }
            }
        });

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);

        try {
            this.updatePrivacyConsent();
            if (Tapjoy.isConnected()) {
                YLog.d(TAG + "Loading rewarded video ad...");

                videoPlacement = Tapjoy.getPlacement(rewardedVideoPlacementId, videoListener);

                videoPlacement.setVideoListener(tjPlacementVideoListener);
                videoPlacement.requestContent();
            } else {
                YLog.d(TAG + "SDK must finish connecting before requesting content.");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } catch (Error e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return videoPlacement != null && videoPlacement.isContentReady();
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            if (privacy.isHasUserConsent()) {
                TJPrivacyPolicy.getInstance().setSubjectToGDPR(true);
                TJPrivacyPolicy.getInstance().setUserConsent("1");
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                TJPrivacyPolicy.getInstance().setSubjectToGDPR(false);
                TJPrivacyPolicy.getInstance().setUserConsent("0");
                YLog.d(TAG + "(GDPR) The user has not consented");
            }

            TJPrivacyPolicy.getInstance().setBelowConsentAge(privacy.isAgeRestrictedUser());
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }

            String privacyValue = privacy.isDoNotSell() ? "1-N-" : "1-Y-";
            TJPrivacyPolicy.getInstance().setUSPrivacy(privacyValue);
            YLog.d(TAG + "(CCPA) Privacy value: " + privacyValue);
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }

    public String getNetworkError(TJError error) {
        return "errorCode:" + error.code + ", errorMessage:" + error.message;
    }
}
