package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiBanner;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.BannerAdEventListener;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.inmobi.sdk.InMobiSdk;
import com.inmobi.sdk.SdkInitializationListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

/**
 * @author yodo1
 */
public class AdvertAdapterinmobi extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterinmobi] ";
    private static final String CHANNEL_CODE = "Inmobi";

    private static final String KEY_APP_ID = "ad_inmobi_app_id";
    private static final String KEY_PLACEMENT_ID_BANNER = "ad_inmobi_banner_placementid";
    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_inmobi_inter_placementid";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_inmobi_video_placementid";

    private static final int BANNER_WIDTH = 320;
    private static final int BANNER_HEIGHT = 50;
    private int refreshTime = 15;

    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;

    private InMobiBanner bannerAdView;
    private InMobiInterstitial interstitialAd, videoAd;

    private final BannerAdEventListener bannerAdListener = new BannerAdEventListener() {
        @Override
        public void onAdLoadSucceeded(@NonNull InMobiBanner inMobiBanner,
                                      @NonNull AdMetaInfo adMetaInfo) {
            YLog.d(TAG + "BannerAd onLoad; Creative ID for ad : " + adMetaInfo.getCreativeID());
            setBannerLoaded(true);
        }

        @Override
        public void onAdLoadFailed(@NonNull InMobiBanner inMobiBanner, @NonNull InMobiAdRequestStatus inMobiAdRequestStatus) {
            YLog.d(TAG + "BannerAd LoadFailed, reason: " + inMobiAdRequestStatus.getMessage());
            setBannerLoaded(false);
        }

        @Override
        public void onAdClicked(@NonNull InMobiBanner inMobiBanner, @NonNull Map<Object, Object> map) {
            YLog.d(TAG + "BannerAd onClick");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiBanner inMobiBanner) {
            YLog.d(TAG + "BannerAd onShow");
            if (getBannerCallback() != null) {
                getBannerCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdDismissed(@NonNull InMobiBanner inMobiBanner) {
            YLog.d(TAG, "onAdDismissed");
        }

        @Override
        public void onUserLeftApplication(@NonNull InMobiBanner inMobiBanner) {
            YLog.d(TAG, "onUserLeftApplication");
        }

        @Override
        public void onRewardsUnlocked(@NonNull InMobiBanner inMobiBanner, @NonNull Map<Object, Object> map) {
            YLog.d(TAG, "onRewardsUnlocked");
        }
    };

    final private InterstitialAdEventListener interstitialAdListener = new InterstitialAdEventListener() {
        @Override
        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial,
                                      @NonNull AdMetaInfo adMetaInfo) {
            YLog.d(TAG + "InterstitialAd onAdLoadSucceeded. " + "Creative ID for ad : " + adMetaInfo.getCreativeID());

            setInterLoaded(true);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(InMobiInterstitial inMobiInterstitial, InMobiAdRequestStatus inMobiAdRequestStatus) {
            YLog.d(TAG + "InterstitialAd onAdLoadFailed, reason: " + inMobiAdRequestStatus.getMessage());
            setInterLoaded(false);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, inMobiAdRequestStatus.getMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdFetchSuccessful(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            YLog.d(TAG + "InterstitialAd onAdFetchSuccessful");
        }

        @Override
        public void onAdClicked(InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            YLog.d(TAG + "InterstitialAd onClick");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdWillDisplay(InMobiInterstitial inMobiInterstitial) {
            YLog.d(TAG + "InterstitialAd onAdWillDisplay");
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiInterstitial inMobiInterstitial,
                                  @NonNull AdMetaInfo adMetaInfo) {
            YLog.d(TAG + "InterstitialAd onDisplay. Creative ID for ad : " + adMetaInfo.getCreativeID());
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(@NonNull InMobiInterstitial inMobiInterstitial) {
            YLog.d(TAG + "InterstitialAd onAdDisplayFailed");
        }

        @Override
        public void onAdDismissed(@NonNull InMobiInterstitial inMobiInterstitial) {
            YLog.d(TAG + "InterstitialAd onDismiss");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onUserLeftApplication(@NonNull InMobiInterstitial inMobiInterstitial) {
            YLog.d(TAG + "InterstitialAd onUserWillLeaveApplication");
        }

        @Override
        public void onRewardsUnlocked(@NonNull InMobiInterstitial inMobiInterstitial,
                                      @NonNull Map<Object, Object> map) {
            YLog.d(TAG + "InterstitialAd onRewardsUnlocked");
        }
    };

    private final InterstitialAdEventListener videoAdListener = new InterstitialAdEventListener() {

        @Override
        public void onAdLoadSucceeded(@NonNull InMobiInterstitial ad, @NonNull AdMetaInfo info) {
            YLog.d(TAG + "VideoAd onAdLoadSucceeded. Creative ID for ad : " + info.getCreativeID());
            setVideoLoaded(true);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }

        }

        @Override
        public void onAdLoadFailed(@NonNull InMobiInterstitial ad, InMobiAdRequestStatus status) {
            YLog.d(TAG + "VideoAd onAdLoadFailed, reason: " + status.getMessage());
            setVideoLoaded(false);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, status.getMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdFetchSuccessful(@NonNull InMobiInterstitial ad, @NonNull AdMetaInfo info) {
            YLog.d(TAG + "VideoAd onAdFetchSuccessful");
        }

        @Override
        public void onAdClicked(@NonNull InMobiInterstitial ad, Map<Object, Object> params) {
            YLog.d(TAG + "VideoAd onAdClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdWillDisplay(@NonNull InMobiInterstitial ad) {
            YLog.d(TAG + "VideoAd onAdWillDisplay");
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiInterstitial ad, @NonNull AdMetaInfo info) {
            YLog.d(TAG + "VideoAd onDisplay. Creative ID for ad : " + info.getCreativeID());
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdDismissed(@NonNull InMobiInterstitial ad) {
            YLog.d(TAG + "VideoAd onAdDismissed");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onUserLeftApplication(@NonNull InMobiInterstitial ad) {
            YLog.d(TAG + "VideoAd onUserLeftApplication");
        }

        @Override
        public void onRewardsUnlocked(@NonNull InMobiInterstitial ad, Map<Object, Object> rewards) {
            YLog.d(TAG + "VideoAd onRewarded");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSdkVersion() {
        return InMobiSdk.getVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (bannerAdView != null) {
            bannerAdView.destroy();
        }
    }

    @Override
    public void initSdk(Activity activity, final Yodo1AdInitializeCallback initializeCallback) {
        super.initSdk(activity, initializeCallback);
        if (this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
        }

        if (TextUtils.isEmpty(appId)) {
            YLog.d(TAG + "Initialize sdk failure, appId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId is null", getAdvertCode());
            return;
        }

        // Enabling debug mode
        InMobiSdk.setLogLevel(InMobiSdk.LogLevel.DEBUG);

        final String finalAppId = appId;
        InMobiSdk.init(activity, appId, getConsentJson(), new SdkInitializationListener() {
            @Override
            public void onInitializationComplete(@Nullable Error error) {
                if (null != error) {
                    YLog.d(TAG + "Initialize sdk  failure, appId is null");
                    initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, error.getMessage(), getAdvertCode());
                } else {
                    YLog.d(TAG + "Initialize sdk successful, " + "appId: " + finalAppId);
                    AdvertAdapterinmobi.this.updatePrivacyConsent();
                    setInitialized(true);
                    initializeCallback.onInitializeSuccess(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void initBannerAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        String bannerPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, CHANNEL_CODE, KEY_PLACEMENT_ID_BANNER);
        if (TextUtils.isEmpty(bannerPlacementId)) {
            YLog.d(TAG + "Initialize banner ad failure, bannerBlobannerPlacementIdckId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "bannerPlacementId is null", getAdvertCode());
            return;
        }
        long placementId = -1;
        try {
            placementId = Long.parseLong(bannerPlacementId);
        } catch (Exception ignored) {

        }
        if (placementId == -1) {
            YLog.d(TAG + "Initialize banner ad failure, placementId is invalid, " + placementId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementId is invalid", getAdvertCode());
            return;
        }

        bannerAdView = new InMobiBanner(activity, placementId);
//        setBannerLayoutParams(activity);
        bannerAdView.setRefreshInterval(refreshTime);
        bannerAdView.setAnimationType(InMobiBanner.AnimationType.ROTATE_HORIZONTAL_AXIS);
        bannerAdView.setListener(bannerAdListener);
//        Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
        bannerAdView.load();

        this.setBannerInitialized(true);
        YLog.d(TAG + "Initialize banner ad successful, bannerPlacementId: " + bannerPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    private void setBannerLayoutParams(Activity activity) {
        int width = toPixelUnits(activity, BANNER_WIDTH);
        int height = toPixelUnits(activity, BANNER_HEIGHT);
        RelativeLayout.LayoutParams bannerLayoutParams = new RelativeLayout.LayoutParams(width, height);
        bannerLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        bannerLayoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
        bannerAdView.setLayoutParams(bannerLayoutParams);
    }

    private int toPixelUnits(Activity activity, int dipUnit) {
        float density = activity.getResources().getDisplayMetrics().density;
        return Math.round(dipUnit * density);
    }

    @Override
    public void showBanner(Activity activity, Yodo1AdCallback callback) {
        this.setBannerCallback(callback);
        YLog.d(TAG + "Showing banner ad...");

        this.updatePrivacyConsent();

        if (hasLoadBanner()) {
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity, bannerAdView, align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d(TAG + "Hide banner ad...");
        if (bannerAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity, bannerAdView);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d(TAG + "setBannerAlign, align:" + align);
    }

    @Override
    public boolean hasLoadBanner() {
        return this.isBannerLoaded();
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String interstitialPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(interstitialPlacementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, interstitialPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "interstitialPlacementId is null", getAdvertCode());
            return;
        }

        long placementId = -1;
        try {
            placementId = Long.parseLong(interstitialPlacementId);
        } catch (Exception ignored) {

        }
        if (placementId == -1) {
            YLog.d(TAG + "Initialize interstitial ad failure, placementId is invalid, " + placementId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementId is invalid", getAdvertCode());
            return;
        }
        // Create an instance of InterstitialAd
        interstitialAd = new InMobiInterstitial(activity, placementId, interstitialAdListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, interstitialPlacementId: " + interstitialPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.show();
            setInterLoaded(false);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        if (interstitialAd != null) {
            interstitialAd.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return this.isInterLoaded();
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        String videoPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(videoPlacementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, videoPlacementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "videoPlacementId is null", getAdvertCode());
            return;
        }

        long placementId = -1;
        try {
            placementId = Long.parseLong(videoPlacementId);
        } catch (Exception ignored) {

        }
        if (placementId == -1) {
            YLog.d(TAG + "Initialize rewarded ad failure, placementId is invalid, " + placementId);
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementId is invalid", getAdvertCode());
            return;
        }
        // Create an instance of InterstitialAd
        videoAd = new InMobiInterstitial(activity, placementId, videoAdListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, videoPlacementId: " + videoPlacementId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);

        YLog.d(TAG + "Showing rewarded video ad...");
        if (videoAd != null) {
            videoAd.show();
            setVideoLoaded(false);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent();

        if (videoAd != null) {
            videoAd.load();
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return this.isVideoLoaded();
    }

    private void updatePrivacyConsent() {
        InMobiSdk.updateGDPRConsent(getConsentJson());
    }

    private JSONObject getConsentJson() {
        Yodo1Privacy privacy = getPrivacy();
        JSONObject consent = new JSONObject();
        if (privacy != null) {
            try {
                consent.put(InMobiSdk.IM_GDPR_CONSENT_AVAILABLE, privacy.isHasUserConsent());
                consent.put("gdpr", privacy.isHasUserConsent() ? "1" : "0");

                if (privacy.isHasUserConsent()) {
                    YLog.d(TAG + "(GDPR) The user has consented");
                } else {
                    YLog.d(TAG + "(GDPR) The user has not consented");
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
        return consent;
    }
}
