package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.text.TextUtils;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author sunmeng
 */
public class AdvertAdapterfacebook extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterfacebook] ";
    private static final String CHANNEL_CODE = "FaceBook";

    private static final String KEY_PLACEMENT_ID_INTERSTITIAL = "ad_facebook_sdk_key";
    private static final String KEY_PLACEMENT_ID_REWARDED_VIDEO = "ad_facebook_video_key";

    private InterstitialAd interstitialAd;
    private RewardedVideoAd rewardedVideoAd = null;

    private boolean rewardedVideoLoading = false;

    final private InterstitialAdListener adInterListener = new InterstitialAdListener() {
        @Override
        public void onInterstitialDisplayed(Ad ad) {
            YLog.d(TAG + "onInterstitialDisplayed");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialDismissed(Ad ad) {
            YLog.d(TAG + "onInterstitialDismissed");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.d(TAG + "InterstitialAd onError, " + getNetworkError(adError));
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            YLog.d(TAG + "InterstitialAd onAdLoaded");
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            YLog.d(TAG + "InterstitialAd onLoggingImpression");
        }

        @Override
        public void onAdClicked(Ad ad) {
            YLog.d(TAG + "InterstitialAd onAdClicked");
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    final private RewardedVideoAdListener adVideoListener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoCompleted() {
            YLog.d(TAG + "onRewardedVideoCompleted");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            YLog.d(TAG + "VideoAd onLoggingImpression");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoClosed() {
            YLog.d(TAG + "onRewardedVideoClosed");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            YLog.d(TAG + "RewardedVideoAd onError, " + getNetworkError(adError));
            rewardedVideoLoading = false;
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, adError.getErrorCode(), adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            YLog.d(TAG + "RewardedVideoAd onAdLoaded");
            rewardedVideoLoading = false;
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdClicked(Ad ad) {
            YLog.d(TAG + "RewardedVideoAd onAdClicked");
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public String getSdkVersion() {
        return BuildConfig.VERSION_NAME;
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (interstitialAd != null) {
            interstitialAd.destroy();
            interstitialAd = null;
        }

        if (rewardedVideoAd != null) {
            rewardedVideoAd.destroy();
            rewardedVideoAd = null;
        }
    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        this.updatePrivacyConsent();

        AudienceNetworkAds.initialize(activity);
        AdSettings.addTestDevice("1d6b2709-fca3-4d75-a47a-7d0179a21350");

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful");

        if (initializeCallback != null) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
        }
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isInterInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String placementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_PLACEMENT_ID_INTERSTITIAL);
        if (TextUtils.isEmpty(placementId)) {
            YLog.d(TAG + "Initialize interstitial ad failure, placementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementId is null", getAdvertCode());
            return;
        }

        interstitialAd = new InterstitialAd(activity, placementId);
        interstitialAd.setAdListener(adInterListener);

        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful, placementId: " + placementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        YLog.d(TAG + "Showing interstitial ad...");

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                try {
                    if (interstitialAdvertIsLoaded(activity)) {
                        interstitialAd.show();
                    } else {
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
                    }
                } catch (Exception exception) {
                    callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "No cached ads", getAdvertCode());
                }
            }
        });
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isAdLoaded() && !interstitialAd.isAdInvalidated();
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");

        this.updatePrivacyConsent();

        if (interstitialAd != null) {
            interstitialAd.loadAd();
        }
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }

        if (this.isVideoInitialized()) {
            initializeCallback.onInitializeSuccess(getAdvertCode());
            return;
        }

        String placementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_PLACEMENT_ID_REWARDED_VIDEO);
        if (TextUtils.isEmpty(placementId)) {
            YLog.d(TAG + "Initialize rewarded video ad failure, placementId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "placementId is null", getAdvertCode());
            return;
        }

        rewardedVideoAd = new RewardedVideoAd(activity, placementId);
        rewardedVideoAd.setAdListener(adVideoListener);

        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful, placementId: " + placementId);
        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    /**
     * 播放
     *
     * @param activity Activity
     * @param callback Yodo1AdCallback
     */
    @Override
    public void showVideoAdvert(final Activity activity, final Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        YLog.d(TAG + "Showing rewarded video ad...");

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (videoAdvertIsLoaded(activity)) {
                    rewardedVideoAd.show();
                } else {
                    if (callback != null) {
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_NO_AD, "The AD has not been cached successfully, try again later.", getAdvertCode());
                    }
                }
            }
        });
    }

    /**
     * 预加载
     *
     * @param activity       Activity
     * @param reloadCallback Yodo1ReloadCallback
     */
    @Override
    public void reloadVideoAdvert(final Activity activity, final Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent();

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                // Check if rewardedVideoAd has been loaded successfully
                if (!videoAdvertIsLoaded(activity) && !rewardedVideoLoading) {
                    rewardedVideoAd.loadAd();
                    rewardedVideoLoading = true;
                }
            }
        }, 1000);
    }


    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return rewardedVideoAd != null && rewardedVideoAd.isAdLoaded() && !rewardedVideoAd.isAdInvalidated();
    }

    private void updatePrivacyConsent() {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            AdSettings.setMixedAudience(privacy.isAgeRestrictedUser());
            if (privacy.isAgeRestrictedUser()) {
                YLog.d(TAG + "(COPPA) The user is known to be in an age-restricted category (i.e., under the age of 16)");
            } else {
                YLog.d(TAG + "(COPPA) The user is not known to be in an age-restricted category (i.e., under the age of 16)");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }

    public String getNetworkError(AdError error) {
        return "errorCode:" + error.getErrorCode() + ", errorMessage:" + error.getErrorMessage();
    }
}
