package com.yodo1.advert.adapter;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.chartboost.sdk.CBLocation;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import com.chartboost.sdk.Privacy.model.CCPA;
import com.chartboost.sdk.Privacy.model.GDPR;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1AdInitializeCallback;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Privacy;

/**
 * @author sunmeng
 */
public class AdvertAdapterchartboost extends AdapterAdvertBase {
    private static final String TAG = "[AdvertAdapterchartboost] ";
    private static final String CHANNEL_CODE = "Chartboost";

    private static final String KEY_APP_ID = "ad_chartboost_app_id";
    private static final String KEY_SIGNATURE_ID = "ad_chartboost_signature_id";

    final private ChartboostDelegate delegate = new ChartboostDelegate() {

        @Override
        public boolean shouldRequestInterstitial(String location) {
            YLog.d(TAG + "shouldRequestInterstitial, location = " + location);
            return true;
        }

        @Override
        public boolean shouldDisplayInterstitial(String location) {
            YLog.d(TAG + "shouldDisplayInterstitial, location = " + location);
            return true;
        }

        @Override
        public void didCacheInterstitial(String location) {
            YLog.d(TAG + "didCacheInterstitial, location = " + location);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadInterstitial(String location, CBError.CBImpressionError error) {
            YLog.d(TAG + "didFailToLoadInterstitial, location = " + location + ", error = " + error);
            if (getReloadInterCallback() != null) {
                getReloadInterCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.name(), getAdvertCode());
            }
        }

        @Override
        public void didDismissInterstitial(String location) {
            YLog.d(TAG + "didDismissInterstitial, location = " + location);
        }

        @Override
        public void didCloseInterstitial(String location) {
            YLog.d(TAG + "didCloseInterstitial, location = " + location);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void didClickInterstitial(String location) {
            YLog.d(TAG + "didClickInterstitial, location = " + location);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void didDisplayInterstitial(String location) {
            YLog.d(TAG + "didDisplayInterstitial, location = " + location);
            if (getInterstitialCallback() != null) {
                getInterstitialCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void didFailToRecordClick(String uri, CBError.CBClickError error) {
            YLog.d(TAG + "didFailToRecordClick, error = " + error + ", uri = " + uri);
        }

        @Override
        public boolean shouldDisplayRewardedVideo(String location) {
            YLog.d(TAG + "shouldDisplayRewardedVideo, location = " + location);
            return true;
        }

        @Override
        public void didCacheRewardedVideo(String location) {
            YLog.d(TAG + "didCacheRewardedVideo, location = " + location);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadRewardedVideo(String location, CBError.CBImpressionError error) {
            YLog.d(TAG + "didFailToLoadRewardedVideo, location = " + location + ", error = " + error);
            if (getReloadVideoCallback() != null) {
                getReloadVideoCallback().onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, error.name(), getAdvertCode());
            }
        }

        @Override
        public void didDismissRewardedVideo(String location) {
            YLog.d(TAG + "didDismissRewardedVideo, location = " + location);
        }

        @Override
        public void didCloseRewardedVideo(String location) {
            YLog.d(TAG + "didCloseRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void didClickRewardedVideo(String location) {
            YLog.d(TAG + "didClickRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void didCompleteRewardedVideo(String location, int reward) {
            YLog.d(TAG + "didCompleteRewardedVideo, location = " + location + ", reward = " + reward);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void didDisplayRewardedVideo(String location) {
            YLog.d(TAG + "didDisplayRewardedVideo, location = " + location);
            if (getVideoCallback() != null) {
                getVideoCallback().onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void willDisplayVideo(String location) {
            YLog.d(TAG + "willDisplayVideo, location = " + location);
        }
    };

    @Override
    public String getAdvertCode() {
        return CHANNEL_CODE;
    }

    @Override
    public String getSDKVesion() {
        return Chartboost.getSDKVersion();
    }

    @Override
    public String getSdkVersion() {
        return Chartboost.getSDKVersion();
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void initSdk(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (this.isInitialized() || activity == null || initializeCallback == null) {
            return;
        }

        String appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_APP_ID);
        if (TextUtils.isEmpty(appId)) {
            appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_APP_ID);
        }
        String signatureId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, CHANNEL_CODE, KEY_SIGNATURE_ID);
        if (TextUtils.isEmpty(signatureId)) {
            signatureId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, CHANNEL_CODE, KEY_SIGNATURE_ID);
        }
        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(signatureId)) {
            YLog.d(TAG + "Initialize sdk  failure, appId or signatureId is null");
            initializeCallback.onInitializeFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL, 0, "appId or signatureId is null", getAdvertCode());
            return;
        }

        this.updatePrivacyConsent(activity);

        Chartboost.startWithAppId(activity.getApplicationContext(), appId, signatureId);
        Chartboost.setLoggingLevel(CBLogging.Level.ALL);
        Chartboost.setActivityAttrs(activity);
        Chartboost.setAutoCacheAds(true);
        Chartboost.setDelegate(delegate);

        this.setInitialized(true);
        YLog.d(TAG + "Initialize sdk successful, " + "appId: " + appId + ", signatureId: " + signatureId);

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void initInterstitialAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        this.setInterInitialized(true);
        YLog.d(TAG + "Initialize interstitial ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setInterstitialCallback(callback);
        checkDelegateAvailable("showIntersititalAdvert()");
        YLog.d(TAG + "Showing interstitial ad...");

        if (interstitialAdvertIsLoaded(activity)) {
            Chartboost.showInterstitial(CBLocation.LOCATION_LEADERBOARD);
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.setReloadInterCallback(callback);
        YLog.d(TAG + "Loading interstitial ad...");
        this.updatePrivacyConsent(activity);
        Chartboost.cacheInterstitial(CBLocation.LOCATION_LEADERBOARD);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return Chartboost.hasInterstitial(CBLocation.LOCATION_LEADERBOARD);
    }

    @Override
    public void initVideoAd(Activity activity, Yodo1AdInitializeCallback initializeCallback) {
        if (initializeCallback == null) {
            return;
        }
        this.setVideoInitialized(true);
        YLog.d(TAG + "Initialize rewarded video ad successful");

        initializeCallback.onInitializeSuccess(getAdvertCode());
    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.setVideoCallback(callback);
        checkDelegateAvailable("showVideoAdvert()");
        YLog.d(TAG + "Showing rewarded video ad...");

        if (videoAdvertIsLoaded(activity)) {
            Chartboost.showRewardedVideo(CBLocation.LOCATION_DEFAULT);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.setReloadVideoCallback(reloadCallback);
        YLog.d(TAG + "Loading rewarded video ad...");

        this.updatePrivacyConsent(activity);
        Chartboost.cacheRewardedVideo(CBLocation.LOCATION_DEFAULT);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Chartboost.hasRewardedVideo(CBLocation.LOCATION_DEFAULT);
    }

    @Override
    public void setPrivacy(Yodo1Privacy privacy, Activity context) {
        super.setPrivacy(privacy, context);
        YLog.d(TAG + "Set privacy, consent: " + privacy.isHasUserConsent() + ", is child: " + privacy.isAgeRestrictedUser());
    }

    private void updatePrivacyConsent(Activity activity) {
        Yodo1Privacy privacy = getPrivacy();
        if (privacy != null) {
            /*
             * GDPR support settings:
             * NON_BEHAVIORAL(0) means the user does not consent to targeting (Contextual ads)
             * BEHAVIORAL(1) means the user consents (Behavioral and Contextual Ads)
             */
            GDPR.GDPR_CONSENT gdprConsent = privacy.isHasUserConsent() ? GDPR.GDPR_CONSENT.BEHAVIORAL : GDPR.GDPR_CONSENT.NON_BEHAVIORAL;
            Chartboost.addDataUseConsent(activity, new GDPR(gdprConsent));
            if (privacy.isHasUserConsent()) {
                YLog.d(TAG + "(GDPR) The user has consented");
            } else {
                YLog.d(TAG + "(GDPR) The user has not consented");
            }
            /*
             * CCPA support settings:
             * OPT_IN_SALE(1NN-) means the user consents (Behavioral and Contextual Ads)
             * OPT_OUT_SALE(1NY-) means the user does not consent to targeting (Contextual ads)
             */
            CCPA.CCPA_CONSENT ccpaConsent = privacy.isDoNotSell() ? CCPA.CCPA_CONSENT.OPT_OUT_SALE : CCPA.CCPA_CONSENT.OPT_IN_SALE;
            Chartboost.addDataUseConsent(activity, new CCPA(ccpaConsent));
            if (privacy.isDoNotSell()) {
                YLog.d(TAG + "(CCPA) The user has opted out of the sale of their personal information");
            } else {
                YLog.d(TAG + "(CCPA) The user has not opted out of the sale of their personal information");
            }
        } else {
            YLog.d(TAG + "Privacy Settings was not obtained");
        }
    }

    /**
     * 检测当前的 Delegate 是否正常，不正常时重新设置，
     * 以规避某些原因导致的 Delegate 变为 null 导致奖励视频关闭没有回调引起的奖励收不到的问题
     *
     * @param method 调用方法名称，用于日志打印
     */
    private void checkDelegateAvailable(String method) {
        if (Chartboost.getDelegate() == null || !Chartboost.getDelegate().equals(delegate)) {
            YLog.d(TAG + method + "() Chartboost delegate is : " + Chartboost.getDelegate());
            Chartboost.setDelegate(delegate);
        }
    }
}
