package com.yodo1.advert;

import android.app.Activity;
import android.app.Application;

/**
 * @author yodo1
 */
public interface AdLifecycle {
    /**
     * Ad network's the method “onCreateApplication” of Application life cycle
     *
     * @param application Application
     */
    public void onCreateApplication(Application application);

    /**
     * Ad network's the method “onCreate” of Activity life cycle
     *
     * @param activity Activity
     */
    public void onCreate(Activity activity);

    /**
     * Ad network's the method “onResume” of Activity life cycle
     *
     * @param activity Activity
     */
    public void onResume(Activity activity);

    /**
     * Ad network's the method “onPause” of Activity life cycle
     *
     * @param activity Activity
     */
    public void onPause(Activity activity);

    /**
     * Ad network's the method “onDestroy” of Activity life cycle
     *
     * @param activity Activity
     */
    public void onDestroy(Activity activity);
}
