/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.unityads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.mediation.IUnityAdsExtendedListener;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.ads.metadata.PlayerMetaData;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

class UnityAdsAdapter
extends AbstractAdapter
implements IUnityAdsListener,
IUnityAdsExtendedListener {
    private static final String VERSION = "4.1.4";
    private static final String GitHash = "b49296b36";
    private Activity mActivity;
    private boolean mDidInit = false;
    private final String GAME_ID = "sourceId";
    private final String PLACEMENT_ID = "zoneId";
    private final String CONSENT_GDPR = "gdpr.consent";
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener = new ConcurrentHashMap();
    private CopyOnWriteArraySet<String> mISZoneReceivedFirstStatus = new CopyOnWriteArraySet();
    private Boolean mConsentCollectingUserData = null;

    public static UnityAdsAdapter startAdapter(String string) {
        return new UnityAdsAdapter(string);
    }

    private UnityAdsAdapter(String string) {
        super(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("UnityAds", VERSION);
        integrationData.activities = new String[]{"com.unity3d.services.ads.adunit.AdUnitActivity", "com.unity3d.services.ads.adunit.AdUnitTransparentActivity", "com.unity3d.services.ads.adunit.AdUnitTransparentSoftwareActivity", "com.unity3d.services.ads.adunit.AdUnitSoftwareActivity"};
        return integrationData;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        try {
            string = UnityAds.getVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return UnityAds.getVersion();
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    protected synchronized void setConsent(boolean bl) {
        if (this.mDidInit) {
            MetaData metaData = new MetaData((Context)this.mActivity);
            metaData.set("gdpr.consent", (Object)bl);
            metaData.commit();
        } else {
            this.mConsentCollectingUserData = bl;
        }
    }

    private synchronized void initSDK(Activity activity, String string) {
        if (!this.mDidInit) {
            this.mActivity = activity;
            MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
            mediationMetaData.setName("IronSource");
            mediationMetaData.setVersion(VERSION);
            mediationMetaData.commit();
            UnityAds.initialize((Activity)activity, (String)string, (IUnityAdsListener)this);
            boolean bl = false;
            try {
                bl = this.isAdaptersDebugEnabled();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            UnityAds.setDebugMode((boolean)bl);
            if (this.mConsentCollectingUserData != null) {
                this.setConsent(this.mConsentCollectingUserData);
            }
            this.mDidInit = true;
        }
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        String string3 = jSONObject.optString("sourceId");
        String string4 = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo gameId: <" + string3 + "> placementId: <" + string4 + ">", 1);
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initRewardedVideo: null listener", 3);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            this.mZoneIdToRvListener.put(string4, rewardedVideoSmashListener);
        }
        if (this.mISZoneReceivedFirstStatus.contains(string4)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string4));
        }
        this.initSDK(activity, string3);
    }

    public synchronized void fetchRewardedVideo(JSONObject jSONObject) {
        String string = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo with placementId: <" + string + ">", 1);
        RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo: null listener", 3);
            return;
        }
        if (UnityAds.isReady((String)string)) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
        } else if (UnityAds.getPlacementState((String)string) != UnityAds.PlacementState.WAITING) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public synchronized void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        String string = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showRewardedVideo placementId: <" + string + ">", 1);
        if (UnityAds.isReady((String)string)) {
            if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
                PlayerMetaData playerMetaData = new PlayerMetaData((Context)this.mActivity);
                playerMetaData.setServerId(this.getDynamicUserId());
                playerMetaData.commit();
            }
            UnityAds.show((Activity)this.mActivity, (String)string);
        } else if (rewardedVideoSmashListener != null) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return UnityAds.isReady((String)jSONObject.optString("zoneId"));
    }

    public synchronized void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string3 = jSONObject.optString("sourceId");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        String string4 = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initInterstitial gameId: <" + string3 + "> placementId: <" + string4 + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string4) && interstitialSmashListener != null) {
            this.mZoneIdToIsListener.put(string4, interstitialSmashListener);
        }
        this.initSDK(activity, jSONObject.optString("sourceId"));
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial placementId <" + string + ">", 1);
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + "null listener for placement Id <" + string + ">", 3);
            return;
        }
        if (UnityAds.isReady((String)string)) {
            interstitialSmashListener.onInterstitialAdReady();
        } else if (UnityAds.getPlacementState((String)string) != UnityAds.PlacementState.WAITING) {
            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"Ad unavailable"));
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial placementId <" + string + ">", 1);
        if (UnityAds.isReady((String)string)) {
            UnityAds.show((Activity)this.mActivity, (String)string);
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        String string = jSONObject.optString("zoneId");
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " isInterstitialReady placementId <" + string + ">", 1);
        return UnityAds.isReady((String)string);
    }

    public void onUnityAdsReady(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsReady placementId <" + string + ">", 1);
    }

    public void onUnityAdsStart(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsStart: placementId <" + string + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdOpened();
                rewardedVideoSmashListener.onRewardedVideoAdStarted();
            } else {
                InterstitialSmashListener interstitialSmashListener = this.mZoneIdToIsListener.get(string);
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialAdOpened();
                    interstitialSmashListener.onInterstitialAdShowSucceeded();
                }
            }
        }
    }

    public void onUnityAdsFinish(String string, UnityAds.FinishState finishState) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsFinish placementId: <" + string + "> finishState: " + finishState + ")", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string));
                if (finishState.equals((Object)UnityAds.FinishState.COMPLETED)) {
                    rewardedVideoSmashListener.onRewardedVideoAdEnded();
                    rewardedVideoSmashListener.onRewardedVideoAdRewarded();
                }
                rewardedVideoSmashListener.onRewardedVideoAdClosed();
            } else {
                InterstitialSmashListener interstitialSmashListener = this.mZoneIdToIsListener.get(string);
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialAdClosed();
                }
            }
        }
    }

    public void onUnityAdsError(UnityAds.UnityAdsError unityAdsError, String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " onUnityAdsError(errorType: " + unityAdsError + ", errorMessage: " + string + ")", 1);
    }

    public void onUnityAdsClick(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsClick placementId: <" + string + ">", 1);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdClicked();
            } else {
                InterstitialSmashListener interstitialSmashListener = this.mZoneIdToIsListener.get(string);
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialAdClicked();
                }
            }
        }
    }

    public synchronized void onUnityAdsPlacementStateChanged(String string, UnityAds.PlacementState placementState, UnityAds.PlacementState placementState2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " onUnityAdsPlacementStateChanged placementId: <" + string + "> from " + placementState + " to " + placementState2, 1);
        if (placementState2.equals((Object)placementState) || placementState2.equals((Object)UnityAds.PlacementState.WAITING)) {
            return;
        }
        this.mISZoneReceivedFirstStatus.add(string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            RewardedVideoSmashListener rewardedVideoSmashListener = this.mZoneIdToRvListener.get(string);
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(UnityAds.isReady((String)string));
            } else {
                InterstitialSmashListener interstitialSmashListener = this.mZoneIdToIsListener.get(string);
                if (interstitialSmashListener != null) {
                    if (UnityAds.isReady((String)string)) {
                        interstitialSmashListener.onInterstitialAdReady();
                    } else {
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)(string + " placement state: " + placementState2.toString())));
                    }
                }
            }
        }
    }
}

