/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardData;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class FacebookAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.4";
    private static final String GitHash = "4e476830a";
    private static final String MEDIATION_SERVICE_NAME = "Supersonic";
    public static int BN_FAILED_TO_RELOAD_ERROR_CODE = 103;
    private final String PLACEMENT_ID = "placementId";
    private ConcurrentHashMap<String, InterstitialSmashListener> mISPlacementToListenerMap;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mRVPlacementToListenerMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, BannerSmashListener> mBNPlacementToListenerMap;
    private ConcurrentHashMap<String, InterstitialAd> mISPlacementToAdMap;
    private ConcurrentHashMap<String, RewardedVideoAd> mRVPlacementToAdMap;
    private ConcurrentHashMap<String, AdView> mBNPlacementToAdMap;
    private ConcurrentHashMap<String, FacebookRewardedVideoAdListener> mRVPlacementToFBListener;
    private ConcurrentHashMap<String, FacebookInterstitialAdListener> mISPlacementToFBListener;
    private ConcurrentHashMap<String, Boolean> mRvAdsAvailability;
    private ConcurrentHashMap<String, Boolean> mInterstitialAdsAvailability;
    private Context mContext;
    private Boolean mDidInitSuccess = null;
    private AtomicBoolean mDidCallInit;

    public static FacebookAdapter startAdapter(String string) {
        return new FacebookAdapter(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("Facebook", VERSION);
        integrationData.activities = new String[]{"com.facebook.ads.AudienceNetworkActivity", "com.facebook.ads.internal.ipc.RemoteANActivity"};
        integrationData.services = new String[]{"com.facebook.ads.internal.ipc.AdsProcessPriorityService", "com.facebook.ads.internal.ipc.AdsMessengerService"};
        return integrationData;
    }

    private FacebookAdapter(String string) {
        super(string);
        this.mISPlacementToListenerMap = new ConcurrentHashMap();
        this.mBNPlacementToListenerMap = new ConcurrentHashMap();
        this.mRVPlacementToAdMap = new ConcurrentHashMap();
        this.mISPlacementToAdMap = new ConcurrentHashMap();
        this.mBNPlacementToAdMap = new ConcurrentHashMap();
        this.mRVPlacementToFBListener = new ConcurrentHashMap();
        this.mISPlacementToFBListener = new ConcurrentHashMap();
        this.mRvAdsAvailability = new ConcurrentHashMap();
        this.mInterstitialAdsAvailability = new ConcurrentHashMap();
        this.mDidCallInit = new AtomicBoolean(false);
        AdSettings.setMediationService((String)MEDIATION_SERVICE_NAME);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return FacebookAdapter.getAdapterSDKVersion();
    }

    public static String getAdapterSDKVersion() {
        return "5.3.1";
    }

    public void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " RV init failed: listener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: mContext is empty", 2);
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        String string3 = jSONObject.optString("placementId");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo failed: empty placementId", 2);
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo <" + string3 + ">", 1);
        FacebookRewardedVideoAdListener facebookRewardedVideoAdListener = new FacebookRewardedVideoAdListener(rewardedVideoSmashListener, string3);
        this.mRVPlacementToFBListener.put(string3, facebookRewardedVideoAdListener);
        this.mRVPlacementToListenerMap.put(string3, rewardedVideoSmashListener);
        this.mContext = activity.getApplicationContext();
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                this.loadRewardedVideo(string3);
            } else {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo <" + string3 + "> failed", 1);
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo <" + jSONObject.optString("placementId") + ">", 1);
        this.loadRewardedVideo(jSONObject.optString("placementId"));
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        String string = jSONObject.optString("placementId");
        return this.mRvAdsAvailability.containsKey(string) && this.mRvAdsAvailability.get(string) != false;
    }

    public void showRewardedVideo(JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        final String string = jSONObject.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showRewardedVideo <" + string + ">", 1);
        this.mRvAdsAvailability.put(string, false);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)FacebookAdapter.this.mRVPlacementToAdMap.get(string);
                    if (rewardedVideoAd != null && rewardedVideoAd.isAdLoaded()) {
                        if (!TextUtils.isEmpty((CharSequence)FacebookAdapter.this.getDynamicUserId())) {
                            rewardedVideoAd.setRewardData(new RewardData(FacebookAdapter.this.getDynamicUserId(), "1"));
                        }
                        rewardedVideoAd.show();
                    } else {
                        rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                    }
                }
                catch (Exception exception) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook rewarded video show failed - " + exception.getMessage(), 3);
                    rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError((String)"Rewarded Video", (String)exception.getMessage()));
                }
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        });
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " IS init failed: listener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: mContext is empty", 2);
            interstitialSmashListener.onInterstitialInitFailed(new IronSourceError(508, "empty mContext"));
            return;
        }
        String string3 = jSONObject.optString("placementId");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: empty placementId", 2);
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initInterstitial <" + string3 + ">", 1);
        FacebookInterstitialAdListener facebookInterstitialAdListener = new FacebookInterstitialAdListener(interstitialSmashListener, string3);
        this.mContext = activity.getApplicationContext();
        this.mISPlacementToListenerMap.put(string3, interstitialSmashListener);
        this.mISPlacementToFBListener.put(string3, facebookInterstitialAdListener);
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                interstitialSmashListener.onInterstitialInitSuccess();
            } else {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"init failed", (String)"Interstitial"));
            }
        }
    }

    public void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial <" + jSONObject.optString("placementId") + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = jSONObject.optString("placementId");
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        if (FacebookAdapter.this.mISPlacementToAdMap.containsKey(string)) {
                            ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(string)).destroy();
                            FacebookAdapter.this.mISPlacementToAdMap.remove(string);
                        }
                        InterstitialAd interstitialAd = new InterstitialAd(FacebookAdapter.this.mContext, string);
                        interstitialAd.setAdListener((InterstitialAdListener)FacebookAdapter.this.mISPlacementToFBListener.get(string));
                        interstitialAd.loadAd();
                        FacebookAdapter.this.mISPlacementToAdMap.put(string, interstitialAd);
                    } else {
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"empty placementId"));
                    }
                }
                catch (Exception exception) {
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)exception.getLocalizedMessage()));
                }
            }
        });
    }

    public void showInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        final String string = jSONObject.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial <" + string + ">", 1);
        this.mInterstitialAdsAvailability.put(string, false);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (FacebookAdapter.this.mISPlacementToAdMap.containsKey(string) && ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(string)).isAdLoaded()) {
                        ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(string)).show();
                    } else {
                        interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                    }
                }
                catch (Exception exception) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook Interstitial show failed - " + exception.getMessage(), 3);
                    interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError((String)"Interstitial", (String)exception.getMessage()));
                }
            }
        });
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        String string = jSONObject.optString("placementId");
        return this.mInterstitialAdsAvailability.containsKey(string) && this.mInterstitialAdsAvailability.get(string) != false;
    }

    public void initBanners(Activity activity, String string, String string2, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Banner init failed: BannerSmashListener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Banner init failed: mContext is empty", 2);
            bannerSmashListener.onBannerInitFailed(new IronSourceError(508, "empty mContext"));
            return;
        }
        String string3 = jSONObject.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initBanners <" + string3 + ">", 1);
        this.mContext = activity.getApplicationContext();
        this.mBNPlacementToListenerMap.put(string3, bannerSmashListener);
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                bannerSmashListener.onBannerInitSuccess();
            } else {
                bannerSmashListener.onBannerInitFailed(new IronSourceError(508, "init failed"));
            }
        }
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Facebook loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Facebook loadBanner banner == null", 3);
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)"banner layout is null");
            bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            return;
        }
        final String string = jSONObject.optString("placementId");
        if (TextUtils.isEmpty((CharSequence)string)) {
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)"FacebookAdapter loadBanner placementId is empty");
            bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            return;
        }
        final AdSize adSize = this.calculateBannerSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (adSize == null) {
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)"FacebookAdapter adSize is empty");
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)"Facebook"));
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadBanner <" + string + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    AdView adView = new AdView((Context)ironSourceBannerLayout.getActivity(), string, adSize);
                    FrameLayout.LayoutParams layoutParams = FacebookAdapter.this.calcLayoutParams(ironSourceBannerLayout.getSize(), ironSourceBannerLayout.getActivity());
                    AdListener adListener = FacebookAdapter.this.createBannerAdListener(layoutParams);
                    adView.setAdListener(adListener);
                    FacebookAdapter.this.mBNPlacementToAdMap.put(string, adView);
                    adView.loadAd();
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)("FacebookAdapter loadBanner exception " + exception.getMessage()));
                    bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
                }
            }
        });
    }

    public void destroyBanner(final JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " destroyBanner <" + jSONObject.optString("placementId") + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = jSONObject.optString("placementId");
                    if (FacebookAdapter.this.mBNPlacementToAdMap.containsKey(string)) {
                        ((AdView)FacebookAdapter.this.mBNPlacementToAdMap.get(string)).destroy();
                        FacebookAdapter.this.mBNPlacementToAdMap.remove(string);
                    }
                }
                catch (Exception exception) {
                    FacebookAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, FacebookAdapter.this.getProviderName() + ":destroyBanner() failed with an exception: " + exception, 2);
                }
            }
        });
    }

    public void reloadBanner(final JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " reloadBanner <" + jSONObject.optString("placementId") + ">", 0);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                String string = jSONObject.optString("placementId");
                if (FacebookAdapter.this.mBNPlacementToAdMap.containsKey(string)) {
                    ((AdView)FacebookAdapter.this.mBNPlacementToAdMap.get(string)).loadAd();
                } else if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(string)).onBannerAdLoadFailed(new IronSourceError(BN_FAILED_TO_RELOAD_ERROR_CODE, FacebookAdapter.this.getProviderName() + "reloadBanner missing banner " + string));
                }
            }
        });
    }

    private void loadRewardedVideo(final String string) {
        if (this.mContext != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (!TextUtils.isEmpty((CharSequence)string)) {
                                if (FacebookAdapter.this.mRVPlacementToAdMap.containsKey(string)) {
                                    ((RewardedVideoAd)FacebookAdapter.this.mRVPlacementToAdMap.get(string)).destroy();
                                    FacebookAdapter.this.mRVPlacementToAdMap.remove(string);
                                }
                                RewardedVideoAd rewardedVideoAd = new RewardedVideoAd(FacebookAdapter.this.mContext, string);
                                rewardedVideoAd.setAdListener((RewardedVideoAdListener)FacebookAdapter.this.mRVPlacementToFBListener.get(string));
                                rewardedVideoAd.loadAd();
                                FacebookAdapter.this.mRVPlacementToAdMap.put(string, rewardedVideoAd);
                            }
                        }
                        catch (Exception exception) {
                            if (!FacebookAdapter.this.mRVPlacementToListenerMap.containsKey(string)) break block4;
                            ((RewardedVideoSmashListener)FacebookAdapter.this.mRVPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                }
            });
        } else if (this.mRVPlacementToListenerMap.containsKey(string)) {
            this.mRVPlacementToListenerMap.get(string).onRewardedVideoAvailabilityChanged(false);
        }
    }

    private AdSize calculateBannerSize(ISBannerSize iSBannerSize, boolean bl) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": {
                return AdSize.BANNER_HEIGHT_50;
            }
            case "LARGE": {
                return AdSize.BANNER_HEIGHT_90;
            }
            case "RECTANGLE": {
                return AdSize.RECTANGLE_HEIGHT_250;
            }
            case "SMART": {
                return bl ? AdSize.BANNER_HEIGHT_90 : AdSize.BANNER_HEIGHT_50;
            }
            case "CUSTOM": {
                if (iSBannerSize.getHeight() == 50) {
                    return AdSize.BANNER_HEIGHT_50;
                }
                if (iSBannerSize.getHeight() == 90) {
                    return AdSize.BANNER_HEIGHT_90;
                }
                if (iSBannerSize.getHeight() != 250) break;
                return AdSize.RECTANGLE_HEIGHT_250;
            }
        }
        return null;
    }

    private FrameLayout.LayoutParams calcLayoutParams(ISBannerSize iSBannerSize, Activity activity) {
        int n2 = 320;
        if (iSBannerSize.getDescription().equals("RECTANGLE")) {
            n2 = 300;
        } else if (iSBannerSize.getDescription().equals("SMART") && AdapterUtils.isLargeScreen((Activity)activity)) {
            n2 = 728;
        }
        int n3 = AdapterUtils.dpToPixels((Activity)activity, (int)n2);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, -2);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    private void initSdk() {
        if (this.mDidCallInit.compareAndSet(false, true)) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initSdk", 1);
            if (AudienceNetworkAds.isInAdsProcess((Context)this.mContext)) {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initSdk: isInAdsProcess is true, no need to init", 1);
                this.mDidInitSuccess = true;
                return;
            }
            AudienceNetworkAds.buildInitSettings((Context)this.mContext).withInitListener(new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult initResult) {
                    FacebookAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, FacebookAdapter.this.getProviderName() + " init SDK is completed with status: " + initResult.isSuccess() + ", " + initResult.getMessage(), 1);
                    if (initResult.isSuccess()) {
                        FacebookAdapter.this.mDidInitSuccess = true;
                        for (Object object : FacebookAdapter.this.mBNPlacementToListenerMap.values()) {
                            object.onBannerInitSuccess();
                        }
                        for (Object object : FacebookAdapter.this.mISPlacementToListenerMap.values()) {
                            object.onInterstitialInitSuccess();
                        }
                        for (Object object : FacebookAdapter.this.mRVPlacementToListenerMap.keySet()) {
                            FacebookAdapter.this.loadRewardedVideo((String)object);
                        }
                    } else {
                        FacebookAdapter.this.mDidInitSuccess = false;
                        String string = "init failed:" + initResult.getMessage();
                        for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mBNPlacementToListenerMap.values()) {
                            bannerSmashListener.onBannerInitFailed(new IronSourceError(508, string));
                        }
                        for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mISPlacementToListenerMap.values()) {
                            bannerSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)string, (String)"Interstitial"));
                        }
                        for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mRVPlacementToListenerMap.values()) {
                            bannerSmashListener.onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                }
            }).initialize();
        }
    }

    private AdListener createBannerAdListener(final FrameLayout.LayoutParams layoutParams) {
        return new AdListener(){

            public void onError(Ad ad2, AdError adError) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onError (" + adError.getErrorCode() + "): " + adError.getErrorMessage(), 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    int n2;
                    BannerSmashListener bannerSmashListener = (BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId());
                    int n3 = n2 = adError.getErrorCode() == 1001 ? 606 : adError.getErrorCode();
                    if (adError.getErrorMessage() != null) {
                        String string = adError.getErrorCode() + ":" + adError.getErrorMessage();
                        bannerSmashListener.onBannerAdLoadFailed(new IronSourceError(n2, string));
                    } else {
                        bannerSmashListener.onBannerAdLoadFailed(new IronSourceError(n2, "Empty error string"));
                    }
                }
            }

            public void onAdLoaded(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onAdLoaded <" + ad2.getPlacementId() + ">", 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId()) && FacebookAdapter.this.mBNPlacementToAdMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdLoaded((View)FacebookAdapter.this.mBNPlacementToAdMap.get(ad2.getPlacementId()), layoutParams);
                }
            }

            public void onAdClicked(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onAdClicked", 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onLoggingImpression", 1);
            }
        };
    }

    private class FacebookRewardedVideoAdListener
    implements RewardedVideoAdListener {
        private String mPlacementId;
        private RewardedVideoSmashListener mListener;

        FacebookRewardedVideoAdListener(RewardedVideoSmashListener rewardedVideoSmashListener, String string) {
            this.mPlacementId = string;
            this.mListener = rewardedVideoSmashListener;
        }

        public void onRewardedVideoCompleted() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "onRewardedVideoCompleted <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdEnded();
            this.mListener.onRewardedVideoAdRewarded();
        }

        public void onLoggingImpression(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onLoggingImpression <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdOpened();
            this.mListener.onRewardedVideoAdStarted();
        }

        public void onRewardedVideoClosed() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "onRewardedVideoClosed <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdClosed();
        }

        public void onError(Ad ad2, AdError adError) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onError; error: <" + this.mPlacementId + "> " + adError.getErrorMessage(), 1);
            this.mListener.onRewardedVideoAvailabilityChanged(false);
            FacebookAdapter.this.mRvAdsAvailability.put(this.mPlacementId, false);
        }

        public void onAdLoaded(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onAdLoaded <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAvailabilityChanged(true);
            FacebookAdapter.this.mRvAdsAvailability.put(this.mPlacementId, true);
        }

        public void onAdClicked(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onAdClicked <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdClicked();
        }
    }

    private class FacebookInterstitialAdListener
    implements InterstitialAdListener {
        private String mPlacementId;
        private InterstitialSmashListener mListener;

        FacebookInterstitialAdListener(InterstitialSmashListener interstitialSmashListener, String string) {
            this.mPlacementId = string;
            this.mListener = interstitialSmashListener;
        }

        public void onInterstitialDisplayed(Ad ad2) {
        }

        public void onInterstitialDismissed(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "onInterstitialDismissed <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdClosed();
        }

        public void onError(Ad ad2, AdError adError) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Interstitial Ad <" + this.mPlacementId + ">  onError: " + adError.getErrorMessage(), 1);
            this.mListener.onInterstitialAdLoadFailed(new IronSourceError(adError.getErrorCode(), adError.getErrorMessage() + ""));
            FacebookAdapter.this.mInterstitialAdsAvailability.put(this.mPlacementId, false);
        }

        public void onAdLoaded(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Interstitial Ad, onAdLoaded <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdReady();
            FacebookAdapter.this.mInterstitialAdsAvailability.put(this.mPlacementId, true);
        }

        public void onAdClicked(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Interstitial Ad, onAdClicked <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdClicked();
        }

        public void onLoggingImpression(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Interstitial Ad, onLoggingImpression <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdOpened();
            this.mListener.onInterstitialAdShowSucceeded();
        }
    }
}

