package com.yodo1.sdk.kit;

import android.util.Log;

/**
 * Yodo1的Log输出
 */
public class YLog {
    public final static String TAG = "yodo1-games-sdk";
    private static boolean onLog = false;
    private static boolean onDebug = false;

    public static void setOnLog(boolean isLog) {
        YLog.onLog = isLog;
    }

    public static void setDebugMode(boolean isDebug) {
        onDebug = isDebug;
    }


    public final static void v(String content) {
        v(TAG, Log.VERBOSE, content, null);
    }

    public final static void v(String tag, int level, String content, Exception e) {
        print(tag, level, content, e);
    }

    public final static void d(String content) {
        d(TAG, Log.DEBUG, content, null);
    }

    public final static void d(String tag, int level, String content, Exception e) {
        print(tag, level, content, e);
    }

    public final static void i(String content) {
        i(TAG, Log.INFO, content, null);
    }

    public final static void i(String tag, int level, String content, Exception e) {
        print(tag, level, content, e);
    }

    public final static void w(String content) {
        w(TAG, Log.WARN, content, null);
    }

    public final static void w(String tag, int level, String content, Exception e) {
        print(tag, level, content, e);
    }


    public final static void e(String content) {
        e(TAG, Log.ERROR, content, null);
    }

    public final static void e(String tag, int level, String content, Exception e) {
        print(tag, level, content, e);
    }


    public final static void print(String tag, int level, String content, Exception e) {


        switch (level) {
            case Log.DEBUG:
                if (onDebug) {
                    Log.d(tag, content, e);
                }
                break;

            case Log.INFO:
                if (onLog) {
                    Log.i(tag, content, e);
                }

                break;

            case Log.VERBOSE:
                Log.v(tag, content, e);
                break;

            case Log.WARN:
                Log.w(tag, content, e);
                break;

            case Log.ERROR:
                Log.e(tag, content, e);
                break;
        }
    }
}
